<?php 

add_action( 'vc_before_init', 'themesflat_event_shortcode_params' );
// Element Class 
function themesflat_event_shortcode_params() {
    vc_map( 
  
        array(

            'name'                    =>esc_html__( 'Themesflat: Event', 'bookflare' ),
			'base'                    => 'event',
			'category'                =>esc_html__( 'Themesflat', 'bookflare' ),
			'icon' 					  => THEMESFLAT_ICON,
			'params'                  => array(	
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( ' List or Grid colums show event', 'bookflare' ),
					'param_name' => 'style',
					'value'       => array(		
						esc_html__( 'Style 1', 'bookflare' ) => 'style1',					
						esc_html__( 'Style 2', 'bookflare' ) => 'style2',
						esc_html__( 'Style 3', 'bookflare' ) => 'style3',	
						),
					'std '		 => 'style1'
				),
				array(
					'type'        => 'dropdown',
					'heading'     => esc_html__( 'Grid Columns', 'bookflare' ),
					'param_name'  => 'grid_columns',
					'description' => esc_html__( 'The number of columns for grid and grid masonry layout', 'bookflare' ),
					'dependency' => array(
						'element' => 'style',
						'value'	=> array('style2','style3'),
						),
					'value'       => array(
						esc_html__( '1 Columns', 'bookflare' ) => 1,							
						esc_html__( '2 Columns', 'bookflare' ) => 2,
						esc_html__( '3 Columns', 'bookflare' ) => 3,						
						esc_html__( '4 Columns', 'bookflare' ) => 4
						)
					),
				array(
				  'type' => 'textfield',
				  'heading' => __( 'Number post',  'bookflare' ),
				  'param_name' => 'number_post',
				  'value' => __( '12', 'bookflare' ),
				),
				array(
				  'type' => 'textfield',
				  'heading' => __( 'Number text description except',  'bookflare' ),
				  'param_name' => 'number_post_except',
				  'value' => __( '20', 'bookflare' ),
				),
				array(
				  'type' => 'textfield',
				  'heading' => __( 'Number text description except Author',  'bookflare' ),
				  'param_name' => 'number_post_except_author',
				  'dependency' => array(
						'element' => 'style',
						'value'	=> array('style2','style1'),
						),
				  'value' => __( '10', 'bookflare' ),
				),
				array(
				  'type' => 'textfield',
				  'heading' => __( 'Show  Post by Post ID Number (Ex:150,213,...)',  'bookflare' ),
				  'param_name' => 'number_post_show_id',
				  'value' => __( '', 'bookflare' ),
				),
				array(
				  'type' => 'textfield',
				  'heading' => __( 'List Exclude (Ex: 102,321,...)',  "bookflare" ),
				  'param_name' => 'number_post_exclude',
				  'value' => __( '', 'bookflare' ),
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Order by', 'bookflare' ),
					'param_name' => 'order_by',
					'value' => array(
						esc_html__( 'ID', 'bookflare' )   => 'ID',
						esc_html__( 'author', 'bookflare' )   => 'author',
						esc_html__( 'title', 'bookflare' )   => 'title',
						esc_html__( 'name', 'bookflare' )   => 'name',
						esc_html__( 'date', 'bookflare' )   => 'date'
						),
					'std '		 => 'date'
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Order List post', 'bookflare' ),
					'param_name' => 'order_direction',
					'value' => array(
						esc_html__( 'DESC', 'bookflare' )   => 'DESC',
						esc_html__( 'ASC', 'bookflare' )   => 'ASC'
						),
					'std '		 => 'DESC'
				),
				array(
					'type'       => 'checkbox',
					'heading'    => esc_html__( 'Enable Pagination', 'bookflare' ),
					'param_name' => 'blog_pagination',
					'value'      => array(
						esc_html__( 'Yes, please', 'bookflare' ) => 'yes'
						),
					'std '		 => 'no'
				),
				array(
				'type' => 'colorpicker',
				'heading'    => esc_html__( 'Background Color Event', 'bookflare' ),
				'param_name' => 'color_title',
				'group' => esc_html__( 'Design Options', 'bookflare' ),
				
				),
           )
        )
    );                        
    
}    
 
add_shortcode( 'event', 'themesflat_shortcode_event' );
 function themesflat_shortcode_event( $atts,$content = null ) {
    vc_map_get_attributes( 'event', $atts );
    extract(
        shortcode_atts(
            array(
            	'style' 					=>'style1',
            	'number_post'				=>'12',
            	'order_direction'			=>'DESC',
            	'order_by'					=>'date',
            	'number_post_except' 		=>'20',
            	'number_post_except_author'	=>'10',
            	'blog_pagination'			=>'no',
            	'grid_columns'				=>3,
            	'number_post_show_id'		=>'',
            	'number_post_exclude'		=> '',
            	'color_title'				=>'#f3728b',
            ), 
            $atts
        )
    );
    $event_columns = $grid_columns;
    switch ($event_columns) {
    case 1:
		$event_columns_class = 'col-12';
		break;
	case 2:
		$event_columns_class = 'col-lg-6 col-md-6';
		break;
	case 3:
		$event_columns_class = 'col-lg-4 col-md-6';
		break;
	default:
		$event_columns_class = 'col-lg-3 col-md-6';
		break;
	}
    if ( get_query_var('paged') ) {
			$paged = get_query_var('paged');
		} elseif ( get_query_var('page') ) {
			$paged = get_query_var('page');
		} else {
			$paged = 1;
		}
    // WP_Query arguments
		$args = array(
			'post_type'              => array( 'event' ),
			'post_status'            => array( 'publish' ),
			'nopaging'               => false,
			'posts_per_page'         => $number_post,
			'paged' 				 => $paged, 
			'order'                  => $order_direction,
			'orderby'                => $order_by,
			'post__not_in' 			 => explode(",", $number_post_exclude),
		);
		$args_mer = array();

		if($number_post_show_id !== ''){
			$args_mer = array('post__in' =>	explode(',', $number_post_show_id),
						);
		}

		$args_s = array_merge($args,$args_mer);
    ob_start();
    $query = new WP_Query( $args_s );
	$GLOBALS['wp_query']->max_num_pages = $query->max_num_pages;
	$count_evt = 0;
	switch ($style) {
		case 'style1':?>
			<div class="flat-events style1">
				<?php if ( $query->have_posts() ) {
				while ( $query->have_posts() ) {
					$query->the_post();
					$post_ID = get_the_ID();
					if ( themesflat_meta('time_event') ) {
                		$time = strtotime(themesflat_meta('time_event'));
                		$day = date('l',$time);
                		$month = date('F j',$time);
                		$day_img = date('d',$time);
                		$month_img = date('F',$time);
                		}
					if($count_evt == 0 || $count_evt % 2 == 0){?>
						<div class="event style1 v1">
			                <div class="row">
			                    <div class=" col-lg-7 col-md-12">
			                        <div class="event-img">
			                            <a href="<?php the_permalink( ); ?>"><?php the_post_thumbnail('themesflat-event-list-shortcode', array('class'=>'responsive transition-img','alt' => esc_html ( get_the_title() )) ); ?></a>
			                            <?php if ( themesflat_meta('time_event') ) { ?>
				                            <div class="meta-date flat-text-center">
				                                <span class="day"><?php echo esc_attr($day_img); ?></span>
				                                <span class="month"><?php echo esc_attr($month_img); ?></span>
				                            </div>
				                        <?php } ?>
			                        </div>
			                    </div>
			                    <div class=" col-lg-5 col-md-12">
			                        <div class="event-content">
			                            <div class="meta-datetime">
			                                <ul class="list">
			                                	<?php if ( themesflat_meta('time_event',$post_ID) ) {?>
				                                	<li><?php echo esc_attr($day); ?></li>
				                                    <li><?php echo esc_attr($month); ?></li>
				                                    <li><?php echo esc_attr(themesflat_meta('start_time')); ?></li> 
				                                	<?php 
			                                		}
			                                	?>
			                                </ul>
			                            </div>
			                            <div class="content">
			                                <h3 class="title"><a href="<?php the_permalink( ); ?>"><?php the_title(); ?></a></h3>
			                                <p class="description"><?php echo get_the_excerpt(); ?></p>
			                            </div>
			                            <?php $tflat_teacher = get_post_meta(get_the_ID(), '_custom_course_options', true);
												themesflat_teacher_event($tflat_teacher['teacher'],$number_post_except_author);?>
			                        </div>
			                    </div>
			                </div>
			            </div>
					<?php }else { ?>
						<div class="event style1 v2">
			                <div class="row">
			                	<div class=" col-lg-7 col-md-12 order-lg-7">
			                        <div class="event-img">
			                            <a href="<?php the_permalink($post_ID); ?>"><?php echo get_the_post_thumbnail($post_ID,'themesflat-event-list-shortcode', array('class'=>'responsive transition-img','alt' => esc_html ( get_the_title() )) ); ?></a>
			                            <?php if ( themesflat_meta('time_event',$post_ID) ) { ?>
				                            <div class="meta-date flat-text-center">
				                                <span class="day"><?php echo esc_attr($day_img); ?></span>
				                                <span class="month"><?php echo esc_attr($month_img); ?></span>
				                            </div>
				                        <?php } ?>
			                        </div>
			                    </div>
			                    <div class=" col-lg-5 col-md-12 order-lg-5">
			                        <div class="event-content">
			                            <div class="meta-datetime">
			                                <ul class="list">
												<?php if ( themesflat_meta('time_event') ) {?>
				                                	<li><?php echo esc_attr($day); ?></li>
				                                    <li><?php echo esc_attr($month); ?></li>
				                                    <li><?php echo esc_attr(themesflat_meta('start_time')); ?></li>
				                                	<?php 
			                                		}
			                                	?>
			                                </ul>
			                            </div>
			                            <div class="content">
			                                 <h3 class="title"><a href="<?php the_permalink( ); ?>"><?php the_title(); ?></a></h3>
			                                <p class="description"><?php echo get_the_excerpt(); ?></p>
			                            </div>
			                            <?php $tflat_teacher = get_post_meta(get_the_ID(), '_custom_course_options', true);
												themesflat_teacher_event($tflat_teacher['teacher'],$number_post_except_author);?>
			                        </div>
			                    </div>
			                </div>
			            </div>
					<?php }
	            	$count_evt++;
	        		}
				} else {
				}
				wp_reset_postdata();
	    	 ?>
	        </div> <!-- /.flat-events -->
		<?php break;
		case 'style3':?>
			<div class="flat-events style3">
	            <div class="row">
	            	<?php 
	            	if ( $query->have_posts() ) {
					while ( $query->have_posts() ) {
						$query->the_post();
						$post_ID = get_the_ID();

						if ( themesflat_meta('time_event') ) {
	                		$time = strtotime(themesflat_meta('time_event'));
	                		$day = date('l',$time);
	                		$month = date('F j',$time);
	                		$day_img = date('d',$time);
	                		$month_img = date('M',$time);
	                		}
	                	if (intval($day_img) <= 10) {
	                		$bg_color = esc_attr('bg-f3728b');
	                	} else if(intval($day_img) > 10 && intval($day_img) <= 20){
	                		$bg_color = esc_attr('bg-ffa81e');
	                	}else{
	                		$bg_color = esc_attr('bg-0046d4');
	                	}
	                	?>
	                <div class="<?php themesflat_esc_attr($event_columns_class);?> col-md-12">
	                    <div class="event style3   flat-text-center">
	                        <div class="event-img">
	                            <a href="<?php the_permalink( ); ?>"><?php the_post_thumbnail('themesflat-portfolio-grid', array('class'=>'responsive transition-img','alt' => esc_html ( get_the_title() )) ); ?></a>
	                        </div>
	                        <div class="event-content">
	                            <h4 class="title"><a href="<?php the_permalink(  ); ?>"><?php the_title(); ?></a></h4>
	                            <p class="description"><?php echo themesflat_custom_excerpt(get_the_ID(),intval($number_post_except));?></p>
	                            <div class="meta-list">
	                                <ul class="list">
	                                    <?php if ( themesflat_meta('location_map',$post_ID) ) { ?>
				                            <li class="address"><?php echo esc_attr(themesflat_meta('location_map',$post_ID),'bookflare') ?></li>
				                        <?php } 
		                                	$start_time = explode(' ',themesflat_meta('start_time'));
		                                	$end_time = explode(' ',themesflat_meta('end_time'));
		                                ?>
				                        <li class="time"><?php echo esc_attr($start_time[0]); ?></li>
	                                </ul>
	                            </div>
	                            <div class="meta-date flat-text-center <?php echo $bg_color; ?>">
	                                <p class="day"><?php echo esc_attr($day_img); ?></p>
	                                <p class="month"><?php echo esc_attr($month_img); ?></p>
	                            </div>
	                        </div>
	                    </div>
	                </div>
	                <?php  	
	            	}
						} else {
							}
				wp_reset_postdata();
				?>
	            </div>
	        </div>
		<?php break;
		default: ?>
		<div class="flat-events style2">
            <div class="row">
            	<?php if ( $query->have_posts() ) {
				while ( $query->have_posts() ) {
					$query->the_post();
					$post_ID = get_the_ID();
					if ( themesflat_meta('time_event') ) {
                		$time = strtotime(themesflat_meta('time_event'));
                		$day = date('l',$time);
                		$month = date('F j',$time);
                		$day_img = date('d',$time);
                		$month_img = date('F',$time);
                		}?>
			                <div class="<?php themesflat_esc_attr($event_columns_class);?>">
			                    <div class="event style2">
			                        <div class="event-img">
			                            <a href="<?php the_permalink( ); ?>"><?php the_post_thumbnail('themesflat-courser-shortcode', array('class'=>'responsive transition-img','alt' => esc_html ( get_the_title() )) ); ?></a>
			                        </div>
			                        <div class="event-content">
			                            <h6 class="title"><a href="<?php the_permalink(  ); ?>"><?php the_title(); ?></a></h6>
			                            <div class="meta-list">
			                                <ul class="list"><?php 
			                                	$start_time = explode(' ',themesflat_meta('start_time'));
			                                	$end_time = explode(' ',themesflat_meta('end_time'));
			                                 ?>
			                                    <li class="time"><?php echo esc_attr($start_time[0]).' - '.esc_attr($end_time[0]) ; ?></li>
			                                    <?php if ( themesflat_meta('location_map',$post_ID) ) { ?>
			                                    	<li class="address"><?php echo esc_attr(themesflat_meta('location_map',$post_ID),'bookflare') ?></li>
			                                    <?php } ?>
			                                </ul>
			                            </div>
			                           <?php if ( themesflat_meta('time_event',$post_ID) ) { ?>
				                            <div class="meta-date flat-text-center " style="background:<?php echo esc_html($color_title);  ?>">
				                                <span class="day"><?php echo esc_attr($day_img); ?></span>
				                                <span class="month"><?php echo esc_attr($month_img); ?></span>
				                            </div>
				                        <?php } ?>
			                        </div>
			                    </div>
			                </div>
               <?php    	}
						} else {
								}
			wp_reset_postdata();
			?>
            </div>
        </div> <!-- /.flat-events -->
		<?php break;
	}
		if ( $blog_pagination == 'yes' ): ?>
            <div class="flat-paginations_courses">
				<?php
					get_template_part( 'tpl/pagination' );		
				?>
			</div>     
		<?php endif;
    return ob_get_clean(); 
} 