<?php
/**
 * Register shortcode into Visual Composer
 */
add_action( 'vc_before_init', 'themesflat_iconbox_shortcode_params' );

/**
 * Register parameters for iconbox shortcode
 * 
 * @return  void
 */
function themesflat_iconbox_shortcode_params() {
	$icons_params = themesflat_map_icons('icon','IconBox');
	$params = array_merge( $icons_params, array(
		// Title
		array(
			'type'             => 'textfield',
			'heading'          =>esc_html__( 'Title iconbox ', 'bookflare' ),
			'param_name'       => 'title'
		),

		array(
			'type'       => 'dropdown',
			'heading'    =>esc_html__( 'Choice Style', 'bookflare' ),
			'param_name' => 'select_style',
			'value' => array(
				__( 'Normal', 'bookflare' ) => 'normal',
				__( 'Count', 'bookflare' ) => 'count',
				__( 'List Category', 'bookflare' ) => 'list',
			),
			'std '		 => 'normal'
		),

		array(
			'type'             => 'textfield',
			'heading'          =>esc_html__( 'Number count', 'bookflare' ),
			'param_name'       => 'number',
			'dependency' => array(
						'element' => 'select_style',
						'value'	=> array('count'),
						),
		),

		array(
			'type'             => 'textfield',
			'heading'          =>esc_html__( 'Speed', 'bookflare' ),
			'param_name'       => 'speed_number',
			'dependency' => array(
						'element' => 'select_style',
						'value'	=> array('count'),
						),
			'description' => __('Speed use seconds Ex:2000', 'bookflare')
		),
		array(
			'type' => 'colorpicker',
			'heading'    => esc_html__( 'Color text and number', 'bookflare' ),
			'param_name' => 'icon_color_text',
			'dependency' => array(
						'element' => 'select_style',
						'value'	=> array('count'),
						),
			'std' => '#ffffff'
			),

		// Image Icon
		array(
            'type' => 'attach_image',
            'class' => '',
            'heading' => __('Image Icon', 'bookflare'),
            'param_name' => 'image',
            'value' => '',
            'description' => __('Select image icon in this element', 'bookflare')
        ),
		
		// Button link
		array(
			'type' => 'textfield',
			'heading' =>esc_html__( 'Button Link', 'bookflare' ),
			'param_name' => 'link',
			'description' =>esc_html__( 'Enter your url', 'bookflare' ),
			'dependency' => array(
						'element' => 'select_style',
						'value'	=> array('normal','list'),
						),
			'value' => esc_html__( '#', 'bookflare' ),
		),

		// Button text
		array(
			'type' => 'textfield',
			'heading' =>esc_html__( 'Button Text', 'bookflare' ),
			'param_name' => 'text',
			'dependency' => array(
						'element' => 'select_style',
						'value'	=> array('normal'),
						),
			'description' =>esc_html__( 'Enter custom text for read more button', 'bookflare' ),
			'value' =>esc_html__( 'Read More ...', 'bookflare' ),
			
		),		

		// Icon align
		array(
			'type'       => 'dropdown',
			'heading'    =>esc_html__( 'Choice Style', 'bookflare' ),
			'param_name' => 'icon_position',
			'dependency' => array(
						'element' => 'select_style',
						'value'	=> array('normal','list'),
						),
			'value' => array(
				__( 'Top', 'bookflare' ) => 'top',
				__( 'Left', 'bookflare' ) => 'left',
				__( 'Top style 2', 'bookflare' ) => 'inline-left',
				__( 'Right', 'bookflare' ) => 'right',
				__( 'Center-center', 'bookflare' ) => 'center-center'
			),
			
		),

		// Icon type
		array(
			'type'       => 'dropdown',
			'heading'    =>esc_html__( 'Icon Type', 'bookflare' ),
			'param_name' => 'icon_style',
			'value' => array(
				__( 'Default', 'bookflare' )         => 'default',
				__( 'Circle', 'bookflare' )          => 'circle'
			),
			'dependency' => array(
						'element' => 'select_style',
						'value'	=> array('normal'),
						),
		),
		array(
			'type' => 'colorpicker',
			'heading'    => esc_html__( 'Color Icon', 'bookflare' ),
			'param_name' => 'icon_color',
			'std' => '#ffffff'
			),
		array(
			'type' => 'colorpicker',
			'heading'    => esc_html__( 'Color Icon Background', 'bookflare' ),
			'param_name' => 'icon_color_bk',
			'std' => '#192836'
			),
		array(
			'type' => 'colorpicker',
			'heading'    => esc_html__( 'Color Text', 'bookflare' ),
			'param_name' => 'nomal_text',
			'dependency' => array(
					'element' => 'select_style',
					'value'	=> array('normal'),
					),
			'std' => '#192836'
			),
		array(
			'type' => 'colorpicker',
			'heading'    => esc_html__( 'Color Text Hover', 'bookflare' ),
			'param_name' => 'nomal_text_hover',
			'dependency' => array(
					'element' => 'select_style',
					'value'	=> array('normal'),
					),
			'std' => '#ffffff'
			),
		array(
			'type' => 'checkbox',
			'heading'    => esc_html__( 'Check Box Active', 'bookflare' ),
			'param_name' => 'check_icon_box',
			'value' => array(
				__( 'Yes', 'bookflare' )         => 'yes'),
			'std' => 'no',
			'dependency' => array(
						'element' => 'select_style',
						'value'	=> array('normal','count'),
						),
				
		),
		array(
			'type'       => 'dropdown',
			'heading'    =>esc_html__( 'Rotate Icon', 'bookflare' ),
			'param_name' => 'icon_style_rotate',
			'value' => array(
				__( 'Left', 'bookflare' )         => 'left',
				__( 'Right', 'bookflare' )          => 'right',
				__( 'Center', 'bookflare' )          => 'center'
			),
			'std' => 'center',
			'dependency' => array(
						'element' => 'select_style',
						'value'	=> array('normal'),
						),
		),
		// Extra Class
		array(
			'type'       => 'textfield',
			'heading'    =>esc_html__( 'Extra Class', 'bookflare' ),
			'param_name' => 'class'
		),

		array(
			'type' => 'css_editor',
			'param_name' => 'css',
			'group' =>esc_html__( 'Design Options', 'bookflare' )
		),
			
	));	

	vc_map( array(
		'base'        => 'iconbox',
		'name'        =>esc_html__( 'Themesflat: Icon Box', 'bookflare' ),
		'icon' 		  => THEMESFLAT_ICON,
		'category'    =>esc_html__( 'Themesflat', 'bookflare' ),
		'params'      => $params
	) );
}

add_shortcode( 'iconbox', 'themesflat_shortcode_iconbox' );

/**
 * Iconbox shortcode handle
 * 
 * @param   array  $atts  Shortcode attributes
 * @return  void
 */
function themesflat_shortcode_iconbox( $atts, $content = null ) {
	$atts = vc_map_get_attributes( 'iconbox', $atts );
	$class = apply_filters( 'themesflat/shortcode/iconbox_class', array( 'iconbox', $atts['class']), $atts );
	$nomal_text  = sprintf('%1$s',$atts['nomal_text']);
	$nomal_text_hover  = sprintf('%1$s',$atts['nomal_text_hover']);
	$icon_name = themesflat_shortcode_icon_name('icon_',$atts['icon_type']);
   	$icon_value = !empty( $icon_name ) ? $atts[$icon_name] : '';
   	if($atts['check_icon_box']=='yes'){$check_icon_box =  esc_attr('active');}else{$check_icon_box ='';};
   	if($atts['icon_style_rotate']=='left'){$icon_style_rotate =  esc_attr('-20');}
   	else if($atts['icon_style_rotate']=='right'){$icon_style_rotate =  esc_attr('12');}else{$icon_style_rotate =esc_attr('0');};
	$colorpicker = sprintf('%1$s',$atts['icon_color']);
	$colorpicker_text = sprintf('%1$s',$atts['icon_color_text']);
	
	$flat_icon = sprintf( '<i class="%s"></i>', $icon_value );
	$flat_box_icon = $flat_icon ? sprintf( '<div class="flat-iconbox-icon" style="color:%2$s;">%1$s</div>', $flat_icon,$colorpicker ) : '';
	$flat_box_readmore = '';
	if ( ! empty( $atts['link'] ) && ! empty( $atts['text'] ) ) {
		if($atts['icon_position'] == 'top'){
			$flat_box_readmore = sprintf( '
			<p class="box-readmore">
				<a href="%s" class="btn-hover">%s</a>
			</p>', esc_url( $atts['link'] ), esc_html( $atts['text'] ) );
		}else{
			$flat_box_readmore = sprintf( '
			<p class="box-readmore">
				<a href="%s">%s</a>
			</p>', esc_url( $atts['link'] ), esc_html( $atts['text'] ) );
		}
	}
	$icon_image = '';
	$id_color = 'id-'.uniqid();
	$start = '';
	$end = '';
	if(! empty($atts['image'])){
		$icon_image = sprintf( '%s', wp_get_attachment_image( $atts['image'], 'full', false,array('class'=>'responsive')));
		$start = '<div class="fix-size-img">';
		$end = '</div>';
	}
	$choice_icon = $icon_image;
	$speed='';
	if($atts['speed_number'] != ''){
		$speed = $atts['speed_number'];
	}else {
		$speed = 2000;
	}
	switch ($atts['select_style']) {
		case 'normal':
			return sprintf( '
				<div class="flat-iconbox one-of-three clearfix style3 ">
			        <div class="iconbox style3 flat-text-center %11$s %15$s" data-normal_text_hover="%14$s" data-id_color = "%15$s">
			            <div class="iconbox-icon" style="transform: rotate(%12$sdeg);">%8$s%1$s</div>
			            <div class="iconbox-content">
			                <h6 class="title flat-text-center"><a href="%5$s" style="color:%13$s">%3$s</a></h6>
			            </div>
			        </div>
			    </div>', 
				$flat_box_icon,
			 	esc_attr( $atts['class'] ),
			  	esc_html( $atts['title'] ), 
			 	wp_kses_post ($content), 
			 	$flat_box_readmore,
			  	esc_attr( $atts['icon_position'] ), 
			 	esc_attr( $atts['icon_style'] ),
			  	$choice_icon,
			  	$start,
			  	$end,
			  	$check_icon_box,
			  	$icon_style_rotate,
			  	$nomal_text,
			  	$nomal_text_hover,
			  	$id_color 
			  	);
			break;
		case 'count':
			return sprintf( '
			<div class="counter style2 one-of-three %2$s ">
				<div class="background_img_count %11$s"></div>
		        <div class="icon">
		        	%8$s%1$s
                    </div>
                    <div class="content">
                        <p class="numb "  data-from="0" data-to="%14$s" data-speed="%13$s" data-inviewport="yes" style="color:%15$s">%14$s</p>
                        <h6 class="title" style="color:%15$s">%3$s</h6>
                    </div>
		    </div>', 
			$flat_box_icon,
		 	esc_attr( $atts['class'] ),
		  	esc_html( $atts['title'] ), 
		 	wp_kses_post ($content), 
		 	$flat_box_readmore,
		  	esc_attr( $atts['icon_position'] ), 
		 	esc_attr( $atts['icon_style'] ),
		  	$choice_icon,
		  	$start,
		  	$end,
		  	$check_icon_box,
		  	$icon_style_rotate,
		  	$speed,
		  	esc_attr( $atts['number'] ),
		  	$colorpicker_text
		  	);
			break;
		default:
			return sprintf( '<div class="category-sc" style="background-color:%5$s">
							    <div class="icon">
							        %3$s%1$s
							    </div>
							    <div class="content">
							        <h6 class="title"><a href="%4$s">%2$s</a></h6>
							    </div>
							</div>', 
				$flat_box_icon,
			  	esc_html( $atts['title'] ), 
			 	$choice_icon,
			 	esc_url($atts['link'] ),
			 	esc_attr( $atts['icon_color_bk'] )

			 );
			break;
	}
}


