<?php
/**
 * Register filter for append custom class name
 * that generated from visual-composer
 */

/**
 * Register shortcode into Visual Composer
 */
add_action( 'vc_before_init', 'themesflat_simple_button_shortcode_params' );

/**
 * Register parameters for iconbox shortcode
 * 
 * @return  void
 */
function themesflat_simple_button_shortcode_params() {
	$icons_params2 = themesflat_map_icons('icon','IconBox');
	$button  = array(
		array(
				'type'        => 'textfield',
				'heading'     => esc_html__( 'link', 'bookflare' ),
				'param_name'  => 'button_link',
				'value'	=> ''
			),

			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'Text', 'bookflare' ),
				'param_name' => 'button_text',
				'value'	=> ''
			),

			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Style', 'bookflare' ),
				'param_name' => 'button_style',
				'value'      => array(
					esc_html__('Have Background','bookflare') => 'have_background',
					esc_html__('No Background','bookflare') => 'no-background'
					)
				),

			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'Padding Top', 'bookflare' ),
				'description'    => esc_html__( '(Enter Padding Top Ex: 5px  )', 'bookflare' ),
				'param_name' => 'padding_top',
				'std' => '18px',
				'dependency' => array(
							'element' => 'button_style',
							'value' => 'have_background')
			),

			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'Padding Right', 'bookflare' ),
				'description'    => esc_html__( '(Enter Padding Right Ex: 20px  )', 'bookflare' ),
				'param_name' => 'padding_right',
				'std' => '32px'
			),

			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'Padding Bottom', 'bookflare' ),
				'description'    => esc_html__( '(Enter Padding Bottom Ex: 5px  )', 'bookflare' ),
				'param_name' => 'padding_bottom',
				'std' => '18px'
			),

			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'Padding Left', 'bookflare' ),
				'description'    => esc_html__( '(Enter Padding Left Ex: 20px  )', 'bookflare' ),
				'param_name' => 'padding_left',
				'std' => '20px'
			),

			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'Font Size', 'bookflare' ),
				'description'    => esc_html__( '(Enter Font Size Ex: 14px  )', 'bookflare' ),
				'param_name' => 'font_size',
				'std' => '16px'
			),

			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'Font Weight', 'bookflare' ),
				'description'    => esc_html__( '(Enter Font Weight Ex: 400  )', 'bookflare' ),
				'param_name' => 'font_weight',
				'std' => '600'
			),

			array(
				'type' => 'colorpicker',
				'heading'    => esc_html__( 'Text Color', 'bookflare' ),
				'param_name' => 'text_color',
				'std' => '#ffffff'
				),

			array(
				'type' => 'colorpicker',
				'heading'    => esc_html__( 'Text Color Hover', 'bookflare' ),
				'param_name' => 'text_color_hover',
				'std' => '#ffffff'
				),

			array(
				'type' => 'colorpicker',
				'heading'    => esc_html__( 'Background Color', 'bookflare' ),
				'param_name' => 'background_color',
				'std' => '#f3728b'
				),

			array(
				'type' => 'colorpicker',
				'heading'    => esc_html__( 'Hover Background Color', 'bookflare' ),
				'param_name' => 'hover_color',
				'std' => '#192836'
				)
		);	
		$_params = array(		

			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Button Align', 'bookflare' ),
				'param_name' => 'btn_align',
				'value' => array(
					esc_html__( 'Left', 'bookflare' ) => 'text-left',
					esc_html__( 'Center', 'bookflare' ) => 'text-center',
					esc_html__( 'Right', 'bookflare' ) => 'text-right'
					)
				),
		
			array(
				'type' => 'css_editor',
				'param_name' => 'css',
				'group' => esc_html__( 'Design Options', 'bookflare' )
			),

			array(
				'type'       => 'textfield',
				'heading'    => esc_html__( 'Extra Class', 'bookflare' ),
				'param_name' => 'class'
			));
	$params = array_merge($button,$icons_params2,$_params);
	vc_map( array(
		'base'        => 'themesflat_simple_button',
		'name'        => esc_html__( 'Themesflat: Simple Button', 'bookflare' ),
		'icon'        => THEMESFLAT_ICON,
		'category'    => esc_html__( 'Themesflat', 'bookflare' ),
		'params'      => $params
	) );
}

add_shortcode( 'themesflat_simple_button', 'themesflat_simple_button_shortcode_render' );

add_filter( 'themesflat/shortcode/simple_button_atts', 'themesflat_simple_button_shortcode_atts' );
add_filter( 'themesflat/shortcode/simple_button_style', 'themesflat_simple_button_shortcode_style' );

function themesflat_simple_button_shortcode_atts( $atts ) {
	$atts = array_merge($atts);
	return $atts;
}

function themesflat_simple_button_shortcode_style($atts) {
	$style[] = $atts['button_style'];
	if ($atts['button_style'] == 'have_background') {
		if (function_exists('vc_shortcode_custom_css_class')) {
			$vcclass = vc_shortcode_custom_css_class( $atts['css'], ' ' );
		}
		$style[] = $vcclass;
	}
	return $style;
}

// Title section render
function themesflat_simple_button_shortcode_render( $atts, $content = null ) {
	$atts = vc_map_get_attributes( 'themesflat_simple_button', $atts );
	extract (apply_filters( 'themesflat/shortcode/themesflat_simple_button_atts',$atts));
	$icon_name = themesflat_shortcode_icon_name('icon_',$atts['icon_type']);
	$icon_value = !empty($icon_name) ? $atts[$icon_name] : '';
	$flat_icon = !empty($icon_value) ? sprintf( '<i class="%s" style="margin-left:8px"></i>', $icon_value ) : ''; ;
	$class = apply_filters( 'themesflat/shortcode/simple_button_class', array( 'simple_button', $atts['class'],$atts['btn_align']  ), $atts );
	 $button_style = apply_filters('themesflat/shortcode/simple_button_style',$atts);

	return sprintf('<div class="wrap-btn %1$s">
		
		<a class="flat-button btn-all-sourses font-Poppins font-weight-700 border-ra4 %2$s" href="%3$s" style="padding-top:%6$spx;padding-right:%7$spx;padding-bottom:%8$spx;padding-left:%9$spx;background:%10$s;color:%12$s;font-size:%14$s;font-weight:%15$s;" data-text_color="%12$s" data-hover_text_color="%13$s" data-hover_bg_color="%11$s">%4$s %5$s</a>
	</div>', esc_attr( implode( ' ', $class ) ), esc_attr(implode(' ', $button_style)),esc_url($button_link),esc_html($button_text),$flat_icon, str_replace('px','',$padding_top), str_replace('px','',$padding_right), str_replace('px','',$padding_bottom), str_replace('px','',$padding_left), $background_color, $hover_color, $text_color, $text_color_hover, $font_size, $font_weight);
	
}