<?php
class Themesflat_Popular_Courses extends WP_Widget{
	/*Construct*/
	protected $defaults;
	function __construct(){
		$this -> defaults = array(
			'title' => 'Popular Courses',
			'count'    => 4,
			'show_title' => true,
			'show_rating' => false,
			'show_price' => false,
			'excerpt'       => 10,
			'order'		=> 'DESC',
			'courese_by_id'	=>''

		);
		parent::__construct(
			'widget_popular_courses',
            esc_html__( 'Themesflat - Popular Courses', 'bookflare' ),
            array(
                'classname'   => 'widget-popular-courses-news',
                'description' => esc_html__( 'Popular Courses.', 'bookflare' )
            )
		);
	}
	function widget( $args, $instance ){
		$instance = wp_parse_args( $instance, $this->defaults );
        extract( $instance );
        extract( $args );
        $style_lst = empty($instance['style_lst']) ? '' : $instance['style_lst'];
		$query_args = array(
            'post_type' => 'lp_course',
            'posts_per_page' => intval($count),
			'orderby' => 'id',
			'order' => $order,
        );

        $args_mer = array();
        if($courese_by_id !== ''){
			$args_mer = array('post__in' =>	explode(',', $courese_by_id),
						);
		}
		$args_s = array_merge($query_args,$args_mer);
		$themesflat_post = new WP_Query( $args_s );
		echo sprintf($before_widget);
		if ( !empty($title) ) { echo sprintf('%1$s%2$s%3$s',$before_title,$title,$after_title); }
		?>
		<?php if($style_lst =='Style 1'){
			if ( $themesflat_post->have_posts() ) : ?>
			<?php while ( $themesflat_post->have_posts() ) : $themesflat_post->the_post(); 
				$course_id = get_the_ID();
				$course_item = LP_Course::get_course( $course_id );
		    	$review_is_enable = themesflat_plugin_active( 'LP_Addon_Course_Review_Preload' );
		    	if($review_is_enable){
					$course_rate   = learn_press_get_course_rate( $course_id );
			    	$total         = learn_press_get_course_rate_total( $course_id );
				}
				?>
		        <div class="course-sidebar course style3 <?php themesflat_custom_course_price_color(); ?> ">
		            <div class="course-border border-f-e6f3ff transition-vline">   
		                <div class="course-img img-vline">
		                    <?php the_post_thumbnail('themesflat-courser-grid-simple2', array('class'=>'img-responsive border-ratop','alt' => esc_html ( get_the_title() )));?>
		                    <div class="overlay">
		                        <span class="vline"></span>
		                        <span class="vline vline-bottom"></span>
		                    </div>
		                </div>
		                <div class="course-content">
		                    <div class="text-wrap border-rabot">
		                        <p class="teacher"><?php $tflat_teacher = get_post_meta($course_id, '_custom_course_options', true);
		                        if(!empty($tflat_teacher)){
									themesflat_teacher_by_id_archive($tflat_teacher['teacher']);
								}?></p>
		                        <h6 class="title"><a href="<?php the_permalink($course_id); ?>"><?php echo esc_html(get_the_title($course_id)) ;?></a></h6>
		                        <?php if($review_is_enable): ?>
				                    <div class="wrap-rating">
				                        <?php themesflat_print_rating( $course_rate ); ?>
				                        <div class="number-rating"> <?php echo esc_attr(( $course_rate ) ? esc_html(round( $course_rate, 1 ) ) : 0); ?> <?php $total ? printf( _n( ' (%1$s)', ' (%1$s)', $total, 'bookflare' ), number_format_i18n( $total ) ) : esc_html_e( ' (0)', 'bookflare' ); ?> </div>
				                    </div>
				                <?php endif; ?>
		                        <span class="price v2"><?php  echo themesflat_custom_course_price_id($course_id);?></span>
		                    </div>
		                </div>
		            </div>
		        </div> <!-- /.course -->
		        <?php endwhile;
			wp_reset_postdata();
			endif; 
		}else{
			if ( $themesflat_post->have_posts() ) : ?>
			<div class="widget-related-sourses">
				 <div class="flat-courses">
			<?php while ( $themesflat_post->have_posts() ) : $themesflat_post->the_post();
				$course_id = get_the_ID();
				$course_item = LP_Course::get_course( $course_id );?>
				<div class="course transition-vline clear-fix">
                    <div class="course-img img-vline">
                        <a href="<?php the_permalink( ); ?>">
                        	 <?php the_post_thumbnail('themesflat-recent-news-thumb', array('class'=>'img-responsive border-ratop','alt' => esc_html ( get_the_title() )));?>
                        </a>
                        <div class="overlay">
                            <span class="vline"></span>
                            <span class="vline vline-bottom"></span>
                        </div>
                    </div>
                    <div class="course-content">
                        <h6 class="title"><a href="<?php the_permalink( ); ?>"><?php the_title(); ?></a></h6>
                        <p class="description"><?php echo themesflat_custom_excerpt(get_the_ID(),intval($excerpt),$excerpt);?></p>
                        <div class="list-meta">
                            <div class="list-meta">
                                <ul class="list">
                                    <li class="time"><?php echo get_the_date('d.m.Y');?></li>
                                    <li class="folder"><?php themesflat_category_slug_single(get_the_ID()); ?></li> 
                                </ul>
                            </div>
                        </div>  
                    </div>
                </div>
		        <?php endwhile;
			wp_reset_postdata();?>
				</div>
			</div>
			<?php
			endif; 
		} ?>
		
		<?php echo sprintf($after_widget);
	}
	function update($new_instance,$old_instance){
		$instance               = $old_instance;
        $instance['title']      = strip_tags( $new_instance['title'] );
        $instance['count']      =  intval($new_instance['count']);
        $instance['show_title']     = isset( $new_instance['show_title'] ) ? (bool) $new_instance['show_title'] : false;
		$instance['show_price']     = isset( $new_instance['show_price'] ) ? (bool) $new_instance['show_price'] : false;
		$instance['style_lst']      = $new_instance['style_lst'];
		$instance['order']      = $new_instance['order'];
		$instance['excerpt']          = intval( $new_instance['excerpt'] );
		$instance['courese_by_id']      = $new_instance['courese_by_id'];
        return $instance;
	}
	function form($instance){
		$instance = wp_parse_args( $instance, $this->defaults );
		$show_title = $instance['show_title'] ? "checked" : "";
		$show_title = isset($instance['show_title'])?(bool) $instance['show_title']:false;
		$show_rating = isset($instance['show_rating'])?(bool) $instance['show_rating']:false;
		$show_price = $instance['show_price'] ? "checked" : "";
		$show_price = isset($instance['show_price'])?(bool) $instance['show_price']:false;
		$style_lst = $instance['style_lst'];  
		$order = $instance['order'];  
		$courese_by_id = $instance['courese_by_id'];  
		?>
		<p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'bookflare' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $instance['title'] ); ?>">
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'courese_by_id' ) ); ?>"><?php esc_html_e( 'Show Courses by ID:', 'bookflare' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'courese_by_id' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'courese_by_id' ) ); ?>" type="text" value="<?php echo esc_attr( $instance['courese_by_id'] ); ?>">
        </p>
		<p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'count' ) ); ?>"><?php esc_html_e( 'Count:', 'bookflare' ); ?></label>
            <input class="widefat" type="number" id="<?php echo esc_attr( $this->get_field_id( 'count' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'count' ) ); ?>" value="<?php echo esc_attr( $instance['count'] ); ?>">
        </p>
		<p>
            <input class="checkbox" type="checkbox" <?php checked( $show_title); ?> id="<?php echo esc_attr( $this->get_field_id( 'show_title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'show_title')); ?>" />
            <label for="<?php echo esc_attr( $this->get_field_id( 'show_title')); ?>"><?php esc_html_e( 'Show Title ?', 'bookflare' ) ?></label>
        </p>
		<p>
            <input class="checkbox" type="checkbox" <?php checked( $show_price); ?> id="<?php echo esc_attr( $this->get_field_id( 'show_price' )); ?>" name="<?php echo esc_attr( $this->get_field_name( 'show_price')); ?>" />
            <label for="<?php echo esc_attr( $this->get_field_id( 'show_price')); ?>"><?php esc_html_e( 'Show Price ?', 'bookflare' ) ?></label>
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'excerpt' ) ); ?>"><?php esc_html_e( 'Excerpt Length:', 'bookflare' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'excerpt' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'excerpt' ) ); ?>" type="text" value="<?php echo intval( $instance['excerpt'] ); ?>">
        </p>
        <p>
	      <label for="<?php echo esc_attr($this->get_field_id('text')); ?>"><?php esc_html_e('Sort:','bookflare'); ?> 
	        <select class='widefat' id="<?php echo esc_attr($this->get_field_id('order')); ?>"
	                name="<?php echo esc_attr($this->get_field_name('order')); ?>" type="text">
	          <option value='DESC'<?php echo esc_attr(($order=='DESC')? 'selected': '') ; ?>>
	            <?php echo esc_html('DESC'); ?>
	          </option>
	          <option value='ASC'<?php echo esc_attr(($order=='ASC')? 'selected': ''); ?>>
	          	<?php echo esc_html('ASC'); ?>
	          </option>
	        </select>                
	      </label>
	    </p>
        <p>
	      <label for="<?php echo esc_attr($this->get_field_id('text')); ?>"><?php esc_html_e('Style list:','bookflare'); ?> 
	        <select class='widefat' id="<?php echo esc_attr($this->get_field_id('style_lst')); ?>"
	                name="<?php echo esc_attr($this->get_field_name('style_lst')); ?>" type="text">
	          <option value='Style 1'<?php echo esc_attr(($style_lst=='Style 1')?'selected':'') ; ?>>
	            <?php esc_html_e('Style 1','bookflare'); ?>
	          </option>
	          <option value='Style 2'<?php echo esc_attr(($style_lst=='Style 2')?'selected':''); ?>>
	          	<?php esc_html_e('Style 2','bookflare'); ?>
	          </option>
	        </select>                
	      </label>
	     </p>
		<?php
	}
}
add_action('widgets_init','themesflat_register_popular_courses');
function themesflat_register_popular_courses(){
	register_widget('Themesflat_Popular_Courses');
}