<?php
class Themesflat_Categories extends WP_Widget {
    /**
     * Holds widget settings defaults, populated in constructor.
     *
     * @var array
     */
    protected $defaults;
    /**
     * Constructor
     *
     * @return Themesflat_Categories
     */
    function __construct() {
        $this->defaults = array(
            'title'         => 'Categories',
            'count'         => 10,
            'child_of'      => 'false',
            'show_count'    => 0,
            'cate_ex'       =>''
        );
        parent::__construct(
            'widget_categories',
            esc_html__( 'Themesflat - Categories', 'bookflare' ),
            array(
                'classname'   => 'widget_categories',
                'description' => esc_html__( 'Categories.', 'bookflare' )
            )
        );
    }
    /**
     * Display widget
     */
    function widget( $args, $instance ) {
        $instance = wp_parse_args( $instance, $this->defaults );
        extract( $instance );
        extract( $args );
        echo sprintf($before_widget);?>
                <?php $terms = get_terms( array( 
                        'taxonomy' => 'category',
                        'hide_empty'=>false,
                        'parent' => 0,
                        'number'   => intval( $count ),
                        'child_of' =>intval( $child_of ),
                        'title_li'   =>'',
                        'exclude'=> explode(",", $cate_ex),
                    ) ); ?>
                    
        <div class="widget-categories v2 bg-fff border-f-e6f3ff">
        <?php if ( !empty($title) ) echo  '<h6 class="title-widget">'.$title.'</h6>';?>
        
            <ul class="custom-cat">
                <?php 
                    foreach ( $terms as $term ) { ?>
                       <li>
                        <i class="fa <?php echo esc_attr(get_term_meta($term->term_id,'code_icon', true)) ?>" aria-hidden="true"></i>
                        <a href="<?php echo get_term_link( $term ); ?>"><?php echo esc_html($term->name) ?></a>
                    </li>
                    <?php  }  ?>
            </ul>
        </div> <!-- /.widget-categories -->
        <?php  echo sprintf($after_widget);
    }
    /**
     * Update widget
     */
    function update( $new_instance, $old_instance ) {
        $instance                   = $old_instance;
        $instance['title']          = strip_tags( $new_instance['title'] );
        $instance['count']          = intval( $new_instance['count'] );
        $instance['child_of']       = intval( $new_instance['child_of'] );
        $instance['cate_ex'] = esc_attr( $new_instance['cate_ex'] );
        return $instance;
    }
    /**
     * Widget setting
     */
    function form( $instance ) {
        $instance = wp_parse_args( $instance, $this->defaults );
        $show_count = isset( $instance['show_count'] ) ? (bool) $instance['show_count'] : false;
        ?>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'bookflare' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $instance['title'] ); ?>">
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'count' ) ); ?>"><?php esc_html_e( 'Count:', 'bookflare' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'count' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'count' ) ); ?>" type="text" value="<?php echo intval( $instance['count'] ); ?>">
        </p>
        
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'cate_ex' ) ); ?>"><?php esc_html_e( 'Category exclude:(140,123,...)', 'bookflare' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'cate_ex' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'cate_ex' ) ); ?>" type="text" value="<?php echo esc_attr($instance['cate_ex']) ; ?>">
        </p>
    <?php
    }
}
add_action( 'widgets_init', 'themesflat_register_categories' );
/**
 * Register widget
 *
 * @return void
 * @since 1.0
 */
function themesflat_register_categories() {
    register_widget( 'Themesflat_Categories' );
}