<?php
class themesflat_related_post extends WP_Widget {
    /**
     * Holds widget settings defaults, populated in constructor.
     *
     * @var array
     */
    protected $defaults;
    /**
     * Constructor
     *
     * @return Themesflat_Categories
     */
    function __construct() {
        $this->defaults = array(
            'title'         => 'Latest Post',
            'count'         => 5,
            'excerpt'       => 10
        );
        parent::__construct(
            'widget_relatedC',
            esc_html__( 'Themesflat - Latest Post', 'bookflare' ),
            array(
                'classname'   => 'widget_relatedC',
                'description' => esc_html__( 'Latest Post.', 'bookflare' )
            )
        );
    }
    /**
     * Display widget
     */
    function widget( $args, $instance ) {
        $instance = wp_parse_args( $instance, $this->defaults );
        extract( $instance );
        extract( $args );
        echo sprintf('%1$s<div class="widget-related-sourses">',$before_widget) ;
        echo esc_attr($before_widget).'<div class="widget-related-sourses">';
        if ( !empty($title) ) echo  '<h6 class="title-widget">'.$title.'</h6>';?>
            <div class="flat-courses">
                <?php $query_args = array(
                        'post_type' => 'post',
                        'posts_per_page' => intval($count),
                        'orderby' => 'date',
                        'order' => 'DESC'
                    );
                    $themesflat_post = new WP_Query( $query_args ); ?>
                    <?php if ( $themesflat_post->have_posts() ) : ?>
                    <?php while ( $themesflat_post->have_posts() ) : $themesflat_post->the_post(); ?>

                <div class="course transition-vline clear-fix">
                    <div class="course-img img-vline">
                        <a href="<?php the_permalink( ); ?>"><img src="<?php the_post_thumbnail_url('themesflat-recent-news-thumb')?>" alt="bookflare"></a>
                        <div class="overlay">
                            <span class="vline"></span>
                            <span class="vline vline-bottom"></span>
                        </div>
                    </div>
                    <div class="course-content">
                        <h6 class="title"><a href="<?php the_permalink( ); ?>"><?php the_title(); ?></a></h6>
                        <p class="description"><?php echo themesflat_custom_excerpt(get_the_ID(),intval($excerpt),$courses_more);?></p>
                        <div class="list-meta">
                            <div class="list-meta">
                                <ul class="list">
                                    <li class="time"><?php echo get_the_date('d.m.Y');?></li>
                                    <li class="folder"><?php if (get_the_category('') != '') {the_category(', ');}?></li> 
                                </ul>
                            </div>
                        </div>  
                    </div>
                </div>  <!-- /.course -->
            <?php endwhile;
            wp_reset_postdata();
            endif;?>
            </div> 

        <?php echo sprintf('<div class="widget-related-sourses">%1$s',$after_widget) ;
    }
    /**
     * Update widget
     */
    function update( $new_instance, $old_instance ) {
        $instance                   = $old_instance;
        $instance['title']      = strip_tags( $new_instance['title'] );
        $instance['count']          = intval( $new_instance['count'] );
        $instance['excerpt']          = intval( $new_instance['excerpt'] );
        return $instance;
    }
    /**
     * Widget setting
     */
    function form( $instance ) {
        $instance = wp_parse_args( $instance, $this->defaults );

        ?>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'bookflare' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $instance['title'] ); ?>">
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'count' ) ); ?>"><?php esc_html_e( 'Count post:', 'bookflare' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'count' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'count' ) ); ?>" type="text" value="<?php echo intval( $instance['count'] ); ?>">
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'excerpt' ) ); ?>"><?php esc_html_e( 'Excerpt Length:', 'bookflare' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'excerpt' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'excerpt' ) ); ?>" type="text" value="<?php echo intval( $instance['excerpt'] ); ?>">
        </p>
        <?php
    }
}
add_action( 'widgets_init', 'themesflat_register_related_post' );
/**
 * Register widget
 *
 * @return void
 * @since 1.0
 */
function themesflat_register_related_post() {
    register_widget( 'themesflat_related_post' );
}