<?php
/**
 * Plugin Name: ThemesFlat By Themesflat.com
 * Plugin URI:  http://themesflat.com/
 * Description: The theme's components
 * Author:      ThemesFlat
 * Version:     1.0.1
 * Author URI: http://themesflat.com/
 */

define( 'THEMESFLAT_VERSION', '1.0.1' );
define( 'THEMESFLAT_PATH', plugin_dir_path( __FILE__ ) );
define( 'THEMESFLAT_URL', plugin_dir_url( __FILE__ ) );

// Event
require_once THEMESFLAT_PATH . '/includes/event/func-create.php';
// Teacher
require_once THEMESFLAT_PATH . '/includes/teacher/func-teacher.php';
// Shortcodes
$theme = wp_get_theme();
if ( 'Bookflare' == $theme->name || 'Bookflare' == $theme->parent_theme ){ 
	if ( function_exists( 'visual_composer' ) ) {		
		require_once THEMESFLAT_PATH . '/includes/shortcodes/iconbox.php';
		require_once THEMESFLAT_PATH . '/includes/shortcodes/testimonial.php';	
		require_once THEMESFLAT_PATH . '/includes/shortcodes/title-section.php';
		require_once THEMESFLAT_PATH . '/includes/shortcodes/maps.php';	
		require_once THEMESFLAT_PATH . '/includes/shortcodes/spacer.php';
		require_once THEMESFLAT_PATH . '/includes/shortcodes/login_form.php';
		require_once THEMESFLAT_PATH . '/includes/shortcodes/teacher-list.php';
		require_once THEMESFLAT_PATH . '/includes/shortcodes/event.php';
		require_once THEMESFLAT_PATH . '/includes/shortcodes/courses.php';
		require_once THEMESFLAT_PATH . '/includes/shortcodes/flat-feature.php';
		require_once THEMESFLAT_PATH . '/includes/shortcodes/simple-button.php';
		require_once THEMESFLAT_PATH . '/includes/shortcodes/feature-product.php';
		require_once THEMESFLAT_PATH . '/includes/shortcodes/iconbox-list.php';
		require_once THEMESFLAT_PATH . '/includes/shortcodes/tabs-flat.php';
		require_once THEMESFLAT_PATH . '/includes/shortcodes/accordion-flat.php';
		require_once THEMESFLAT_PATH . '/includes/teacher/select_teacher.php';
		require_once THEMESFLAT_PATH . '/includes/metabox-optionss.php';
		require_once THEMESFLAT_PATH . '/includes/metabox-options.php';
		require_once THEMESFLAT_PATH . '/includes/options.php';
		require_once THEMESFLAT_PATH . '/includes/widgets/themesflat_instagram.php';
		require_once THEMESFLAT_PATH . "/includes/widgets/themesflat_categories_courses.php";
		require_once THEMESFLAT_PATH . "/includes/widgets/themesflat_book_event.php";
		require_once THEMESFLAT_PATH . "/includes/widgets/themesflat_categories.php";
		require_once THEMESFLAT_PATH . "/includes/widgets/themesflat_related_post.php";
		require_once THEMESFLAT_PATH . "/includes/widgets/themesflat_social_icon.php";
		if (class_exists('Newsletter')) {
			require_once THEMESFLAT_PATH . "/includes/widgets/themesflat_newletter.php";
		}
		if (class_exists('Woocommerce')) {
			require_once THEMESFLAT_PATH . "/includes/widgets/themesflat_latest_wc.php";
		}
		if ( class_exists( 'LearnPress' )){
			require_once THEMESFLAT_PATH . "/includes/widgets/popular_courses.php";
		}
	}
}
if ( ! function_exists( 'themesflat_shortcode_register_assets' ) ) {
	add_action( 'init', 'themesflat_shortcode_register_assets' );

	/**
	 * Register all needed scripts & styles for the plugin
	 * 
	 * @return  void
	 */
	function themesflat_shortcode_register_assets() {		

		wp_enqueue_style( 'vc_extend_style', plugins_url('assets/css/shortcodes-3rd.css', __FILE__),array() );
		wp_enqueue_style( 'jquery-fancybox', plugins_url('assets/css/fancybox/jquery.fancybox.css', __FILE__),array() );
		wp_register_script( 'themesflat-manific-popup', plugins_url('assets/3rd/jquery.magnific-popup.min.js', __FILE__), array(), '1.0', true );		
		wp_enqueue_script( 'flat-fancybox', plugins_url('assets/3rd/jquery.fancybox.js', __FILE__), array(), '1.1', true );
		wp_enqueue_script( 'flat-countTo', plugins_url('assets/3rd/jquery-countTo.js', __FILE__), array(), '1.0', true );
		wp_enqueue_script( 'flat-way', plugins_url('assets/3rd/jquery-waypoints.js', __FILE__), array(), '1.0', true );
		wp_enqueue_script( 'flat-isotope', plugins_url('assets/3rd/jquery-isotope.js', __FILE__), array(), '1.0', true );
		wp_enqueue_script( 'flat-shortcode', plugins_url('assets/js/shortcodes.js', __FILE__), array(), '1.0', true );
		$key = '';
		if(get_theme_mod('key_google_map_api') != '' ){
			$key = get_theme_mod('key_google_map_api');
		}else{
			$key ='AIzaSyCPH8h1UpcK01BdcvoZeOzq-_wJqRxN1Pc';
		}
		wp_register_script( 'themesflat-google', 'https://maps.googleapis.com/maps/api/js?key='.$key.'', array(), '1.0', true );
		wp_enqueue_script('themesflat-google');
	}
}
// Show notice if your plugin is activated but Visual Composer is not
function showVcVersionNotice() {
    $plugin_data = get_plugin_data(__FILE__);
    echo '<div class="error">';
    echo '<p>' . wp_kses( __( $plugin_data['Name'] . ' - requires <a href="' . esc_url( admin_url( 'plugins.php') ) . '">Visual Composer</a>  plugin to be installed and activated on your site.', 'bookflare' ), array( 'a' => array( 'href' => array() ) ) ) . '</p>';
    echo '</div>';
}
if ( ! function_exists( 'themesflat_custom_shortcodes_class' ) ) {
	/**
	 * Helper function to append custom css class that
	 * generated from VisualComposer for shortcode
	 *
	 * @param   array  $classes  Shortcode classes
	 * @param   array  $atts     Shortcode attributes
	 * @param   string $tag      Shortcode tag name
	 *
	 * @return  array
	 */
	function themesflat_custom_shortcodes_class( $classes, $atts = array(), $tag = '' ) {
		if ( function_exists( 'vc_shortcode_custom_css_class' ) && ! empty( $atts['css'] ) ) {
			$classes[] = vc_shortcode_custom_css_class( $atts['css'], ' ' );
		}

		return $classes;
	}
}
if(function_exists( 'WPCF7' )){
	function custom_contact_form7() {
		global $post;
		ob_start(); 
		$post_ID = get_the_ID();
	   ?>
	   	<div class="event-content get-ticket">
		    <h6 class="title"><?php the_title(); ?></h6>
			    <div class="meta-list">
			        <ul class="list"><?php 
			        	$start_time = explode(' ',themesflat_meta('start_time'));
			        	$end_time = explode(' ',themesflat_meta('end_time'));
			         ?>
			            <li class="time">
			            	<?php echo esc_attr($start_time[0]).' - '.esc_attr($end_time[0]).' | '. themesflat_meta('time_event'); ?></li>
			            <?php if ( themesflat_meta('location_map',$post_ID) ) { ?>
			            	<li class="address"><?php echo esc_attr(themesflat_meta('location_map',$post_ID),'bookflare') ?></li>
			            <?php } ?>
			        </ul>
		    </div>
		</div>
	   <?php
	    return ob_get_clean(); 
	}
	add_shortcode('cs7', 'custom_contact_form7');
	add_filter( 'wpcf7_form_elements', 'wpcf7_form_elements_ticket' );
	function wpcf7_form_elements_ticket( $form ) {
	    $form = do_shortcode( $form );
	    return $form;
	}
}


// Get google font
function getFontsData( $fontsString ) {   
	$googleFontsParam = new Vc_Google_Fonts();      
	$fieldSettings = array();
	$fontsData = strlen( $fontsString ) > 0 ? $googleFontsParam->_vc_google_fonts_parse_attributes( $fieldSettings, $fontsString ) : '';
	return $fontsData;
	 
}
function googleFontsStyles( $fontsData ) {
	$fontFamily = explode( ':', $fontsData['values']['font_family'] );
	$styles[] = 'font-family:' . $fontFamily[0];
	$fontStyles = explode( ':', $fontsData['values']['font_style'] );
	$styles[] = 'font-weight:' . $fontStyles[1];
	$styles[] = 'font-style:' . $fontStyles[2];
	 
	$inline_style = '';     
	foreach( $styles as $attribute ){           
		$inline_style .= $attribute.'; ';       
	}   
	return $inline_style;
}


function enqueueGoogleFonts( $fontsData ) {
	$settings = get_option( 'wpb_js_google_fonts_subsets' );
	if ( is_array( $settings ) && ! empty( $settings ) ) {
		$subsets = '&subset=' . implode( ',', $settings );
	} else {
		$subsets = '';
	}
	if ( isset( $fontsData['values']['font_family'] ) ) {
		wp_enqueue_style( 
			'vc_google_fonts_' . vc_build_safe_css_class( $fontsData['values']['font_family'] ), 
			'//fonts.googleapis.com/css?family=' . $fontsData['values']['font_family'] . $subsets
		);
	}
}
//get view
function getPostViews($postID){
    $count_key = 'post_views_count';
    $count = get_post_meta($postID, $count_key, true);
    if($count==''){
        delete_post_meta($postID, $count_key);
        add_post_meta($postID, $count_key, '0');
        return '0';
    }
    return $count;
}
//set views
function setPostViews($postID) {
    $count_key = 'post_views_count';
    $count = get_post_meta($postID, $count_key, true);
    if($count==''){
        $count = 0;
        delete_post_meta($postID, $count_key);
        add_post_meta($postID, $count_key, '0');
    }else{
        $count++;
        update_post_meta($postID, $count_key, $count);
    }
}
/*Custom VC*/
if (class_exists('Vc_Manager')) {
    function vc_add_extra_field( $name, $form_field_callback, $script_url = null ) {
            return WpbakeryShortcodeParams::addField( $name, $form_field_callback, $script_url );
    }
	function themesflat_taxonomy_settings_field($settings, $value) {
		$terms_fields = array();
		$value_arr = $value;
		if (!is_array($value_arr)) {
			$value_arr = array_map('trim', explode(',', $value_arr));
		}
		if (!empty($settings['taxonomy'])) {
			$terms = get_terms($settings['taxonomy'], 'orderby=count&hide_empty=0');

			if ($terms && !is_wp_error($terms)) {
				foreach ($terms as $term) {
					$terms_fields[] = sprintf(
							'<label><input onclick="changeCategory(this);" id="%s" class="themesflat-check-taxonomy %s" type="checkbox" name="%s" value="%s" %s/>%s</label>', $settings['param_name'] . '-' . $term->slug, $settings['param_name'] . ' ' . $settings['type'], $settings['param_name'], $term->term_id, checked(in_array($term->term_id, $value_arr), true, false), $term->name
					);
				}
			}
		}
		return '<div class="themesflat-taxonomy-block">'
				. '<input type="hidden" name="' . $settings['param_name'] . '" class="wpb_vc_param_value wpb-checkboxes ' . $settings['param_name'] . ' ' . $settings['type'] . '_field" value="' . $value . '" />'
				. '<div class="themesflat-taxonomy-terms">'
				. implode($terms_fields)
				. '</div>'
				. '</div>';
		echo $value;
	}
	vc_add_extra_field('themesflat_taxonomy', 'themesflat_taxonomy_settings_field');
	function themesflat_hidden_settings_field($settings, $value){
	   return '<div class="themesflat_hidden_block">'
				 .'<input name="'.$settings['param_name']
				 .'" class="wpb_vc_param_value wpb-textinput '
				 .$settings['param_name'].' '.$settings['type'].'_field" type="hidden" value="'
				 .$value.'"/>'
			 .'</div>';
	}
	vc_add_extra_field('themesflat_hidden', 'themesflat_hidden_settings_field');
}

if ( function_exists('vc_disable_frontend') ) vc_disable_frontend();