<?php
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
	/**
	 * Extended class to integrate testimonial slider with
	 * visual composer
	 */
    class WPBakeryShortCode_accordions extends WPBakeryShortCodesContainer {
    }
    class WPBakeryShortCode_accordion extends WPBakeryShortCodesContainer {
    }
}

add_action( 'vc_before_init', 'themesflat_accordion_shortcode_params' );

function themesflat_accordion_shortcode_params() {
	/**
	 * Map the testimonial slider shortcode
	 */
	vc_map( array(
		'name'                    =>esc_html__( 'Themesflat: Accordions', 'bookflare' ),
		'base'                    => 'accordions',
		'as_parent'               => array( 'only' => 'accordion' ), 
		'content_element'         => true,
		'show_settings_on_create' => false,
		'category'                =>esc_html__( 'Themesflat', 'bookflare' ),
		'icon' 					  => THEMESFLAT_ICON,
		'params'                  => array(
			array(
				'type' => 'css_editor',
				'param_name' => 'css',
				'group' =>esc_html__( 'Design Options', 'bookflare' )
			),
		),
		'js_view' => 'VcColumnView'
	) );

	/**
	 * Map the single testimonial item
	 */
	vc_map( array(
		'base'        => 'accordion',
		'name'        =>esc_html__( 'Themesflat: Accordion', 'bookflare' ),
		'icon' 					  => THEMESFLAT_ICON,
		'category'    =>esc_html__( 'Themesflat', 'bookflare' ),
		'content_element'         => true,
		'show_settings_on_create' => true,
		"as_child" => array('only' => 'accordions'),
	    'as_parent'			=> array(''),
		'params'      => array(
			// Title
			array(
				'type'             => 'textfield',
				'heading'          =>esc_html__( 'Title iconbox accordion', 'bookflare' ),
				'param_name'       => 'title',
				'admin_label' => true,
			),
			array(
				'type'       => 'textfield',
				'heading'    =>esc_html__( 'Extra Class', 'bookflare' ),
				'param_name' => 'class'
			),

			array(
				'type' => 'css_editor',
				'param_name' => 'css',
				'group' =>esc_html__( 'Design Options', 'bookflare' )
			)
		),
		'js_view' => 'VcColumnView'
	) );
}

add_shortcode( 'accordion', 'themesflat_shortcode_accordion' );
add_shortcode( 'accordions', 'themesflat_shortcode_accordions' );

/**
 * tab shortcode handle
 * 
 * @param   string  $atts  Shortcode attributes
 * @return  void
 */
function themesflat_shortcode_accordion( $atts, $content = null ) {
	$atts = vc_map_get_attributes( 'accordion', $atts );
	extract( $atts);
    return sprintf( '<div class="accordion-toggle border-f-e6f3ff border-ra4">
                                        <div class="toggle-title %3$s">
                                           %2$s
                                        </div>
                                        <div class="toggle-content" >
                                            %1$s
                                            <div class="clearfix"></div>
                                        </div>
                                    </div><!-- /.accordion-toggle -->',do_shortcode( $content ),esc_attr($title),esc_attr($class));
}

/**
 * This function will be use to handle tabs slider
 * shortcode
 * 
 * @param   string  $atts     Shortcode attributes
 * @param   string  $content  Shortcode content
 * @return  string
 */
function themesflat_shortcode_accordions( $atts, $content = null ) {
	$atts = vc_map_get_attributes( 'accordions', $atts );
	extract($atts);
    ob_start();?>
    <div class="flat-faqs">
    	<div class="accordion">
	        <?php echo do_shortcode( $content ); ?>
	    </div>
    </div>
    <?php
    $output = ob_get_clean();
    return $output;
}
