<?php
if ( ! class_exists('Flat_VCExtend') ) {
	class Flat_VCExtend {
	    function __construct() {
			// We safely integrate with VC with this hook
			add_action( 'init', array( $this, 'integrateWithVC' ) );

			// Use this when creating a shortcode addon
			$shortcodes = 'portfolio,posts';
			$shortcodes = explode(",", $shortcodes);
			$shortcodes = array_map("trim", $shortcodes);
			foreach ( $shortcodes as $shortcode ) {
				add_shortcode($shortcode, array( $this, 'themesflat_'.$shortcode ) );
			}
	    }

	    public function integrateWithVC() {
	        // Check if Visual Composer is installed
	        if ( ! defined( 'WPB_VC_VERSION' ) ) {
	            // Display notice that Visual Compser is required
	            add_action('admin_notices', array( $this, 'showVcVersionNotice' ));
	            return;
	        }		
			
			//portfolio option
			$category_portfolio = get_terms( 'portfolios_category' );
			$category_portfolio_name[] = 'All';

			foreach ( $category_portfolio as $category ) {
				$category_portfolio_name[] = $category->name;		
			}

				vc_map( array(
				'base'        => 'portfolio',
				'icon'        => 'themesflat-shortcode',
				'name'        => esc_html__( 'Themesflat: Portfolio', 'bookflare' ),
				'category'    => esc_html__( 'Themesflat', 'bookflare' ),
				'params'      => array(
					array(
						"type"        => "dropdown",
						"heading" => esc_html__("Category", 'bookflare'),
						"param_name" => "category",
						"value"       => $category_portfolio_name,
						"description" => esc_html__("Display posts from some categories.", 'bookflare'),
		          	),	

					array(
						'type'       => 'dropdown',
						'heading'    => esc_html__( 'Style', 'bookflare' ),
						'param_name' => 'style',
						'value' => array(
							esc_html__( 'Grid Masonry', 'bookflare' )   => 'masonry'
						)
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Number Of Items', 'bookflare' ),
						'param_name' => 'limit',
						'value'      => 8
					),				

					array(
						'type' => 'dropdown',
						'heading' => esc_html__( 'Show Filter', 'bookflare' ),
						'param_name' => 'show_filter',
						'description' => esc_html__( 'If "YES" portfolio filter will be shown.', 'bookflare' ),
						'value' => array(
							esc_html__( 'No', 'bookflare' ) => 'no',
							esc_html__( 'Yes, please', 'bookflare' ) => 'yes'							
						)
					),
					array(
						'type' => 'dropdown',
						'heading' => __('Order by', 'bookflare'),
						'param_name' => 'orderby',
						'value' => array(
							'None' => 'none',
							'Title' => 'title',
							'Date' => 'date',
							'ID' => 'ID'
						),
						'description' => __('Order by ("none", "title", "date", "ID").', 'bookflare')
					),
					array(
						'type' => 'dropdown',
						'heading' => __('Order', 'bookflare'),
						'param_name' => 'order',
						'value' => Array(
							'None' => 'none',
							'ASC' => 'ASC',
							'DESC' => 'DESC'
						),
						'description' => __('Order ("None", "Asc", "Desc").', 'bookflare')
					),
					array(
						'type'       => 'textfield',
						'heading'    => esc_html__( 'Extra Class', 'bookflare' ),
						'param_name' => 'class'
					),

					array(
						'type' => 'css_editor',
						'param_name' => 'css',
						'group' => esc_html__( 'Design Options', 'bookflare' )
					)
				)
	        ));    
	    }    
		// Portfolio render
		public static function themesflat_portfolio( $atts, $content = null ) {
			extract( shortcode_atts( array(	
				'style'			  => 'masonry',
				'limit'		      => 8,	
				'show_filter'	  => '',
				'category'		  => 'All',
				'exclude'         => '',
				'orderby'         => 'none',
				'order'           => 'none',
				'css'             => '',
				'class'           => ''		
			), $atts ) );
			
			if ( empty( $atts['show_filter'] ) ) $atts['show_filter'] = 'no';
			ob_start();
			$content = wpb_js_remove_wpautop($content, true);

			$limit = intval( $limit );		
			$terms_slug = wp_list_pluck( get_terms( 'portfolios_category','orderby=name&hide_empty=0'), 'slug' );        
	        $tax =  $terms_slug;
	        
	        if ( $category != 'All' ) {            
	            $tax = $category;
	        }		

	        if ( get_query_var('paged') ) {
	           $paged = get_query_var('paged');
	        } elseif ( get_query_var('page') ) {
	           $paged = get_query_var('page');
	        } else {
	           $paged = 1;
	        }    

			$query_args = array(
	            'post_type' => 'portfolios',
	            'orderby'   => $orderby,
	            'order' => $order,
	            'posts_per_page' => $limit,
	            'paged' => $paged,          
	            'tax_query' => array(
	                array(
	                    'taxonomy' => 'portfolios_category',   
	                    'field'    => 'slug',                   
                    	'terms'    => $tax,
	                ),
	            ),
	        );
	        if ( ! empty( $atts['exclude'] ) ) {
				$exclude = $atts['exclude'];				
				if ( ! is_array( $exclude ) )
					$exclude = explode( ',', $exclude );

				$query_args['post__not_in'] = $exclude;
			}

			$query = new WP_Query( $query_args );
			$GLOBALS['wp_query']->max_num_pages = $query->max_num_pages; 
		
			if ( ! $query->have_posts())
				return;			

			echo '<div class="flat-portfolio">'; 
            $show_filter_portfolio = '';

			//Build the filter navigation
	        if ( $show_filter == "yes" ) {	   
	        	$show_filter_portfolio = 'show_filter_portfolio';     	
	            $terms = get_terms('portfolios_category','orderby=name&hide_empty=0');            
	            if ( count($terms) > 0 ) { 
	                echo '<ul class="portfolio-filter '.esc_attr( $class ).'"><li class="active"><a data-filter="*" href="#">' . esc_html__( 'All', 'bookflare' ) . '</a></li>';                
	                foreach ( $terms as $term ) {
	                    $termname = strtolower( $term->name );  
	                    $termname = str_replace(' ', '-', $termname);
	                    echo '<li><a data-filter=".' . esc_attr( $termname ) . '" href="#" title="' . esc_attr( $term->name ) . '">' . esc_html( $term->name ) . '</a></li>';                                  
	                }
	                echo '</ul>';
	            }
	        } 
	        echo '<div class="portfolio-container '.esc_attr( $class ).' '.esc_attr( $style ).' '.esc_attr( $show_filter_portfolio ).'">';        
			while ( $query->have_posts() ) : $query->the_post();
			global $post;
	        $id = $post->ID;
	        $termsArray = get_the_terms( $id, 'portfolios_category' );
	        $termsString = "";
	         
	        if ( $termsArray ) {
	            foreach ( $termsArray as $term ) {
	            	$itemname = strtolower( $term->name ); 
	                $itemname = str_replace( ' ', '-', $itemname );
	                $termsString .= $itemname.' ';
	            }
	        }

	        $img_portfolio = 'themesflat-portfolio-thumb';
	        
	        if ( $style == 'masonry' ) {
	        	$img_portfolio = 'post-thumbnails';
	        }
	        if ( has_post_thumbnail() ):	

	        	// Enqueue shortcode assets
				wp_enqueue_script( 'themesflat-manific-popup' );
				echo '<div class="item ' . $termsString . '">';
				echo '<div class="wrap-border">';
	            echo '<div class="featured-post">';	            
	            echo '<div class="link"><a class="popup-gallery" href="'.themesflat_thumbnail_url('').'"><i class="fa fa-search-plus"></i></a></div>';	            
	            echo '<img src="'.themesflat_thumbnail_url( $img_portfolio ).'" alt="'.get_the_title() .'">';	                                                                   
	            echo '</div>';	            
	            echo '</div>';
	            echo '</div>';
	            			
			endif;
			endwhile;	
			wp_reset_postdata();
			
			echo "</div>";
			echo "</div>";
			$out_put = ob_get_clean();
			return $out_put;
		}		
	}
}
// Finally initialize code
new Flat_VCExtend();



