<?php 

add_action( 'vc_before_init', 'themesflat_teacher_shortcode_params' );
// Element Class 
function themesflat_teacher_shortcode_params() {
    vc_map( 
  
        array(

            'name'                    =>esc_html__( 'Themesflat: Teacher List', 'bookflare' ),
			'base'                    => 'teacher',
			'category'                =>esc_html__( 'Themesflat', 'bookflare' ),
			'icon' 					  => THEMESFLAT_ICON,
			'params'                  => array(	
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Grid colums show teacher', 'bookflare' ),
					'param_name' => 'grid_columns',
					'value'       => array(		
						esc_html__( '2 Columns', 'bookflare' ) => 2,					
						esc_html__( '3 Columns', 'bookflare' ) => 3,	
						esc_html__( '4 Columns', 'bookflare' ) => 4
						),
					'std '		 => 3,
				),
				array(
				  'type' => 'textfield',
				  'heading' => __( 'Number post',  "bookflare" ),
				  'param_name' => 'number_post',
				  'value' => __( '12', 'bookflare' ),
				),
				array(
				  'type' => 'textfield',
				  'heading' => __( 'Show  Post by Post ID Number (Ex:150,213,...)',  'bookflare' ),
				  'param_name' => 'techer_number_post',
				  'value' => __( '', 'bookflare' ),
				),
				array(
				  'type' => 'textfield',
				  'heading' => __( 'Number text description except',  "bookflare" ),
				  'param_name' => 'number_post_except',
				  'value' => __( '10', 'bookflare' ),
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Order List post', 'bookflare' ),
					'param_name' => 'order_direction',
					'value' => array(
						esc_html__( 'ASC', 'bookflare' )   => 'asc',
						esc_html__( 'DESC', 'bookflare' )   => 'desc'
						),
					'std '		 => 'asc'
				),
				array(
					'type'       => 'dropdown',
					'heading'    => esc_html__( 'Order by', 'bookflare' ),
					'param_name' => 'order_by',
					'value' => array(
						esc_html__( 'ID', 'bookflare' )   => 'ID',
						esc_html__( 'author', 'bookflare' )   => 'author',
						esc_html__( 'title', 'bookflare' )   => 'title',
						esc_html__( 'name', 'bookflare' )   => 'name',
						esc_html__( 'date', 'bookflare' )   => 'date'
						),
					'std '		 => 'date'
				),
				array(
					'type' => 'colorpicker',
					'heading'    => esc_html__( ' Color Teacher Overlay', 'bookflare' ),
					'param_name' => 'color_ovl',
				
				),
				array(
					'type'       => 'checkbox',
					'heading'    => esc_html__( 'Enable Pagination', 'bookflare' ),
					'param_name' => 'blog_pagination',
					'value'      => array(
						esc_html__( 'Yes, please', 'bookflare' ) => 'yes'
						),
					'std '		 => 'no'
				),
           )
        )
    );                        
    
}    
 
add_shortcode( 'teacher', 'themesflat_shortcode_teacher' );
// Element HTML
 function themesflat_shortcode_teacher( $atts,$content = null ) {
    vc_map_get_attributes( 'teacher', $atts );
    extract(
        shortcode_atts(
            array(
            	'number_post'			=> '',
            	'order_direction'		=> 'asc',
            	'number_post_except' 	=>'10',
            	'blog_pagination'		=>'no',
            	'grid_columns' 			=>3,
            	'order_by'				=> 'date',
            	'techer_number_post'	=>'',
            	'color_ovl'				=>'#ffffff00'
            ), 
            $atts
        )
    );
    $teacher_columns = $grid_columns;
    switch ($teacher_columns) {
	case 2:
		$teacher_columns_class = 'col-lg-6 col-md-6';
		break;
	case 3:
		$teacher_columns_class = 'col-lg-4 col-md-4';
		break;
	default:
		$teacher_columns_class = 'col-lg-3 col-md-6';
		break;
	}
    if ( get_query_var('paged') ) {
			$paged = get_query_var('paged');
		} elseif ( get_query_var('page') ) {
			$paged = get_query_var('page');
		} else {
			$paged = 1;
		}
    // WP_Query arguments
		$args = array(
			'post_type'              => array( 'teacher' ),
			'post_status'            => array( 'publish' ),
			'nopaging'               => false,
			'posts_per_page'         => $number_post,
			'paged' 				 => $paged
		);
		$args_mer = array();
		if($techer_number_post !== ''){
			$args_mer = array('post__in' =>	explode(',', $techer_number_post),
								'orderby'                => 'none',
								'order'                  => '',
						);
		}else{
			$args_mer = array(
				'order'                  => $order_direction,
				'orderby'                => $order_by,
			);
		}
		$args_s = array_merge($args,$args_mer);
    ob_start();
    	?>
        <div class="content-page-wrap">
            <div class="flat-team row">
	    	<?php 
	    	$query = new WP_Query( $args_s );
	    	$GLOBALS['wp_query']->max_num_pages = $query->max_num_pages; 
			if ( $query->have_posts() ) {
				while ( $query->have_posts() ) {
					$query->the_post();
					$post_ID = get_the_ID();
					?>
					<div class="<?php themesflat_esc_attr($teacher_columns_class);?>">
                        <div class="team-member border-ra4">
                            <div class="avata-member">
                            	<div class="background-ovelay" style="background-color:<?php echo esc_attr($color_ovl); ?>"></div>
                                <?php the_post_thumbnail('themesflat-courser-shortcode', array('class'=>'responsive transition-img','alt' => esc_html ( get_the_title() )) ); ?>
                            </div>
                            <div class="info-member">
                                <h6 class="name"><?php the_title( ); ?></h6>
                                <p class="position"><?php themesflat_category_slug_teacher($post_ID); ?></p>
                                <p class="description"><?php echo themesflat_custom_excerpt($post_ID,intval($number_post_except));?></p>
                            </div>
                            <div class="socails flat-text-center no-bg ">
                                <ul class="list">
                                	<?php if(themesflat_meta('link_fb')):?>
                                		 <li class="facbook">
                                		 	<a href="<?php echo themesflat_meta('link_fb') ?>">
                                		 		<i class="fa fa-facebook"></i>
                                		 	</a>
                                		 </li>
                                	<?php endif; ?>
                                	<?php if(themesflat_meta('link_intagram')):?>
                                		 <li class="instagram">
                                		 	<a href="<?php echo themesflat_meta('link_intagram') ?>">
                                		 		<i class="fab fa-instagram"></i>
                                		 	</a>
                                		 </li>
                                	<?php endif; ?>
                                	<?php if(themesflat_meta('link_skyper')):?>
                                		 <li class="skype">
                                		 	<a href="skype:<?php  echo themesflat_meta('link_skyper') ?>?chat">
                                		 		<i class="fab fa-skype"></i>
                                		 	</a>
                                		 </li>
                                	<?php endif; ?>
                                	<?php if(themesflat_meta('link_github')):?>
                                		 <li class="github">
                                		 	<a href="<?php echo themesflat_meta('link_github') ?>">
                                		 		<i class="fab fa-github"></i>
                                		 	</a>
                                		 </li>
                                	<?php endif; ?>
                                </ul>
                            </div>
                        </div>
                    </div>
					<?php }
				} else {
					
				}
				wp_reset_postdata();
	    	 ?>
            </div>
            <?php if ( $blog_pagination == 'yes' ): ?>
                <div class="flat-paginations_courses">
					<?php
						get_template_part( 'tpl/pagination' );		
					?>
				</div>     
			<?php endif;?>              
        </div> <!-- /.content-page-wrap -->
		<?php
    return ob_get_clean(); 
} 