<?php
/**
 * The template for displaying 404 pages (not found).
 *
 * @package bookflare
 */
get_header(); ?>
<div class="col-md-12">
	<div id="primary" class="content-area fullwidth-404">
		<main id="main" class="site-main">
			<section class="error-404 not-found">
				<header class="page-header">
					<h1 class="title-404 nothing"><?php esc_html_e( '404', 'bookflare' ); ?></h1>
				</header><!-- .page-header -->
				<div class="sub-title-404">
					<?php esc_html_e( 'Looks Like Something Went Wrong!', 'bookflare' ); ?>
				</div><!-- .title-404 -->
				<div class="page-content">
					<p class="subtext-nothing">
					<?php 
					$allowed = array( 'br' => array() );
					echo wp_kses( esc_html__( 'It looks like nothing was found at this location.Click the link below to return home.', 'bookflare' ), 
						$allowed );
					?>
					</p>					
					<h4><a class="flat-button btn-read-more" href="<?php echo esc_url( home_url('/') ); ?>">
						<?php esc_html_e( 'Return home','bookflare' ) ?></a>
					</h4>
				</div><!-- .page-content -->
			</section><!-- .error-404 -->
		</main><!-- #main -->
	</div><!-- #primary -->
</div><!-- /.col-md-12 -->
<?php get_footer(); ?>