<?php
/**
 * @package bookflare
 */
global $themesflat_thumbnail;
$themesflat_thumbnail = 'themesflat-blog-single';
if (function_exists( 'themesflat_custom_shortcodes_class' )) {
    setPostViews(get_the_ID());
}
?>
<article id="post-<?php the_ID(); ?>" <?php post_class( 'blog-post blog-single post-single' ); ?>>
	<!-- begin feature-post single  -->
	<?php if(!is_singular( 'teacher' )){
		get_template_part( 'tpl/feature-post-single');
	} ?>
	<!-- end feature-post single-->
	<div class="entry-box-title clearfix">
		<div class="wrap-entry-title">
			<?php the_title( '<h3 class="title">', '</h3>' );	?>				
				<div class="entry-meta clearfix">
					<?php themesflat_posted_on(get_the_ID()); ?>		
				</div><!-- /.entry-meta -->				
		</div><!-- /.wrap-entry-title -->
	</div>		
	<div class="main-post">		
		<div class="entry-content clearfix">
			<?php the_content(); ?>
			<?php
			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'bookflare' ),
				'after'  => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>'
				) );
				?>
		</div><!-- .entry-content -->
	</div><!-- /.main-post -->
</article><!-- #post-## -->
<?php if (themesflat_choose_opt('show_author_post') == 0 && themesflat_choose_opt('show_share_link') == 0 && themesflat_choose_opt('show_post_navigator' ) == 0) {?>
	<div class="line-bottom-single-post border-top-f0f0f0"></div>
<?php } else {?>
	<footer class="infor infor-post clearfix">
		<div class="row">
            <div class="col-md-6 col-sm-6">
            	<?php if (themesflat_choose_opt('show_author_post')!=0) { ?>
            		<div class="admin-wrap">
                        <h6 class="admin"> <?php esc_html_e( 'POST FROM BY', 'bookflare' ); the_author_posts_link(); ?></h6>
                    </div>
            	<?php }  ?>
            </div>
            <div class="col-md-6 col-sm-6">
            	<?php if (themesflat_choose_opt('show_share_link') !=0) {?>
            		<div class="socails flat-text-right">
                        <ul class="list">
                            <li><?php esc_html_e( 'SHARE ', 'bookflare' );?></li>
                            <?php 
                            	$link = get_the_permalink( $post, false ); 
                             	themesflat_render_social_share($link); 
                             ?>
                        </ul>
                    </div>
            	<?php } ?>
            </div>
        </div>
	</footer><!-- .entry-footer -->
<?php } ?>

<?php if(!is_singular( 'teacher' )){?>
<div class="main-single">
	<?php 
	if ( 'post' == get_post_type() && themesflat_choose_opt('show_post_navigator' ) != 0 ): 
		themesflat_post_navigation(); 				
	endif;
	?>
	<?php get_template_part( 'tpl/related-post' ); ?>
		<div class="clearfix"></div>
	<?php }?>
	<?php
		// If comments are open or we have at least one comment, load up the comment template
		if ( comments_open() || get_comments_number() ) :
			comments_template();
		endif;
	?>
</div><!-- /.main-single -->