<?php
/**
 * The header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="content">
 *
 * @package bookflare
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?> xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<div class="themesflat-boxed">
	<?php if(themesflat_choose_opt('enable_preload')==1){
		?>
			<!-- Preloader -->
			<div class="preloader">
			  <div class="loader-pre"></div>
			</div>
            <!-- /.preloader -->
		<?php
	} ?>
	<!-- Hero Slider 1 -->	
	<?php themesflat_header(); ?>
	<!-- Page Title -->
	<?php 
		themesflat_custom_pagetitle();
	?>
	<div id="content" class="page-wrap <?php echo esc_attr( themesflat_blog_layout());?> <?php if(is_singular( 'post' )){echo esc_attr('cs-single-post');}else if(is_singular( 'product' )){echo esc_attr('cs-single-product'); }?>">
		<div class="<?php if(!is_singular( 'product' )){echo esc_attr('container'); } ?> content-wrapper ">
			<div class="<?php if(!is_singular( 'product' )){echo esc_attr('row'); } ?> flat_pro">
