<?php
/**
 * Bookflare Theme Customizer
 *
 * @package bookflare
 */
function themesflat_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
    $wp_customize->get_section( 'title_tagline' )->priority = '1';
    $wp_customize->get_section( 'title_tagline' )->title = esc_html__('General', 'bookflare');
	$wp_customize->remove_section( 'header_image' );
    $wp_customize->remove_section( 'colors' );
    $wp_customize->remove_section( 'background_image' );
    remove_theme_support( 'custom-header' );
    //Heading
    class themesflat_Info extends WP_Customize_Control {
        public $type = 'heading';
        public $label = '';
        public function render_content() {
        ?>
            <h3 class="themesflat-title-control"><?php echo esc_attr( $this->label); ?></h3>
        <?php
        }
    }    
    //Title
    class themesflat_Title_Info extends WP_Customize_Control {
        public $type = 'title';
        public $label = '';
        public function render_content() {
        ?>
            <h4><?php echo esc_attr( $this->label ); ?></h4>
        <?php
        }
    }    
    //Desc
    class themesflat_Theme_Info extends WP_Customize_Control {
        public $type = 'info';
        public $label = '';
        public function render_content() {
        ?>
            <h3><?php echo esc_attr( $this->label); ?></h3>
        <?php
        }
    }    
    //Desc
    class themesflat_Desc_Info extends WP_Customize_Control {
        public $type = 'desc';
        public $label = '';
        public function render_content() {
        ?>
            <p class="themesflat-desc-control"><?php echo esc_attr( $this->label); ?></p>
        <?php
        }
    }

    //___General___//
    $wp_customize->add_setting('themesflat_options[info]', array(
            'type'              => 'info_control',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'esc_attr',            
        )
    );

    // Heading site infomation
    $wp_customize->add_control( new themesflat_Info(
        $wp_customize, 
        'custom-stie-infomation', 
        array(
        'label' => esc_html__('SITE INFORMATION', 'bookflare'),
        'section' => 'title_tagline',
        'settings' => 'themesflat_options[info]',
        'priority' =>1
        ) )
    );    

    // Desc site infomaton
    $wp_customize->add_control( new themesflat_Desc_Info( $wp_customize, 'desc_customizer_siteinfomation', array(
        'label' => esc_html__('This section have basic information of your site, just change it to match with you need.', 'bookflare'),
        'section' => 'title_tagline',
        'settings' => 'themesflat_options[info]',
        'priority' => 2
        ) )
    );
     // Enable Preload
    $wp_customize->add_setting(
      'enable_preload',
        array(
            'sanitize_callback' => 'themesflat_sanitize_checkbox',
            'default' => themesflat_customize_default_opt('enable_preload'),     
        )   
    );

    $wp_customize->add_control( new themesflat_Checkbox( $wp_customize,'enable_preload',array(
            'type' => 'checkbox',
            'label' => esc_html__('Enable Preload', 'bookflare'),
            'section' => 'title_tagline',
            'priority' => 10,
        ))
    );
    // Enable Smooth Scroll
    $wp_customize->add_setting(
      'enable_smooth_scroll',
        array(
            'sanitize_callback' => 'themesflat_sanitize_checkbox',
            'default' => themesflat_customize_default_opt('enable_smooth_scroll'),     
        )   
    );
    $wp_customize->add_control( new themesflat_Checkbox( $wp_customize,
        'enable_smooth_scroll',
        array(
            'type' => 'checkbox',
            'label' => esc_html__('Enable Smooth Scroll', 'bookflare'),
            'section' => 'title_tagline',
            'priority' => 10,
        ))
    );

    // Google Font Api Key 
    $wp_customize->add_setting(
        'key_google_api',
        array(
            'default' => themesflat_customize_default_opt('key_google_api'),
            'sanitize_callback' => 'themesflat_sanitize_text',
        )
    );
    $wp_customize->add_control(
        'key_google_api',
        array(
            'label' => esc_html__( 'Google Font Api Key', 'bookflare' ),
            'section' => 'title_tagline',
            'type' => 'text',
            'priority' => 12
        )
    );

    // Google Map Api Key 
    $wp_customize->add_setting(
        'key_google_map_api',
        array(
            'default' => themesflat_customize_default_opt('key_google_map_api'),
            'sanitize_callback' => 'themesflat_sanitize_text',
        )
    );
    $wp_customize->add_control(
        'key_google_map_api',
        array(
            'label' => esc_html__( 'Google Map Api Key', 'bookflare' ),
            'section' => 'title_tagline',
            'type' => 'text',
            'priority' => 13
        )
    );
        // Heading custom logo
    $wp_customize->add_control( new themesflat_Info( $wp_customize, 'custom-page-template-default', array(
        'label' => esc_html__('CUSTOM PAGE TEMPLATE DEFAULT', 'bookflare'),
        'section' => 'title_tagline',
        'settings' => 'themesflat_options[info]',
        'priority' => 14
        ) )
    ); 

     // Show Header Content
    $wp_customize->add_setting ( 
        'show_header_title_content',
        array (
            'sanitize_callback' => 'themesflat_sanitize_checkbox' ,
            'default' => themesflat_customize_default_opt('show_header_title_content'),     
        )
    );
    $wp_customize->add_control( new themesflat_Checkbox( $wp_customize,
        'show_header_title_content',
        array(
            'type'      => 'checkbox',
            'label'     => esc_html__('Show Heading Content Page Default', 'bookflare'),
            'section'   => 'title_tagline',
            'priority'  => 15
        ))
    );
    //Socials
    $wp_customize->add_section(
        'themesflat_socials',
        array(
            'title'         => esc_html__('Socials', 'bookflare'),
            'priority'      => 2,
            'sanitize_callback' => 'themesflat_sanitize_text',
        )
    ); 

    //__social links__//
    $wp_customize->add_setting(
      'social_links',
      array(
        'sanitize_callback' => 'esc_attr',
        'default' => themesflat_customize_default_opt('social_links'),     
      )   
    );

    $wp_customize->add_control( new themesflat_SocialIcons($wp_customize,
        'social_links',
        array(
            'type' => 'social-icons',
            'label' => esc_html__('Social', 'bookflare'),
            'section' => 'themesflat_socials',
            'priority' => 1,
        ))
    );
    
	//___Header___//
    $wp_customize->add_section(
        'themesflat_header',
        array(
            'title'         => esc_html__('Header', 'bookflare'),
            'priority'      => 3,
        )
    );
    // Heading custom logo
    $wp_customize->add_control( new themesflat_Info( $wp_customize, 'custom-logo', array(
        'label' => esc_html__('Custom Logo', 'bookflare'),
        'section' => 'themesflat_header',
        'settings' => 'themesflat_options[info]',
        'priority' => 2
        ) )
    );    
    // Desc custon logo
    $wp_customize->add_control( new themesflat_Desc_Info( $wp_customize, 'desc_customizer_logo', array(
        'label' => esc_html__('In this section You can upload your own custom logo, change the way your logo can be displayed', 'bookflare'),
        'section' => 'themesflat_header',
        'settings' => 'themesflat_options[info]',
        'priority' => 3
        ) )
    );    
    //Logo
    $wp_customize->add_setting(
        'site_logo',
        array(
            'default' => themesflat_customize_default_opt('site_logo'),
            'sanitize_callback' => 'esc_url_raw',
        )
    );    
    $wp_customize->add_control(
        new WP_Customize_Image_Control(
            $wp_customize,
            'site_logo',
            array(
               'label'          => esc_html__( 'Upload your logo ', 'bookflare' ),
               'description'    => esc_html__( 'The best size is 157x30px ( If you don\'t display logo please remove it your website display 
                Site Title default in General )', 'bookflare' ),
               'type'           => 'image',
               'section'        => 'themesflat_header',
               'priority'       => 5,
            )
        )
    );
    // Logo Retina
    $wp_customize->add_setting(
        'site_retina_logo',
        array(
            'default'           => themesflat_customize_default_opt('site_retina_logo'),
            'sanitize_callback' => 'esc_url_raw',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Image_Control(
            $wp_customize,
            'site_retina_logo',
            array(
               'label'          => esc_html__( 'Upload your logo retina', 'bookflare' ),
               'description'    => esc_html__( 'The best size is 315x60px', 'bookflare' ),
               'type'           => 'image',
               'section'        => 'themesflat_header',
               'priority'       => 6,
            )
        )
    );

    // Logo Size
    $wp_customize->add_control( new themesflat_Title_Info( $wp_customize, 'logo-size', array(
        'label' => esc_html__('Logo Size', 'bookflare'),
        'section' => 'themesflat_header',
        'settings' => 'themesflat_options[info]',
        'priority' => 7
        ) )
    );  
    // width
    $wp_customize->add_setting(
        'logo_width',
        array(
            'default' => '157',
            'sanitize_callback' => 'themesflat_sanitize_text',
        )
    );
    $wp_customize->add_control(
        'logo_width',
        array(
            'label' => esc_html__( 'Width (px)', 'bookflare' ),
            'section' => 'themesflat_header',
            'type' => 'text',
            'priority' => 8
        )
    );  
    // Height
    $wp_customize->add_setting(
        'logo_height',
        array(
            'default' => '29',
            'sanitize_callback' => 'themesflat_sanitize_text',
        )
    );
    $wp_customize->add_control(
        'logo_height',
        array(
            'label' => esc_html__( 'Height (px)', 'bookflare' ),
            'section' => 'themesflat_header',
            'type' => 'text',
            'priority' => 9
        )
    );  
     // Box control
        $wp_customize->add_setting(
            'logo_controls',
            array(
                'default' => themesflat_customize_default_opt('logo_controls'),
                'sanitize_callback' => 'themesflat_sanitize_text',
            )
        );
        $wp_customize->add_control( new themesflat_BoxControls($wp_customize,
            'logo_controls',
            array(
                'label' => esc_html__( 'Logo Controls (px)', 'bookflare' ),
                'section' => 'themesflat_header',
                'type' => 'box-controls',
                'priority' => 10
            ))
        );


    // Title Heading Style
    $wp_customize->add_setting('themesflat_options[info]', array(
        'type'              => 'info_control',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'esc_attr',            
        )
    );
    $wp_customize->add_control( new themesflat_Info( $wp_customize, 'header_type', array(
        'label' => esc_html__('Header Type', 'bookflare'),
        'section' => 'themesflat_header',
        'settings' => 'themesflat_options[info]',
        'priority' => 12
        ) )
    );  
    $wp_customize->add_setting(
        'header_style',
        array(
            'default'           => themesflat_get_opt('header_style'),
            'sanitize_callback' => 'esc_attr',
        )
    );
    $wp_customize->add_control( new Themesflat_RadioImages($wp_customize,
        'header_style',
        array(
            'type'      => 'radio-images',           
            'section'   => 'themesflat_header',
            'priority'  => 14,
            'label'         => esc_html__('Click the header style for your website', 'bookflare'),
            'choices'   => array (
                'v1'=> array (
                   'tooltip'   => esc_html__('Header Type1','bookflare'),
                   'src'       => THEMESFLAT_LINK . 'images/header/header.png'
                ) ,
                'v2'=>  array (
                   'tooltip'   => esc_html__('Header Type2','bookflare'),
                   'src'       => THEMESFLAT_LINK . 'images/header/header-2.png'
                ) ,
            ),
        ))
    );      
    // Header Sticky
    $wp_customize->add_setting(
      'header_sticky',
        array(
            'sanitize_callback' => 'themesflat_sanitize_checkbox',
            'default' => themesflat_customize_default_opt('header_sticky'),     
        )   
    );
    $wp_customize->add_control(new themesflat_Checkbox( $wp_customize,
        'header_sticky',
        array(
            'type' => 'checkbox',
            'label' => esc_html__('Enable sticky header', 'bookflare'),
            'section' => 'themesflat_header',
            'priority' => 15,
        ))
    );    
    
    // Show search
    $wp_customize->add_setting(
      'header_searchbox',
        array(
            'sanitize_callback' => 'themesflat_sanitize_checkbox',
            'default' => themesflat_customize_default_opt('header_searchbox'),     
        )   
    );
    $wp_customize->add_control(new themesflat_Checkbox( $wp_customize,
        'header_searchbox',
        array(
            'type' => 'checkbox',
            'label' => esc_html__('Show Search', 'bookflare'),
            'section' => 'themesflat_header',
            'priority' => 16,
        ))
    ); 

     // Show Cart
    $wp_customize->add_setting(
      'header_cartbox',
        array(
            'sanitize_callback' => 'themesflat_sanitize_checkbox',
            'default' => themesflat_customize_default_opt('header_cartbox'),     
        )   
    );
    $wp_customize->add_control(new themesflat_Checkbox( $wp_customize,
        'header_cartbox',
        array(
            'type' => 'checkbox',
            'label' => esc_html__('Show Cart', 'bookflare'),
            'section' => 'themesflat_header',
            'priority' => 17,
        ))
    );  


    // Heading Top Bar 
    $wp_customize->add_control( new themesflat_Info( $wp_customize, 'top-bar', array(
        'label' => esc_html__('Top Bar', 'bookflare'),
        'section' => 'themesflat_header',
        'settings' => 'themesflat_options[info]',
        'priority' => 17
        ) )
    );    
    // Desc Top Bar 
    $wp_customize->add_control( new themesflat_Desc_Info( $wp_customize, 'desc', array(
        'label' => esc_html__('Turn on/off the top bar', 'bookflare'),
        'section' => 'themesflat_header',
        'settings' => 'themesflat_options[info]',
        'priority' => 18
        ) )
    );  
    // Top bar
    $wp_customize->add_setting(
      'topbar_enabled',
        array(
            'sanitize_callback' => 'themesflat_sanitize_checkbox',
            'default' => themesflat_customize_default_opt('topbar_enabled'),     
        )   
    );
    $wp_customize->add_control(new themesflat_Checkbox( $wp_customize,
        'topbar_enabled',
        array(
            'type' => 'checkbox',
            'label' => esc_html__('Show Topbar', 'bookflare'),
            'section' => 'themesflat_header',
            'priority' => 19,
        ))
    ); 
	
    // Enable Socials Top
    $wp_customize->add_setting(
      'enable_social_link',
        array(
            'sanitize_callback' => 'themesflat_sanitize_checkbox',
            'default' => themesflat_customize_default_opt('enable_social_link'),     
        )   
    );
    $wp_customize->add_control(new themesflat_Checkbox( $wp_customize,
        'enable_social_link',
        array(
            'type' => 'checkbox',
            'label' => esc_html__('Show Socials On Top', 'bookflare'),
            'section' => 'themesflat_header',
            'priority' => 20,
        ))
    );    
    // Top Content
    $wp_customize->add_setting(
        'top_content',
        array(
            'default' => themesflat_customize_default_opt('top_content'),
            'sanitize_callback' => 'themesflat_sanitize_text'
        )
    );
    $wp_customize->add_control(
        'top_content',
        array(
            'label' => esc_html__( 'Content Left', 'bookflare' ),
            'section' => 'themesflat_header',
            'type' => 'textarea',
            'priority' => 21
        )
    );   
    $wp_customize->add_setting(
        'top_content_right',
        array(
            'default' => themesflat_customize_default_opt('top_content_right'),
            'sanitize_callback' => 'themesflat_sanitize_text'
        )
    );
    $wp_customize->add_control(
        'top_content_right',
        array(
            'label' => esc_html__( 'Content right', 'bookflare' ),
            'section' => 'themesflat_header',
            'type' => 'textarea',
            'priority' => 22
        )
    );

// Desc Top Bar 
    $wp_customize->add_control( new themesflat_Desc_Info( $wp_customize, 'desc', array(
        'label' => esc_html__('Show/Hide count down the top bar of header 1', 'bookflare'),
        'section' => 'themesflat_header',
        'settings' => 'themesflat_options[info]',
        'priority' => 23
        ) )
    ); 
    // Enable count down Top
    $wp_customize->add_setting(
      'enable_connt_down',
        array(
            'sanitize_callback' => 'themesflat_sanitize_checkbox',
            'default' => themesflat_customize_default_opt('enable_connt_down'),     
        )   
    );
    $wp_customize->add_control(new themesflat_Checkbox( $wp_customize,
        'enable_connt_down',
        array(
            'type' => 'checkbox',
            'label' => esc_html__('Show/Hide count down', 'bookflare'),
            'section' => 'themesflat_header',
            'priority' => 24,
        ))
    );
    $wp_customize->add_setting(
        'cd_hour',
        array(
            'default' => themesflat_customize_default_opt('cd_hour'),
            'sanitize_callback' => 'themesflat_sanitize_text'
        )
    );
    $wp_customize->add_control(
        'cd_hour',
        array(
            'label' => esc_html__( 'count down time', 'bookflare' ),
            'section' => 'themesflat_header',
            'type' => 'text',
            'priority' => 25
        )
    );
    // Enable login/rigester Top
    $wp_customize->add_setting(
      'enable_lg_rg',
        array(
            'sanitize_callback' => 'themesflat_sanitize_checkbox',
            'default' => themesflat_customize_default_opt('enable_lg_rg'),     
        )   
    );
    $wp_customize->add_control(new themesflat_Checkbox( $wp_customize,
        'enable_lg_rg',
        array(
            'type' => 'checkbox',
            'label' => esc_html__('Show/Hide login/rigester', 'bookflare'),
            'section' => 'themesflat_header',
            'priority' => 26,
        ))
    );
    /*Header Full Width*/
    $wp_customize->add_setting(
      'enable_header_fullwidth',
        array(
            'sanitize_callback' => 'themesflat_sanitize_checkbox',
            'default' => themesflat_customize_default_opt('enable_header_fullwidth'),     
        )   
    );
    $wp_customize->add_control(new themesflat_Checkbox( $wp_customize,
        'enable_header_fullwidth',
        array(
            'type' => 'checkbox',
            'label' => esc_html__('Turn On header full width', 'bookflare'),
            'section' => 'themesflat_header',
            'priority' => 27,
        ))
    );

        // ADD SECTION  FOOTER
    $wp_customize->add_section(
        'themesflat_footer',
        array(
        'title'=>esc_html__('Footer', 'bookflare'),
        'priority'=>4
    ));

    // Footer page callback
    $wp_customize->add_control( new themesflat_Info( $wp_customize, 'custom_cb_footer', array(
        'label' => esc_html__('Footer Expert Instruction', 'bookflare'),
        'section' => 'themesflat_footer',
        'settings' => 'themesflat_options[info]',
        'priority' => 1
        ) )
    );

    $wp_customize->add_setting (
        'custom_cb',
        array (
            'sanitize_callback' => 'themesflat_sanitize_checkbox',
            'default' => themesflat_customize_default_opt('custom_cb'),     
        )
    );

    $wp_customize->add_control( new themesflat_Checkbox( $wp_customize,
        'custom_cb',
        array(
            'type'      => 'checkbox',
            'label'     => esc_html__('Show Footer Expert Instruction', 'bookflare'),
            'section'   => 'themesflat_footer',
            'priority'  => 1,
        ))
    );

    $wp_customize->add_setting (
        'custom_cb_icon1',
        array (
            'sanitize_callback' => 'themesflat_sanitize_text',
            'default' => themesflat_customize_default_opt('custom_cb_icon1'),     
        )
    );

    $wp_customize->add_control(
        'custom_cb_icon1',
        array(
            'type'      => 'text',
            'label'     => esc_html__('Icon First', 'bookflare'),
            'section'   => 'themesflat_footer',
            'priority'  => 1,
        )
    );
    $wp_customize->add_setting (
        'custom_cb_text1',
        array (
            'sanitize_callback' => 'themesflat_sanitize_text',
            'default' => themesflat_customize_default_opt('custom_cb_text1'),     
        )
    );

    $wp_customize->add_control(
        'custom_cb_text1',
        array(
            'type'      => 'text',
            'label'     => esc_html__('Text First', 'bookflare'),
            'section'   => 'themesflat_footer',
            'priority'  => 1,
        )
    );

    $wp_customize->add_setting (
        'custom_cb_icon2',
        array (
            'sanitize_callback' => 'themesflat_sanitize_text',
            'default' => themesflat_customize_default_opt('custom_cb_icon2'),     
        )
    );

    $wp_customize->add_control(
        'custom_cb_icon2',
        array(
            'type'      => 'text',
            'label'     => esc_html__('Icon Second', 'bookflare'),
            'section'   => 'themesflat_footer',
            'priority'  => 1,
        )
    );
    $wp_customize->add_setting (
        'custom_cb_text2',
        array (
            'sanitize_callback' => 'themesflat_sanitize_text',
            'default' => themesflat_customize_default_opt('custom_cb_text2'),     
        )
    );

    $wp_customize->add_control(
        'custom_cb_text2',
        array(
            'type'      => 'text',
            'label'     => esc_html__('Text Second', 'bookflare'),
            'section'   => 'themesflat_footer',
            'priority'  => 1,
        )
    );
    $wp_customize->add_setting (
        'custom_cb_icon3',
        array (
            'sanitize_callback' => 'themesflat_sanitize_text',
            'default' => themesflat_customize_default_opt('custom_cb_icon3'),     
        )
    );

    $wp_customize->add_control(
        'custom_cb_icon3',
        array(
            'type'      => 'text',
            'label'     => esc_html__('Icon Third', 'bookflare'),
            'section'   => 'themesflat_footer',
            'priority'  => 1,
        )
    );
    $wp_customize->add_setting (
        'custom_cb_text3',
        array (
            'sanitize_callback' => 'themesflat_sanitize_text',
            'default' => themesflat_customize_default_opt('custom_cb_text3'),     
        )
    );

    $wp_customize->add_control(
        'custom_cb_text3',
        array(
            'type'      => 'text',
            'label'     => esc_html__('Text Third', 'bookflare'),
            'section'   => 'themesflat_footer',
            'priority'  => 1,
        )
    );

    



    // Footer widget
    $wp_customize->add_control( new themesflat_Info( $wp_customize, 'custom-widget-footer', array(
        'label' => esc_html__('footer widgets', 'bookflare'),
        'section' => 'themesflat_footer',
        'settings' => 'themesflat_options[info]',
        'priority' => 1
        ) )
    );    

    // Desc
    $wp_customize->add_control( new themesflat_Desc_Info( $wp_customize, 'desc_customizer_widget_footer', array(
        'label' => esc_html__('This section allow to change the layout and styles of footer widgets to match as you need', 'bookflare'),
        'section' => 'themesflat_footer',
        'settings' => 'themesflat_options[info]',
        'priority' => 2
        ) )
    ); 
    
    // Gird columns footer
    $wp_customize->add_setting(
        'footer_widget_areas',
        array(
            'default'           => themesflat_customize_default_opt('footer_widget_areas'),
            'sanitize_callback' => 'themesflat_sanitize_grid_post_related',
        )
    );

    $wp_customize->add_control(
        'footer_widget_areas',
        array(
            'type'      => 'select',           
            'section'   => 'themesflat_footer',
            'priority'  => 3,
            'label'     => esc_html__('Columns  Footer', 'bookflare'),
            'choices'   => array(                
                1     => esc_html__( '1 Columns', 'bookflare' ),
                2     => esc_html__( '2 Columns', 'bookflare' ),
                3     => esc_html__( '3 Columns', 'bookflare' ),
                4     => esc_html__( '4 Columns', 'bookflare' ),                
            )
        )
    );

        // Footer title
    $wp_customize->add_control( new themesflat_Info( $wp_customize, 'custom-footer-content', array(
        'label' => esc_html__('CUSTOM FOOTER', 'bookflare'),
        'section' => 'themesflat_footer',
        'settings' => 'themesflat_options[info]',
        'priority' => 4
        ) )
    );    
    // Desc
    $wp_customize->add_control( new themesflat_Desc_Info( $wp_customize, 'desc_customizer_footer', array(
        'label' => esc_html__('You can change the copyright text, show/hide the social icons on the footer.', 'bookflare'),
        'section' => 'themesflat_footer',
        'settings' => 'themesflat_options[info]',
        'priority' => 5
        ) )
    );  
    // Enable footer
    $wp_customize->add_setting(
      'footer_enable',
        array(
            'sanitize_callback' => 'themesflat_sanitize_checkbox',
            'default' => themesflat_customize_default_opt('footer_enable'),     
        )   
    );
    $wp_customize->add_control(new themesflat_Checkbox( $wp_customize,
        'footer_enable',
        array(
            'type' => 'checkbox',
            'label' => esc_html__('Show/Hide Footer Widgets', 'bookflare'),
            'section' => 'themesflat_footer',
            'priority' => 6,
        ))
    ); 
    // Enable footer Footer Menu
    $wp_customize->add_setting(
      'footer_enable_botom_menu',
        array(
            'sanitize_callback' => 'themesflat_sanitize_checkbox',
            'default' => themesflat_customize_default_opt('footer_enable_botom_menu'),     
        )   
    );
    $wp_customize->add_control(new themesflat_Checkbox( $wp_customize,
        'footer_enable_botom_menu',
        array(
            'type' => 'checkbox',
            'label' => esc_html__('Show/Hide Footer Menu', 'bookflare'),
            'section' => 'themesflat_footer',
            'priority' => 6,
        ))
    ); 
    // Box control
    $wp_customize->add_setting(
        'footer_controls',
        array(
            'default' => themesflat_customize_default_opt('footer_controls'),
            'sanitize_callback' => 'themesflat_sanitize_text',
        )
    );
    $wp_customize->add_control( new themesflat_BoxControls($wp_customize,
        'footer_controls',
        array(
            'label' => esc_html__( 'Footer Controls (px)', 'bookflare' ),
            'section' => 'themesflat_footer',
            'type' => 'box-controls',
            'priority' => 7
        ))
    );

    // Enable bottom
    $wp_customize->add_setting(
      'footer_enable_botom',
        array(
            'sanitize_callback' => 'themesflat_sanitize_checkbox',
            'default' => themesflat_customize_default_opt('footer_enable_botom'),     
        )   
    );
    $wp_customize->add_control(new themesflat_Checkbox( $wp_customize,
        'footer_enable_botom',
        array(
            'type' => 'checkbox',
            'label' => esc_html__('Show/Hide bottom Footer', 'bookflare'),
            'section' => 'themesflat_footer',
            'priority' => 8,
        ))
    ); 
    // Footer Content
    $wp_customize->add_setting(
        'footer_copyright',
        array(
            'default' => themesflat_customize_default_opt('footer_copyright'),
            'sanitize_callback' => 'themesflat_sanitize_text',
        )
    );
    $wp_customize->add_control(
        'footer_copyright',
        array(
            'label' => esc_html__( 'Copyright', 'bookflare' ),
            'section' => 'themesflat_footer',
            'type' => 'textarea',
            'priority' => 9
        )
    );  

    // Enable bottom
    $wp_customize->add_setting(
      'footer_enable_gotop',
        array(
            'sanitize_callback' => 'themesflat_sanitize_checkbox',
            'default' => themesflat_customize_default_opt('footer_enable_gotop'),     
        )   
    );
    $wp_customize->add_control(new themesflat_Checkbox( $wp_customize,
        'footer_enable_gotop',
        array(
            'type' => 'checkbox',
            'label' => esc_html__('Show/Hide button go to top', 'bookflare'),
            'section' => 'themesflat_footer',
            'priority' => 10,
        ))
    );


    // Section Typography
    $wp_customize->add_section(
        'flat_typography',
        array(
            'title' => esc_html__('Typography', 'bookflare'),
            'priority' => 6,            
        )
    );

    // Heading Typography
    $wp_customize->add_control( new themesflat_Info( $wp_customize, 'custom-typography', array(
        'label' => esc_html__('BODY FONT', 'bookflare'),
        'section' => 'flat_typography',
        'settings' => 'themesflat_options[info]',
        'priority' => 2
        ) )
    );    

    // Desc Typography
    $wp_customize->add_control( new themesflat_Desc_Info( $wp_customize, 'desc_customizer_logo', array(
        'label' => esc_html__('You can modify the font family, size, color, ... for global content.', 'bookflare'),
        'section' => 'flat_typography',
        'settings' => 'themesflat_options[info]',
        'priority' => 3
        ) )
    );

    // Body fonts
    $wp_customize->add_setting(
        'body_font_name',
        array(
            'default' => themesflat_customize_default_opt('body_font_name'),
            'sanitize_callback' => 'esc_html',
        )
    );
    $wp_customize->add_control( new themesflat_Typography($wp_customize,
        'body_font_name',
        array(
            'label' => esc_html__( 'Font name/style/sets', 'bookflare' ),
            'section' => 'flat_typography',
            'type' => 'typography',
            'fields' => array('family','style','line_height','size'),
            'priority' => 4
        ))
    );

    // Headings fonts
    $wp_customize->add_control( new themesflat_Info( $wp_customize, 'custom-heading-font', array(
        'label' => esc_html__('Headings fonts', 'bookflare'),
        'section' => 'flat_typography',
        'settings' => 'themesflat_options[info]',
        'priority' => 8
        ) )
    );    

    // Desc font
    $wp_customize->add_control( new themesflat_Desc_Info( $wp_customize, 'desc_customizer_heading-font', array(
        'label' => esc_html__('You can modify the font options for your headings. h1, h2, h3, h4, ...', 'bookflare'),
        'section' => 'flat_typography',
        'settings' => 'themesflat_options[info]',
        'priority' => 9
        ) )
    );   

    $wp_customize->add_setting(
        'headings_font_name',
        array(
            'default' => themesflat_customize_default_opt('headings_font_name'),
            'sanitize_callback' => 'esc_html',
        )
    );
    $wp_customize->add_control( new themesflat_Typography($wp_customize,
        'headings_font_name',
        array(
            'label' => esc_html__( 'Font name/style/sets', 'bookflare' ),
            'section' => 'flat_typography',
            'type' => 'typography',
            'fields' => array('family','style'),
            'priority' => 11
        ))
    );

    // H1 size
    $wp_customize->add_setting(
        'h1_size',
        array(
            'sanitize_callback' => 'absint',
            'default'           => themesflat_customize_default_opt('h1_size'),
        )       
    );
    $wp_customize->add_control( 'h1_size', array(
        'type'        => 'number',
        'priority'    => 13,
        'section'     => 'flat_typography',
        'label'       => esc_html__('H1 font size (px)', 'bookflare'),
        'input_attrs' => array(
            'min'   => 10,
            'max'   => 60,
            'step'  => 1,
            'style' => 'margin-bottom: 15px; padding: 10px;',
        ),
    ) );

    // H2 size
    $wp_customize->add_setting(
        'h2_size',
        array(
            'sanitize_callback' => 'absint',
            'default'           =>  themesflat_customize_default_opt('h2_size'),
        )       
    );
    $wp_customize->add_control( 'h2_size', array(
        'type'        => 'number',
        'priority'    => 14,
        'section'     => 'flat_typography',
        'label'       => esc_html__('H2 font size (px)', 'bookflare'),
        'input_attrs' => array(
            'min'   => 10,
            'max'   => 60,
            'step'  => 1,
            'style' => 'margin-bottom: 15px; padding: 10px;',
        ),
    ) );

    // H3 size
    $wp_customize->add_setting(
        'h3_size',
        array(
            'sanitize_callback' => 'absint',
            'default'           => themesflat_customize_default_opt('h3_size'),
        )       
    );
    $wp_customize->add_control( 'h3_size', array(
        'type'        => 'number',
        'priority'    => 15,
        'section'     => 'flat_typography',
        'label'       => esc_html__('H3 font size (px)', 'bookflare'),
        'input_attrs' => array(
            'min'   => 10,
            'max'   => 60,
            'step'  => 1,
            'style' => 'margin-bottom: 15px; padding: 10px;',
        ),
    ) );

    // H4 size
    $wp_customize->add_setting(
        'h4_size',
        array(
            'sanitize_callback' => 'absint',
            'default'           =>  themesflat_customize_default_opt('h4_size'),
        )       
    );
    $wp_customize->add_control( 'h4_size', array(
        'type'        => 'number',
        'priority'    => 16,
        'section'     => 'flat_typography',
        'label'       => esc_html__('H4 font size (px)', 'bookflare'),
        'input_attrs' => array(
            'min'   => 10,
            'max'   => 60,
            'step'  => 1,
            'style' => 'margin-bottom: 15px; padding: 10px;',
        ),
    ) );

    // H5 size
    $wp_customize->add_setting(
        'h5_size',
        array(
            'sanitize_callback' => 'absint',
            'default'           =>  themesflat_customize_default_opt('h5_size'),
        )       
    );
    $wp_customize->add_control( 'h5_size', array(
        'type'        => 'number',
        'priority'    => 17,
        'section'     => 'flat_typography',
        'label'       => esc_html__('H5 font size (px)', 'bookflare'),
        'input_attrs' => array(
            'min'   => 10,
            'max'   => 60,
            'step'  => 1,
            'style' => 'margin-bottom: 15px; padding: 10px;',
        ),
    ) );

    // H6 size
    $wp_customize->add_setting(
        'h6_size',
        array(
            'sanitize_callback' => 'absint',
            'default'           =>  themesflat_customize_default_opt('h6_size'),
        )       
    );
    $wp_customize->add_control( 'h6_size', array(
        'type'        => 'number',
        'priority'    => 18,
        'section'     => 'flat_typography',
        'label'       => esc_html__('H6 font size (px)', 'bookflare'),
        'input_attrs' => array(
            'min'   => 10,
            'max'   => 60,
            'step'  => 1,
            'style' => 'margin-bottom: 15px; padding: 10px;',
        ),
    ) );

    // Heading Menu fonts
    $wp_customize->add_setting('themesflat_options[info]', array(
            'type'              => 'info_control',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'esc_attr',            
        )
    );
    $wp_customize->add_control( new themesflat_Info( $wp_customize, 'menu_fonts', array(
        'label' => esc_html__('Menu fonts', 'bookflare'),
        'section' => 'flat_typography',
        'settings' => 'themesflat_options[info]',
        'priority' => 19
        ) )
    );

    $wp_customize->add_setting(
        'menu_font_name',
        array(
            'default' => themesflat_customize_default_opt('menu_font_name'),
                'sanitize_callback' => 'esc_html',
        )
    );
    $wp_customize->add_control( new themesflat_Typography($wp_customize,
        'menu_font_name',
        array(
            'label' => esc_html__( 'Font name/style/sets', 'bookflare' ),
            'section' => 'flat_typography',
            'type' => 'typography',
            'fields' => array('family','style','size','line_height'),
            'priority' => 20
        ))
    );

    //__Color__//
    $wp_customize->add_panel('color_panel',array(
        'title'         => esc_html__('Color','bookflare'),
        'description'   => esc_html__('This is panel Description','bookflare'),
        'priority'      => 7,
    ));

    // ADD SECTION GENERAL
    $wp_customize->add_section('color_general',array(
        'title'         => esc_html__('General','bookflare'),
        'priority'      => 1,
        'panel'         => 'color_panel',
    ));

    // Heading Color Scheme
    $wp_customize->add_control( new themesflat_Info( $wp_customize, 'color_scheme', array(
        'label' => esc_html__('SCHEME COLOR', 'bookflare'),
        'section' => 'color_general',
        'settings' => 'themesflat_options[info]',
        'priority' => 1
        ) )
    );    

    // Desc color scheme
    $wp_customize->add_control( new themesflat_Desc_Info( $wp_customize, 'desc_color_schemer', array(
        'label' => esc_html__('Select the color that will be used for theme color.','bookflare'),
        'section' => 'color_general',
        'settings' => 'themesflat_options[info]',
        'priority' => 2
        ) )
    );

    $wp_customize->add_setting(
        'scheme_color',
        array(
            'default'           => themesflat_customize_default_opt('scheme_color'),
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'scheme_color',
            array(
                'label'         => esc_html__('Scheme color', 'bookflare'),
                'section'       => 'color_general',
                'settings'      => 'scheme_color',
                'priority'      => 3
            )
        )
    );  
    // Body Color
    $wp_customize->add_setting(
        'body_text_color',
        array(
            'default'           => themesflat_customize_default_opt('body_text_color'),
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'body_text_color',
            array(
                'label'         => esc_html__('Body Color', 'bookflare'),
                'section'       => 'color_general',
                'settings'      => 'body_text_color',
                'priority'      => 4
            )
        )
    );

    // Hover Body Color
     $wp_customize->add_setting(
        'hover_body_color',
        array(
            'default'           => themesflat_customize_default_opt('hover_body_color'),
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'hover_body_color',
            array(
                'label'         => esc_html__('Hover, Focus, Active Body Color', 'bookflare'),
                'section'       => 'color_general',
                'settings'      => 'hover_body_color',
                'priority'      => 5
            )
        )
    );  

     // ADD SECTION HEADER COLOR
    $wp_customize->add_section('color_header',array(
        'title'=>'Header',
        'priority'=>2,
        'panel'=>'color_panel',
    ));

    // Title section portfolio
    $wp_customize->add_setting('themesflat_options[info]', array(
        'type'              => 'info_control',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'esc_attr',            
        )
    );
    $wp_customize->add_control( new themesflat_Info( $wp_customize, 'topbar_color', array(
        'label' => esc_html__('Top Color', 'bookflare'),
        'section' => 'color_header',
        'settings' => 'themesflat_options[info]',
        'priority' => 1
        ) )
    );      

    $wp_customize->add_section('color_header',array(
        'title'=>'Header',
        'priority'=>2,
        'panel'=>'color_panel',
    ));

    // Title section portfolio
    $wp_customize->add_setting('themesflat_options[info]', array(
        'type'              => 'info_control',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'esc_attr',            
        )
    );
    $wp_customize->add_control( new themesflat_Info( $wp_customize, 'topbar_color', array(
        'label' => esc_html__('Top Color', 'bookflare'),
        'section' => 'color_header',
        'settings' => 'themesflat_options[info]',
        'priority' => 3
        ) )
    );  

    // Top bar background color
    $wp_customize->add_setting(
        'top_background_color',
        array(
            'default'           => themesflat_customize_default_opt('top_background_color'),
            'sanitize_callback' => 'esc_attr',
        )
    );
    $wp_customize->add_control(
        new themesflat_ColorOverlay(
            $wp_customize,
            'top_background_color',
            array(
                'label'         => esc_html__('Topbar Backgound', 'bookflare'),
                'description'   => esc_html__(' Opacity =1 for Background Color', 'bookflare'),
                'section'       => 'color_header',
                'settings'      => 'top_background_color',
                'priority'      => 4
            )
        )
    );

    // Top bar text color
    $wp_customize->add_setting(
        'topbar_textcolor',
        array(
            'default'           => themesflat_customize_default_opt('topbar_textcolor'),
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'topbar_textcolor',
            array(
                'label'         => esc_html__('Topbar Text Color', 'bookflare'),
                'section'       => 'color_header',
                'settings'      => 'topbar_textcolor',
                'priority'      => 5
            )
        )
    );

    // Top bar background color count down
    $wp_customize->add_setting(
        'top_background_colorcd',
        array(
            'default'           => themesflat_customize_default_opt('top_background_colorcd'),
            'sanitize_callback' => 'esc_attr',
        )
    );
    $wp_customize->add_control(
        new themesflat_ColorOverlay(
            $wp_customize,
            'top_background_colorcd',
            array(
                'label'         => esc_html__('Topbar Backgound count down', 'bookflare'),
                'description'   => esc_html__(' Opacity =1 for Background Color count down', 'bookflare'),
                'section'       => 'color_header',
                'settings'      => 'top_background_colorcd',
                'priority'      => 6
            )
        )
    );

    // Top bar text color count down
    $wp_customize->add_setting(
        'topbar_textcolorcd',
        array(
            'default'           => themesflat_customize_default_opt('topbar_textcolorcd'),
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'topbar_textcolorcd',
            array(
                'label'         => esc_html__('Topbar Text Color in count down', 'bookflare'),
                'section'       => 'color_header',
                'settings'      => 'topbar_textcolorcd',
                'priority'      => 7
            )
        )
    );

    // MENU COLOR
    $wp_customize->add_control( new themesflat_Info( $wp_customize, 'menu_color', array(
        'label' => esc_html__('MENU COLOR', 'bookflare'),
        'section' => 'color_header',
        'settings' => 'themesflat_options[info]',
        'priority' => 8
        ) )
    );    

    // Desc
    $wp_customize->add_control( new themesflat_Desc_Info( $wp_customize, 'desc_menu_color', array(
        'label' => esc_html__('Select color for background menu, background submenu color menu a, color menu a:hover, background menu a:hover...','bookflare'),
        'section' => 'color_header',
        'settings' => 'themesflat_options[info]',
        'priority' => 9
        ) )
    );   

    // Menu Background
    $wp_customize->add_setting(
        'mainnav_backgroundcolor',
        array(
            'default'           => themesflat_customize_default_opt('mainnav_backgroundcolor'),
            'sanitize_callback' => 'esc_attr',
        )
    );
    $wp_customize->add_control( new themesflat_ColorOverlay(
            $wp_customize,
            'mainnav_backgroundcolor',
            array(
                'label'         => esc_html__('Mainnav Background', 'bookflare'),
                'description'   => esc_html__(' Opacity =1 for Background Color', 'bookflare'),
                'section'       => 'color_header',
                'priority'      => 10
            )
        )
    );   

    // Menu a color
    $wp_customize->add_setting(
        'mainnav_color',
        array(
            'default'           => themesflat_customize_default_opt('mainnav_color'),
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'mainnav_color',
            array(
                'label' => esc_html__('Mainnav a color', 'bookflare'),
                'section' => 'color_header',
                'priority' => 11
            )
        )
    );

    // Menu Hover Background color
    $wp_customize->add_setting(
        'mainnav_hover_background',
        array(
            'default'           => themesflat_customize_default_opt('mainnav_hover_background'),
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control(
        new themesflat_ColorOverlay(
            $wp_customize,
            'mainnav_hover_background',
            array(
                'label' => esc_html__('Mainnav Hover Background', 'bookflare'),
                'section' => 'color_header',
                'priority' => 12
            )
        )
    );

    // Menu a:hover color
    $wp_customize->add_setting(
        'mainnav_hover_color',
        array(
            'default'           => themesflat_customize_default_opt('mainnav_hover_color'),
            'sanitize_callback' => 'esc_attr'
        )
    );
    $wp_customize->add_control(
        new themesflat_ColorOverlay(
            $wp_customize,
            'mainnav_hover_color',
            array(
                'label' => esc_html__('Mainnav a:hover color', 'bookflare'),
                'section' => 'color_header',
                'priority' => 13
            )
        )
    );


    // Border color li sub nav
    $wp_customize->add_setting(
        'border_color_sub_nav',
        array(
            'default'           => themesflat_customize_default_opt('border_color_sub_nav'),
            'sanitize_callback' => 'esc_attr',
        )
    );
    $wp_customize->add_control(
        new themesflat_ColorOverlay(
            $wp_customize,
            'border_color_sub_nav',
            array(
                'label' => esc_html__('Border color sub nav', 'bookflare'),
                'section' => 'color_header',
                'priority' => 16
            )
        )
    );
    // Border color li sub nav
    $wp_customize->add_setting(
        'background_color_sub_nav',
        array(
            'default'           => themesflat_customize_default_opt('background_color_sub_nav'),
            'sanitize_callback' => 'esc_attr',
        )
    );
    $wp_customize->add_control(
        new themesflat_ColorOverlay(
            $wp_customize,
            'background_color_sub_nav',
            array(
                'label' => esc_html__('Background color hover sub nav', 'bookflare'),
                'section' => 'color_header',
                'priority' => 16
            )
        )
    );

    $wp_customize->add_section('color_footer',array(
        'title'=>'Footer',
        'priority'=>3,
        'panel'=>'color_panel',
    )); 
    // Footer page callback
    $wp_customize->add_control( new themesflat_Info( $wp_customize, 'custom_cb_footer', array(
        'label' => esc_html__('Footer Expert Instruction', 'bookflare'),
        'section' => 'color_footer',
        'settings' => 'themesflat_options[info]',
        'priority' => 1
        ) )
    );
    $wp_customize->add_setting(
        'custom_cb_color_icon',
        array(
            'default' => themesflat_customize_default_opt('custom_cb_color_icon'),
            'sanitize_callback' => 'esc_attr',
        )
    );    
    $wp_customize->add_control(
        new themesflat_ColorOverlay(
            $wp_customize,
            'custom_cb_color_icon',
            array(
               'label'          => esc_html__( 'Color for icon', 'bookflare' ),
               'section'        => 'color_footer',
               'priority'       => 1,
            )
        )
    );

    $wp_customize->add_setting(
        'custom_cb_color_text',
        array(
            'default' => themesflat_customize_default_opt('custom_cb_color_text'),
            'sanitize_callback' => 'esc_attr',
        )
    );    
    $wp_customize->add_control(
        new themesflat_ColorOverlay(
            $wp_customize,
            'custom_cb_color_text',
            array(
               'label'          => esc_html__( 'Color for Text', 'bookflare' ),
               'section'        => 'color_footer',
               'priority'       => 1,
            )
        )
    );

    $wp_customize->add_setting(
        'custom_cb_background',
        array(
            'default' => themesflat_customize_default_opt('custom_cb_background'),
            'sanitize_callback' => 'esc_url_raw',
        )
    );    
    $wp_customize->add_control(
        new WP_Customize_Image_Control(
            $wp_customize,
            'custom_cb_background',
            array(
               'label'          => esc_html__( 'Background image Expert Instruction', 'bookflare' ),
               'type'           => 'image',
               'section'        => 'color_footer',
               'priority'       => 1,
            )
        )
    );
     $wp_customize->add_setting(
        'bc_custom_opacity',
        array(
            'default'           => themesflat_customize_default_opt('bc_custom_opacity'),
            'sanitize_callback' => 'esc_attr',
        )
    );
    $wp_customize->add_control(
        new themesflat_ColorOverlay(
            $wp_customize,
            'bc_custom_opacity',
            array(
                'label'         => esc_html__('Backgound Opacity Expert Instruction', 'bookflare'),
                'description'   => esc_html__(' Opacity =1 for Background Color', 'bookflare'),
                'section'       => 'color_footer',
                'priority'      => 1
            )
        )
    );
    //background footer
    $wp_customize->add_setting(
        'backgroud_footer',
        array(
            'default' => themesflat_customize_default_opt('backgroud_footer'),
            'sanitize_callback' => 'esc_url_raw',
        )
    );    
    $wp_customize->add_control(
        new WP_Customize_Image_Control(
            $wp_customize,
            'backgroud_footer',
            array(
               'label'          => esc_html__( 'Background image footer', 'bookflare' ),
               'description'    => esc_html__( 'Background for footer ( If you don\'t display logo please remove it your website display this show default background color below)', 'bookflare' ),
               'type'           => 'image',
               'section'        => 'color_footer',
               'priority'       => 1,
            )
        )
    );
    // footer background color
    $wp_customize->add_setting(
        'call_back_bg_color_footer',
        array(
            'default'           => themesflat_customize_default_opt('call_back_bg_color_footer'),
            'sanitize_callback' => 'esc_attr',
        )
    );
    $wp_customize->add_control(
        new themesflat_ColorOverlay(
            $wp_customize,
            'call_back_bg_color_footer',
            array(
                'label'         => esc_html__('Backgound Color of footer', 'bookflare'),
                'description'   => esc_html__(' Opacity =1 for Background Color', 'bookflare'),
                'section'       => 'color_footer',
                'settings'      => 'call_back_bg_color_footer',
                'priority'      => 2
            )
        )
    );

    // Footer text color
    $wp_customize->add_setting(
        'footer_text_color',
        array(
            'default'           => themesflat_customize_default_opt('footer_text_color'),
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );

    // Footer text color
    $wp_customize->add_setting(
        'footer_text_color_title',
        array(
            'default'           => themesflat_customize_default_opt('footer_text_color_title'),
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control(
        new themesflat_ColorOverlay(
            $wp_customize,
            'footer_text_color_title',
            array(
                'label'         => esc_html__('Footer Text Color Title Widget', 'bookflare'),
                'section'       => 'color_footer',
                'settings'      => 'footer_text_color_title',
                'priority'      => 3
            )
        )
    );

    $wp_customize->add_control(
        new themesflat_ColorOverlay(
            $wp_customize,
            'footer_text_color',
            array(
                'label'         => esc_html__('Footer Text Color', 'bookflare'),
                'section'       => 'color_footer',
                'settings'      => 'footer_text_color',
                'priority'      => 3
            )
        )
    ); 

    // bottom background color
    $wp_customize->add_setting(
        'bottom__background_color',
        array(
            'default'           => themesflat_customize_default_opt('bottom__background_color'),
            'sanitize_callback' => 'esc_attr',
        )
    );
    $wp_customize->add_control(
        new themesflat_ColorOverlay(
            $wp_customize,
            'bottom__background_color',
            array(
                'label'         => esc_html__('Bottom Backgound', 'bookflare'),
                'description'   => esc_html__(' Opacity =1 for Background Color', 'bookflare'),
                'section'       => 'color_footer',
                'priority'      => 5
            )
        )
    );

    // Bottom text color
    $wp_customize->add_setting(
        'bottom_text_color',
        array(
            'default'           => themesflat_customize_default_opt('bottom_text_color'),
            'sanitize_callback' => 'esc_attr',
        )
    );
    $wp_customize->add_control(
        new themesflat_ColorOverlay(
            $wp_customize,
            'bottom_text_color',
            array(
                'label'         => esc_html__('Bottom Text Color', 'bookflare'),
                'section'       => 'color_footer',
                'settings'      => 'bottom_text_color',
                'priority'      => 6
            )
        )
    );  
    
    //__Page title and breadcrumb__//
    $wp_customize->add_panel('page_title_panel',array(
        'title'         => esc_html__('Page Title & Breadcrumb','bookflare'),
        'description'   => 'This is panel Description',
        'priority'      => 8,
    ));

    $wp_customize->add_section('page_title_style',array(
        'title'         => esc_html__('Page Title Style','bookflare'),
        'priority'      => 1,
        'panel'         => 'page_title_panel',
    ));

    $wp_customize->add_control( new themesflat_Info( $wp_customize, 'page_title_style', array(
        'label' => esc_html__('Page Title Style', 'bookflare'),
        'section' => 'page_title_style',
        'settings' => 'themesflat_options[info]',
        'priority' => 1
        ) )
    );   
    

     // Show page title
    $wp_customize->add_setting(
      'show_page_title',
        array(
            'sanitize_callback' => 'themesflat_sanitize_checkbox',
            'default' => themesflat_customize_default_opt('show_page_title'),     
        )   
    );

    $wp_customize->add_control( new themesflat_Checkbox( $wp_customize,
        'show_page_title',
        array(
            'type' => 'checkbox',
            'label' => esc_html__('Show page title', 'bookflare'),
            'section' => 'page_title_style',
            'priority' => 2,
        ))
    );

     // Show page heading
    $wp_customize->add_setting(
      'show_page_title_heading',
        array(
            'sanitize_callback' => 'themesflat_sanitize_checkbox',
            'default' => themesflat_customize_default_opt('show_page_title_heading'),     
        )   
    );

    $wp_customize->add_control( new themesflat_Checkbox( $wp_customize,
        'show_page_title_heading',
        array(
            'type' => 'checkbox',
            'label' => esc_html__('Show page title heading', 'bookflare'),
            'section' => 'page_title_style',
            'priority' => 3,
        ))
    );      
    $wp_customize->add_setting(
                'page_title_style_breadcrumb',
                array(
                    'default'           => themesflat_get_opt('page_title_style_breadcrumb'),
                    'sanitize_callback' => 'esc_attr',
                )
            );
    $wp_customize->add_control( new Themesflat_RadioImages($wp_customize,
        'page_title_style_breadcrumb',
        array(
            'type'      => 'radio-images',           
            'section'   => 'page_title_style',
            'priority'  => 4,
            'label'         => esc_html__('Click the page style for your website', 'bookflare'),
            'choices'   => array (
                'style_page_title_1'=> array (
                   'tooltip'   => esc_html__('Page title Type1','bookflare'),
                   'src'       => THEMESFLAT_LINK . 'images/page-title/pagetitle2.jpg'
                ) ,
                'style_page_title_2'=>  array (
                   'tooltip'   => esc_html__('Page title Type2','bookflare'),
                   'src'       => THEMESFLAT_LINK . 'images/page-title/pagetitle1.jpg'
                ) ,
            ),
        ))
    ); 
    //Page Title Background
    $wp_customize->add_setting(
        'page_title_background_image',
        array(
            'default' => themesflat_customize_default_opt('page_title_background_image'),
            'sanitize_callback' => 'esc_url_raw',
        )
    );    
    $wp_customize->add_control(
        new WP_Customize_Image_Control(
            $wp_customize,
            'page_title_background_image',
            array(
               'label'          => esc_html__( 'Upload your page title image ', 'bookflare' ),
               'type'           => 'image',
               'section'        => 'page_title_style',
               'priority'       => 5,
            )
        )
    );
        
    // Show parallax page title
    $wp_customize->add_setting(
      'show_parallax_page_title',
        array(
            'sanitize_callback' => 'themesflat_sanitize_checkbox',
            'default' => themesflat_customize_default_opt('show_parallax_page_title'),     
        )   
    );

    $wp_customize->add_control( new themesflat_Checkbox( $wp_customize,
        'show_parallax_page_title',
        array(
            'type' => 'checkbox',
            'label' => esc_html__('Enable parallax page img title', 'bookflare'),
            'section' => 'page_title_style',
            'priority' => 5,
        ))
    ); 

    // Select position page title
    $wp_customize->add_setting(
        'position_page_title',
        array(
            'default'           => themesflat_customize_default_opt('position_page_title'),
            'sanitize_callback' => 'themesflat_sanitize_position_page_title',
        )
    );

    $wp_customize->add_control(
        'position_page_title',
        array(
            'type'      => 'select',           
            'section'   => 'page_title_style',
            'priority'  => 5,
            'label'     => esc_html__('Select position page title', 'bookflare'),
            'description'   => esc_html__('This is work page title all Type', 'bookflare'),
            'choices'   => array(                
                1     => esc_html__( 'Left', 'bookflare' ),
                2     => esc_html__( 'Right', 'bookflare' ),
                3     => esc_html__( 'Center', 'bookflare' ),               
            )
        )
    );
     // Top Content
    $wp_customize->add_setting(
        'page_title_textarea',
        array(
            'default' => themesflat_customize_default_opt('page_title_textarea'),
            'sanitize_callback' => 'themesflat_sanitize_text'
        )
    );
    $wp_customize->add_control(
        'page_title_textarea',
        array(
            'label' => esc_html__( 'Sub of Title Page', 'bookflare' ),
            'section' => 'page_title_style',
            'type' => 'textarea',
            'priority' => 5
        )
    );
    // Page Title Color
    $wp_customize->add_setting(
        'page_title_text_color',
        array(
            'default'           => themesflat_customize_default_opt('page_title_text_color'),
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'page_title_text_color',
            array(
                'label'         => esc_html__('Page Heading Text Color', 'bookflare'),
                'section'       => 'page_title_style',
                'priority'      => 6
            )
        )
    );

    // Page Title Link Color
    $wp_customize->add_setting(
        'page_title_link_color',
        array(
            'default'           => themesflat_customize_default_opt('page_title_link_color'),
            'sanitize_callback' => 'sanitize_hex_color',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'page_title_link_color',
            array(
                'label'         => esc_html__('Breadcrumb Text Color', 'bookflare'),
                'section'       => 'page_title_style',
                'priority'      => 7
            )
        )
    );

    // Overlay
    $wp_customize->add_setting(
        'page_title_overlay_color',
        array(
            'default'           => themesflat_customize_default_opt('page_title_overlay_color'),
            'sanitize_callback' => 'esc_attr',
        )
    );
    $wp_customize->add_control( new themesflat_ColorOverlay(
            $wp_customize,
            'page_title_overlay_color',
            array(
                'label'         => esc_html__('Page Title Overlay Color', 'bookflare'),
                'description'   => esc_html__(' Opacity = 0.5 for Background Color', 'bookflare'),
                'section'       => 'page_title_style',
                'priority'      => 8
            )
        )
    );

    // Box control
    $wp_customize->add_setting(
        'page_title_controls',
        array(
            'default' => themesflat_customize_default_opt('page_title_controls'),
            'sanitize_callback' => 'themesflat_sanitize_text',
        )
    );
    $wp_customize->add_control( new themesflat_BoxControls($wp_customize,
        'page_title_controls',
        array(
            'label' => esc_html__( 'Page Title Controls (px)', 'bookflare' ),
            'section' => 'page_title_style',
            'type' => 'box-controls',
            'priority' => 15
        ))
    );

    // ADD SECTION BREADCRUMB
    $wp_customize->add_section('page_break_crumb_section',array(
        'title'         => esc_html__('Page Breadcrumb','bookflare'),
        'priority'      => 10,
        'panel'         => 'page_title_panel',
    ));

   // Breadcrumb section
    $wp_customize->add_control( new themesflat_Info( $wp_customize, 'page_break_crumb_section', array(
        'label' => esc_html__('Page Breadcrumb', 'bookflare'),
        'section' => 'page_break_crumb_section',
        'settings' => 'themesflat_options[info]',
        'priority' => 1
        ) )
    );  

     // Breadcrumb
    $wp_customize->add_setting(
      'breadcrumb_enabled',
        array(
            'sanitize_callback' => 'themesflat_sanitize_checkbox',
            'default' => themesflat_customize_default_opt('breadcrumb_enabled'),     
        )   
    );

    $wp_customize->add_control( new themesflat_Checkbox( $wp_customize,
        'breadcrumb_enabled',
        array(
            'type' => 'checkbox',
            'label' => esc_html__('Enable Breadcrumb', 'bookflare'),
            'section' => 'page_break_crumb_section',
            'priority' => 14,
        ))
    );    

    $wp_customize->add_setting (
        'bread_crumb_prefix',
        array(
            'default' => themesflat_customize_default_opt('bread_crumb_prefix') ,
            'sanitize_callback' => 'themesflat_sanitize_text'
        )
    );

    $wp_customize->add_control(
        'bread_crumb_prefix',
        array(
            'type'      => 'text',
            'label'     => esc_html__('Breadcrumb Prefix', 'bookflare'),
            'section'   => 'page_break_crumb_section',
            'priority'  => 15
        )
    );  

    $wp_customize->add_setting (
        'breadcrumb_separator',
        array(
            'default' => themesflat_customize_default_opt('breadcrumb_separator'),
            'sanitize_callback' => 'themesflat_sanitize_text'
        )
    );

    $wp_customize->add_control(
        'breadcrumb_separator',
        array(
            'type'      => 'text',
            'label'     => esc_html__('Breadcrumb Separator', 'bookflare'),
            'section'   => 'page_break_crumb_section',
            'priority'  => 16
        )
    ); 
     // Section Blog
    $wp_customize->add_section(
        'blog_options',
        array(
            'title' => esc_html__('Post', 'bookflare'),
            'priority' => 9,
        )
    );

    // Heading Blog
    $wp_customize->add_control( new themesflat_Info( $wp_customize, 'bloglist', array(
        'label' => esc_html__('Blog List', 'bookflare'),
        'section' => 'blog_options',
        'settings' => 'themesflat_options[info]',
        'priority' => 1
        ) )
    );    

    // Desc blog
    $wp_customize->add_control( new themesflat_Desc_Info( $wp_customize, 'desc_customizer_bloglist', array(
        'label' => esc_html__('All options in this section will be used to make style for blog page.','bookflare'),
        'section' => 'blog_options',
        'settings' => 'themesflat_options[info]',
        'priority' => 2
        ) )
    );   

    $wp_customize->add_setting(
        'blog_layout',
        array(
            'default'           => themesflat_customize_default_opt('blog_layout'),
            'sanitize_callback' => 'esc_attr',
        )
    );
    $wp_customize->add_control( 
        'blog_layout',
        array (
            'type'      => 'select',           
            'section'   => 'blog_options',
            'priority'  => 3,
            'label'         => esc_html__('Sidebar Position', 'bookflare'),
            'choices'   => array (
                'sidebar-right' => esc_html__( 'Sidebar Right','bookflare' ),
                'sidebar-left'=>  esc_html__( 'Sidebar Left','bookflare' ),
                'fullwidth' =>   esc_html__( 'Full Width','bookflare' )
                ) ,
        )
    );

    $wp_customize->add_setting(
        'blog_archive_layout',
        array(
            'default'           => themesflat_customize_default_opt('blog_archive_layout'),
            'sanitize_callback' => 'esc_attr',
        )
    );

     $wp_customize->add_control( 
        'blog_archive_layout',
        array (
            'type'      => 'select',           
            'section'   => 'blog_options',
            'priority'  => 3,
            'label'         => esc_html__('Blog Layout', 'bookflare'),
            'choices'   => array (
                'blog-list' =>  esc_html__( 'Blog List','bookflare' ),
                )  
        )
    );
    $wp_customize->add_setting (
        'blog_sidebar_list',
        array(
            'default'           => themesflat_customize_default_opt('blog_sidebar_list'),
            'sanitize_callback' => 'esc_html',
        )
    );

    $wp_customize->add_control( new themesflat_DropdownSidebars($wp_customize,
        'blog_sidebar_list',
        array(
            'type'      => 'dropdown',           
            'section'   => 'blog_options',
            'priority'  => 3,
            'label'         => esc_html__('List Sidebar Position', 'bookflare'),
            
        ))
    );

    // Excerpt
    $wp_customize->add_setting(
        'blog_archive_post_excepts_length',
        array(
            'sanitize_callback' => 'absint',
            'default'           => themesflat_customize_default_opt('blog_archive_post_excepts_length'),
        )       
    );
    $wp_customize->add_control( 'blog_archive_post_excepts_length', array(
        'type'        => 'text',
        'priority'    => 4,
        'section'     => 'blog_options',
        'label'       => esc_html__('Post Excepts Length', 'bookflare'),
        'input_attrs' => array(
            'min'   => 10,
            'max'   => 200,
            'step'  => 5
        ),
    ) );

    // Show Read More
    $wp_customize->add_setting (
        'blog_archive_readmore',
        array (
            'sanitize_callback' => 'themesflat_sanitize_checkbox',
            'default' => themesflat_customize_default_opt('blog_archive_readmore'),     
        )
    );
    $wp_customize->add_control( new themesflat_Checkbox( $wp_customize,
        'blog_archive_readmore',
        array(
            'type'      => 'checkbox',
            'label'     => esc_html__('Show Read More', 'bookflare'),
            'section'   => 'blog_options',
            'priority'  => 6,
        ))
    );

    // Read More Text
    $wp_customize->add_setting (
        'blog_archive_readmore_text',
        array(
            'default' => themesflat_customize_default_opt('blog_archive_readmore_text'),
            'sanitize_callback' => 'themesflat_sanitize_text'
        )
    );

    $wp_customize->add_control(
        'blog_archive_readmore_text',
        array(
            'type'      => 'text',
            'label'     => esc_html__('Read More Text', 'bookflare'),
            'section'   => 'blog_options',
            'priority'  => 7
        )
    );

    // Show Read More
    $wp_customize->add_setting (
        'show_post_meta',
        array (
            'sanitize_callback' => 'themesflat_sanitize_checkbox',
            'default' => themesflat_customize_default_opt('show_post_meta'),     
        )
    );
    $wp_customize->add_control( new themesflat_Checkbox( $wp_customize,
        'show_post_meta',
        array(
            'type'      => 'checkbox',
            'label'     => esc_html__('Show Post Meta', 'bookflare'),
            'section'   => 'blog_options',
            'priority'  => 7,
        ))
    );

    // Pagination
    $wp_customize->add_setting(
        'blog_archive_pagination_style',
        array(
            'default'           => themesflat_customize_default_opt('blog_archive_pagination_style'),
            'sanitize_callback' => 'esc_attr',
        )
    );
    $wp_customize->add_control( 
        'blog_archive_pagination_style',
        array(
            'type'      => 'select',           
            'section'   => 'blog_options',
            'priority'  => 8,
            'label'         => esc_html__('Pagination Style', 'bookflare'),
            'choices'   => array(
                'pager'     => esc_html__('Pager','bookflare'),
                'numeric'         =>  esc_html__('Numeric','bookflare'),
                'pager-numeric'         =>  esc_html__('Pager & Numeric','bookflare')
            ),
        )
    );

    // Header Blog Single    
    $wp_customize->add_control( new themesflat_Info( $wp_customize, 'blogsingle', array(
        'label' => esc_html__('Blog Single', 'bookflare'),
        'section' => 'blog_options',
        'settings' => 'themesflat_options[info]',
        'priority' => 9
        ) )
    );    

    // Desc Blog Single
    $wp_customize->add_control( new themesflat_Desc_Info( $wp_customize, 'desc_customizer_blogsingle', array(
        'label' => esc_html__('Also, you can change the style for blog single to make your site unique.','bookflare'),
        'section' => 'blog_options',
        'settings' => 'themesflat_options[info]',
        'priority' => 10
        ) )
    );   

    // Show Post Navigator
    $wp_customize->add_setting (
        'show_post_navigator',
        array (
            'sanitize_callback' => 'themesflat_sanitize_checkbox',
            'default' => themesflat_customize_default_opt('show_post_navigator'),     
        )
    );

    $wp_customize->add_control( new themesflat_Checkbox( $wp_customize,
        'show_post_navigator',
        array(
            'type'      => 'checkbox',
            'label'     => esc_html__('Show Post Navigator', 'bookflare'),
            'section'   => 'blog_options',
            'priority'  => 12
        ))
    );
    // Show share link
    $wp_customize->add_setting (
        'show_share_link',
        array (
            'sanitize_callback' => 'themesflat_sanitize_checkbox',
            'default' => themesflat_customize_default_opt('show_share_link'),     
        )
    );

    $wp_customize->add_control( new themesflat_Checkbox( $wp_customize,
        'show_share_link',
        array(
            'type'      => 'checkbox',
            'label'     => esc_html__('Show Share Link', 'bookflare'),
            'section'   => 'blog_options',
            'priority'  => 12
        ))
    );
    // Show author post
    $wp_customize->add_setting (
        'show_author_post',
        array (
            'sanitize_callback' => 'themesflat_sanitize_checkbox',
            'default' => themesflat_customize_default_opt('show_author_post'),     
        )
    );

    $wp_customize->add_control( new themesflat_Checkbox( $wp_customize,
        'show_author_post',
        array(
            'type'      => 'checkbox',
            'label'     => esc_html__('Show Author Post', 'bookflare'),
            'section'   => 'blog_options',
            'priority'  => 12
        ))
    );
  
    // Show Related Posts
    $wp_customize->add_setting (
        'show_related_post',
        array (
            'sanitize_callback' => 'themesflat_sanitize_checkbox',
            'default' => 0,     
        )
    );

    $wp_customize->add_control( new themesflat_Checkbox( $wp_customize,
        'show_related_post',
        array(
            'type'      => 'checkbox',
            'label'     => esc_html__('Show Related Posts', 'bookflare'),
            'section'   => 'blog_options',
            'priority'  => 15
        ))
    );

    //Related Posts Style
    $wp_customize->add_setting(
        'related_post_style',
        array(
            'default'           => themesflat_customize_default_opt('related_post_style'),
            'sanitize_callback' => 'esc_attr',
        )
    );
    $wp_customize->add_control( 
        'related_post_style',
        array(
            'type'      => 'select',           
            'section'   => 'blog_options',
            'priority'  => 16,
            'label'         => esc_html__('Related Posts Style', 'bookflare'),
            'choices'   => array(
                'blog-grid'=>   esc_html__( 'Blog Grid','bookflare' ),
        ))
    );

    // Gird columns Related Posts
    $wp_customize->add_setting(
        'grid_columns_post_related',
        array(
            'default'           => 2,
            'sanitize_callback' => 'themesflat_sanitize_grid_post_related',
        )
    );

    $wp_customize->add_control(
        'grid_columns_post_related',
        array(
            'type'      => 'select',           
            'section'   => 'blog_options',
            'priority'  => 17,
            'label'     => esc_html__('Columns Of Related Posts', 'bookflare'),
            'choices'   => array(                
                2     => esc_html__( '2 Columns', 'bookflare' ),
                3     => esc_html__( '3 Columns', 'bookflare' ),
                4     => esc_html__( '4 Columns', 'bookflare' ),                
            )
        )
    );

    // Number Of Related Posts
    $wp_customize->add_setting (
        'number_related_post',
        array(
            'default' => esc_html__('2', 'bookflare'),
            'sanitize_callback' => 'themesflat_sanitize_text'
        )
    );

    $wp_customize->add_control(
        'number_related_post',
        array(
            'type'      => 'text',
            'label'     => esc_html__('Number Of Related Posts', 'bookflare'),
            'section'   => 'blog_options',
            'priority'  => 18
        )
    );

    // Desc Blog Single
    $wp_customize->add_control( new themesflat_Desc_Info( $wp_customize, 'desc_customizer_blogsingle', array(
        'label' => esc_html__('Social share single post.','bookflare'),
        'section' => 'blog_options',
        'settings' => 'themesflat_options[info]',
        'priority' => 19
        ) )
    ); 
    //__social links__//
    $wp_customize->add_setting(
      'social_link_share_single',
      array(
        'sanitize_callback' => 'esc_attr',
        'default' => themesflat_customize_default_opt('social_link_share_single'),     
      )   
    );

    $wp_customize->add_control( new themesflat_SocialIcons($wp_customize,
        'social_link_share_single',
        array(
            'type' => 'social-icons',
            'label' => esc_html__('Social share single post', 'bookflare'),
            'section' => 'blog_options',
            'priority' => 20,
        ))
    );
    //__Layout Style__//
    $wp_customize->add_section('layout_style_panel',array(
        'title'         => esc_html__('Layout Style','bookflare'),
        'description'   => esc_html__('This is panel Layout style version and change sidebar','bookflare'),
        'priority'      => 10,
    ));

    $wp_customize->add_setting(
        'layout_version',
        array(
            'default'           => themesflat_customize_default_opt('layout_version'),
            'sanitize_callback' => 'esc_attr',
        )
    );
    $wp_customize->add_control( 
        'layout_version',
        array(
            'type'      => 'select',           
            'section'   => 'layout_style_panel',
            'priority'  => 2,
            'label'         => esc_html__('Layout version', 'bookflare'),
            'choices'   => array(
                'wide'           =>  esc_html__('Wide','bookflare'),
                'boxed'         =>   esc_html__('Boxed','bookflare'),
        ))
    );
    
    $wp_customize->add_setting(
        'body_background_img',
        array(
            'default'           => themesflat_customize_default_opt('body_background_img'),
            'sanitize_callback' => 'esc_url_raw',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Image_Control(
            $wp_customize,
            'body_background_img',
            array(
               'label'          => esc_html__( 'Upload your background body', 'bookflare' ),
               'description'    => esc_html__( 'The best size is 192x3387px', 'bookflare' ),
               'type'           => 'image',
               'section'        => 'layout_style_panel',
               'priority'       => 3,
            )
        )
    );
    // body background color
    $wp_customize->add_setting(
        'body_background_color',
        array(
            'default'           => themesflat_customize_default_opt('body_background_color'),
            'sanitize_callback' => 'esc_attr',
        )
    );
    $wp_customize->add_control(
        new themesflat_ColorOverlay(
            $wp_customize,
            'body_background_color',
            array(
                'label'         => esc_html__('Body Background Color', 'bookflare'),
                'description'   => esc_html__(' Opacity =1 for Background Color', 'bookflare'),
                'section'       => 'layout_style_panel',
                'priority'      => 3
            )
        )
    );

    // Sidebars
    $wp_customize->add_control( new themesflat_Info( $wp_customize, 'layout_body', array(
        'label' => esc_html__('SIDEBAR', 'bookflare'),
        'section' => 'layout_style_panel',
        'settings' => 'themesflat_options[info]',
        'priority' => 4
        ) )
    );    

    // Desc
    $wp_customize->add_control( new themesflat_Desc_Info( $wp_customize, 'desc_color_scheme', array(
        'label' => esc_html__('Select the position of sidebar that you wish to display of page.','bookflare'),
        'section' => 'layout_style_panel',
        'settings' => 'themesflat_options[info]',
        'priority' => 5
        ) )
    );   
    //sidebar position
     $wp_customize->add_setting(
        'page_layout',
        array(
            'default'           => themesflat_customize_default_opt('page_layout'),
            'sanitize_callback' => 'esc_attr',
        )
    );

    $wp_customize->add_control(
        'page_layout',
        array (
            'type'      => 'select',           
            'section'   => 'layout_style_panel',
            'priority'  => 6,
            'label'         => esc_html__('Sidebar Position', 'bookflare'),
            'choices'   => array (
                'sidebar-right' =>  esc_html__( 'Sidebar Right','bookflare' ),
                'sidebar-left'=>   esc_html__( 'Sidebar Left','bookflare' ),
                'fullwidth'=>   esc_html__( 'Full Width','bookflare' ),
        ))
    );

    //sidebar select 
    $wp_customize->add_setting (
        'page_sidebar_list',
        array(
            'default'           => themesflat_customize_default_opt('page_sidebar_list'),
            'sanitize_callback' => 'esc_html',
        )
    );

    $wp_customize->add_control( new themesflat_DropdownSidebars($wp_customize,
        'page_sidebar_list',
        array(
            'type'      => 'dropdown',           
            'section'   => 'layout_style_panel',
            'priority'  => 7,
            'label'         => esc_html__('List Sidebar Position', 'bookflare'),            
        ))
    );

    /*Courses*/
     $wp_customize->add_section(
        'courses_options',
        array(
            'title' => esc_html__('Courses', 'bookflare'),
            'priority' => 10,
        )
    );
    $wp_customize->add_control( new themesflat_Info( $wp_customize, 'courselist', array(
        'label' => esc_html__('List Courses', 'bookflare'),
        'section' => 'courses_options',
        'settings' => 'themesflat_options[info]',
        'priority' => 1
        ) )
    ); 
    $wp_customize->add_setting(
        'courses_style',
        array(
            'default'           => themesflat_customize_default_opt('courses_style'),
            'sanitize_callback' => 'esc_attr',
        )
    );

     $wp_customize->add_control( 
        'courses_style',
        array (
            'type'      => 'select',           
            'section'   => 'courses_options',
            'priority'  => 3,
            'label'         => esc_html__('Courses Layout', 'bookflare'),
            'choices'   => array (
                'courses-grid' =>  esc_html__( 'Courses Grid','bookflare' ),
                'courses-list' =>  esc_html__( 'Courses List','bookflare' ),
                )  
        )
    );
    $wp_customize->add_setting(
        'courses_layout',
        array(
            'default'           => themesflat_customize_default_opt('courses_layout'),
            'sanitize_callback' => 'esc_attr',
        )
    );
    // Show layout courses
   $wp_customize->add_control(
        'courses_layout',
        array(
            'type'      => 'select',
            'label'     => esc_html__('Courser Layout Position Single', 'bookflare'),
            'section'   => 'courses_options',
            'priority'  => 16,
            'choices'   => array(
                'sidebar-right'           => esc_html__( 'Sidebar Right', 'bookflare' ),
                'sidebar-left'           => esc_html__( 'Sidebar Left', 'bookflare' ),
                'fullwidth'           => esc_html__( 'Full Width', 'bookflare' )
            ),
        )
    );
    $wp_customize->add_setting(
        'courses_columns',
        array(
            'default'           => themesflat_customize_default_opt('courses_columns'),
            'sanitize_callback' => 'esc_attr',
        )
    );
    $wp_customize->add_control(
        'courses_columns',
        array(
            'type'      => 'select',           
            'section'   => 'courses_options',
            'priority'  => 15,
            'label'     => esc_html__('Show courses Columns', 'bookflare'),
            'choices'   => array( 
                // '12'     => esc_html__( 'List Style', 'bookflare' ),
                '6'     => esc_html__( '2 Columns', 'bookflare' ),
                '4'     => esc_html__( '3 Columns', 'bookflare' ),
                '3'     => esc_html__( '4 Columns', 'bookflare' ),                
            ),
        )
    );
    
    // Excerpt
    $wp_customize->add_setting(
        'courses_archive_post_excepts_length',
        array(
            'sanitize_callback' => 'absint',
            'default'           => '20',
        )       
    );
    $wp_customize->add_control( 'courses_archive_post_excepts_length', array(
        'type'        => 'number',
        'priority'    => 4,
        'section'     => 'courses_options',
        'label'       => esc_html__('Courses Excerpts Length', 'bookflare'),
        'input_attrs' => array(
            'min'   => 10,
            'max'   => 200,
            'step'  => 5
        ),
    ) );
    // Excerpt more
    $wp_customize->add_setting (
        'excerpt_more_courses',
        array(
            'default' => themesflat_customize_default_opt('excerpt_more_courses'),
            'sanitize_callback' => 'themesflat_sanitize_text'
        )
    );
    $wp_customize->add_control(
        'excerpt_more_courses',
        array(
            'type'      => 'text',
            'label'     => esc_html__('Excerpt More', 'bookflare'),
            'section'   => 'courses_options',
            'priority'  => 7
        )
    );
    // Show Excerpt
    $wp_customize->add_setting(
        'courses_archive_excerpt',
          array(
            'sanitize_callback' => 'themesflat_sanitize_checkbox',
            'default' => 'themesflat_sanitize_checkbox',     
        )   
    );
    $wp_customize->add_control( new themesflat_Checkbox( $wp_customize,
        'courses_archive_excerpt',
        array(
            'type' => 'checkbox',
            'label' => esc_html__('Show Excerpt', 'bookflare'),
            'section' => 'courses_options',
            'priority' => 8,
        ))
    );
    $wp_customize->add_setting(
        'courses_tab_iso',
          array(
            'sanitize_callback' => 'themesflat_sanitize_checkbox',
            'default' => 'themesflat_sanitize_checkbox',     
        )   
    );
    $wp_customize->add_control( new themesflat_Checkbox( $wp_customize,
        'courses_tab_iso',
        array(
            'type' => 'checkbox',
            'label' => esc_html__('Show filter category of courses', 'bookflare'),
            'section' => 'courses_options',
            'priority' => 9,
        ))
    );
    $wp_customize->add_control( new themesflat_Info( $wp_customize, 'coursefooter', array(
        'label' => esc_html__('Footer courses', 'bookflare'),
        'section' => 'courses_options',
        'settings' => 'themesflat_options[info]',
        'priority' => 16
        ) )
    );
    $wp_customize->add_setting(
        'freemonth_courses_single',
          array(
            'sanitize_callback' => 'themesflat_sanitize_checkbox',
            'default' => themesflat_customize_default_opt('freemonth_courses_single'),  
        )   
    );
    $wp_customize->add_control( new themesflat_Checkbox( $wp_customize,
        'freemonth_courses_single',
        array(
            'type' => 'checkbox',
            'label' => esc_html__('Show Footer Single Courses', 'bookflare'),
            'section' => 'courses_options',
            'priority' => 17,
        ))
    );
    $wp_customize->add_setting(
        'content_ft_single',
        array(
            'default' => themesflat_customize_default_opt('content_ft_single'),
            'sanitize_callback' => 'themesflat_sanitize_text'
        )
    );
    $wp_customize->add_control(
        'content_ft_single',
        array(
            'label' => esc_html__( 'Content', 'bookflare' ),
            'section' => 'courses_options',
            'type' => 'textarea',
            'priority' => 18
        )
    );
    $wp_customize->add_setting(
        'background_footer_single_courses',
        array(
            'default'           =>themesflat_customize_default_opt('background_footer_single_courses'),
            'sanitize_callback' => 'esc_url_raw',
        )
    );
    $wp_customize->add_control(
        new WP_Customize_Image_Control(
            $wp_customize,
            'background_footer_single_courses',
            array(
               'label'          => esc_html__( 'Upload background', 'bookflare' ),
               'type'           => 'image',
               'section'        => 'courses_options',
               'priority'       => 19,
            )
        )
    );
    /*Shop*/

     $wp_customize->add_section(
        'shop_options',
        array(
            'title' => esc_html__('Shop', 'bookflare'),
            'priority' => 11,
        )
    );
     $wp_customize->add_section('shop_page',array(
        'title'         => esc_html__('Shop page','bookflare'),
        'priority'      => 1,
        'panel'         => 'shop_page',
    ));

    $wp_customize->add_control( new themesflat_Info( $wp_customize, 'shop_page', array(
        'label' => esc_html__('Shop page', 'bookflare'),
        'section' => 'shop_options',
        'settings' => 'themesflat_options[info]',
        'priority' => 1
        ) )
    ); 
    // Gird columns product
    $wp_customize->add_setting(
        'show_columns',
        array(
            'default'           => themesflat_customize_default_opt('show_columns'),
            'sanitize_callback' => 'esc_attr',
        )
    );
    $wp_customize->add_control(
        'show_columns',
        array(
            'type'      => 'select',           
            'section'   => 'shop_options',
            'priority'  => 17,
            'label'     => esc_html__('Show product Columns', 'bookflare'),
            'choices'   => array( 
                '6'     => esc_html__( '2 Columns', 'bookflare' ),
                '4'     => esc_html__( '3 Columns', 'bookflare' ),
                '3'     => esc_html__( '4 Columns', 'bookflare' ),                
            )
        )
    );
    $wp_customize->add_setting (
        'number_post_page_prduct',
        array(
            'default' => 9,
            'sanitize_callback' => 'themesflat_sanitize_text'
        )
    );
    $wp_customize->add_control(
        'number_post_page_prduct',
        array(
            'type'      => 'text',
            'label'     => esc_html__('Products Per Page', 'bookflare'),
            'section'   => 'shop_options',
            'priority'  => 18
        )
    );

    $wp_customize->add_setting(
        'show_quickview',
          array(
            'sanitize_callback' => 'themesflat_sanitize_checkbox',
            'default' => themesflat_customize_default_opt('show_quickview'),  
        )   
    );
    $wp_customize->add_control( new themesflat_Checkbox( $wp_customize,
        'show_quickview',
        array(
            'type' => 'checkbox',
            'label' => esc_html__('Show Quick View shop', 'bookflare'),
            'section' => 'shop_options',
            'priority' => 18,
        ))
    );
    $wp_customize->add_section('post_relate',array(
        'title'         => esc_html__('Post ralate','bookflare'),
        'priority'      => 1,
        'panel'         => 'post_relate',
    ));

    $wp_customize->add_control( new themesflat_Info( $wp_customize, 'post_relate', array(
        'label' => esc_html__('Post ralate', 'bookflare'),
        'section' => 'shop_options',
        'settings' => 'themesflat_options[info]',
        'priority' => 19
        ) )
    );
    $wp_customize->add_setting(
        'show_relate_shop',
          array(
            'sanitize_callback' => 'themesflat_sanitize_checkbox',
            'default' => themesflat_customize_default_opt('show_relate_shop'),  
        )   
    );
    $wp_customize->add_control( new themesflat_Checkbox( $wp_customize,
        'show_relate_shop',
        array(
            'type' => 'checkbox',
            'label' => esc_html__('Show related shop', 'bookflare'),
            'section' => 'shop_options',
            'priority' => 20,
        ))
    );
    $wp_customize->add_setting (
        'number_post_relate_prduct',
        array(
            'default'           => themesflat_customize_default_opt('number_post_relate_prduct'),
            'sanitize_callback' => 'esc_attr',
        )
    );
    $wp_customize->add_control(
        'number_post_relate_prduct',
        array(
            'type'      => 'text',
            'label'     => esc_html__('Products Per Page in relate', 'bookflare'),
            'section'   => 'shop_options',
            'priority'  => 21
        )
    );

    // Gird columns product
    $wp_customize->add_setting(
        'show_columns_relate',
        array(
            'default'           => themesflat_customize_default_opt('show_columns_relate'),
            'sanitize_callback' => 'esc_attr',
        )
    );
    $wp_customize->add_control(
        'show_columns_relate',
        array(
            'type'      => 'select',           
            'section'   => 'shop_options',
            'priority'  => 22,
            'label'     => esc_html__('Show Product Columns relate', 'bookflare'),
            'choices'   => array( 
                '6'     => esc_html__( '2 Columns', 'bookflare' ),
                '4'     => esc_html__( '3 Columns', 'bookflare' ),
                '3'     => esc_html__( '4 Columns', 'bookflare' ),                
            )
        )
    );
}
add_action( 'customize_register', 'themesflat_customize_register' );
// Text
function themesflat_sanitize_text( $input ) {
    return wp_kses_post(  $input  );
}
// Background size
function themesflat_sanitize_bg_size( $input ) {
    $valid = array(
        'cover'     => esc_html__('Cover', 'bookflare'),
        'contain'   => esc_html__('Contain', 'bookflare'),
    );
    if ( array_key_exists( $input, $valid ) ) {
        return $input;
    } else {
        return '';
    }
}
// Blog Layout
function themesflat_sanitize_blog( $input ) {
    $valid = array(
        'sidebar-right'    => esc_html__( 'Sidebar right', 'bookflare' ),
        'sidebar-left'    => esc_html__( 'Sidebar left', 'bookflare' ),
        'fullwidth'  => esc_html__( 'Full width (no sidebar)', 'bookflare' )
    );
    if ( array_key_exists( $input, $valid ) ) {
        return $input;
    } else {
        return '';
    }
}
// themesflat_sanitize_pagination
function themesflat_sanitize_pagination ( $input ) {
    $valid = array(
        'pager' => esc_html__('Pager', 'bookflare'),
        'numeric' => esc_html__('Numeric', 'bookflare'),
        'page_numeric' => esc_html__('Pager & Numeric', 'bookflare')                
    );
    if ( array_key_exists( $input, $valid ) ) {
        return $input;
    } else {
        return '';
    }
}
// themesflat_sanitize_pagination
function themesflat_sanitize_layout_version ( $input ) {
    $valid = array(
        'boxed' => esc_html__('Boxed', 'bookflare'),
        'wide' => esc_html__('Wide', 'bookflare')          
    );
    if ( array_key_exists( $input, $valid ) ) {
        return $input;
    } else {
        return '';
    }
}
// themesflat_sanitize_related_post
function themesflat_sanitize_related_post ( $input ) {
    $valid = array(
        'simple_list' => esc_html__('Simple List', 'bookflare'),
        'grid' => esc_html__('Grid', 'bookflare')        
    );
    if ( array_key_exists( $input, $valid ) ) {
        return $input;
    } else {
        return '';
    }
}
// Footer widget areas
function themesflat_sanitize_fw( $input ) {
    $valid = array(
        '0' => esc_html__('footer_default', 'bookflare'),
        '1' => esc_html__('One', 'bookflare'),
        '2' => esc_html__('Two', 'bookflare'),
        '3' => esc_html__('Three', 'bookflare'),
        '4' => esc_html__('Four', 'bookflare')
    );
    if ( array_key_exists( $input, $valid ) ) {
        return $input;
    } else {
        return '';
    }
}
// Header style sanitize
function themesflat_sanitize_headerstyle( $input ) {
    $valid = themesflat_predefined_header_styles();
    if ( array_key_exists( $input, $valid ) ) {
        return $input;
    } else {
        return '';
    }
}
// Checkboxes
function themesflat_sanitize_checkbox( $input ) {
    if ( $input == 1 ) {
        return 1;
    } else {
        return '';
    }
}
// Pictor_sanitize_grid_post_related
function themesflat_sanitize_grid_post_related( $input ) {
    $valid = array(        
        2     => esc_html__( '2 Columns', 'bookflare' ),
        3   => esc_html__( '3 Columns', 'bookflare' ),
        4    => esc_html__( '4 Columns', 'bookflare' ),        
    );
    if ( array_key_exists( $input, $valid ) ) {
        return $input;
    } else {
        return '';
    }
}

// Position_sanitize_page_title
function themesflat_sanitize_position_page_title( $input ) {
    $valid = array(        
        1     => esc_html__( 'Left', 'bookflare' ),
        2     => esc_html__( 'Right', 'bookflare' ),
        3   => esc_html__( 'Center', 'bookflare' ),
    );
    if ( array_key_exists( $input, $valid ) ) {
        return $input;
    } else {
        return '';
    }
}
// themesflat_sanitize_layout_product
function themesflat_sanitize_layout_product( $input ) {
    $valid = array(        
        'fullwidth'         => esc_html__( 'No Sidebar', 'bookflare' ),
        'sidebar-right'           => esc_html__( 'Sidebar Right', 'bookflare' ),
        'sidebar-left'         => esc_html__( 'Sidebar Left', 'bookflare' )
    );
    if ( array_key_exists( $input, $valid ) ) {
        return $input;
    } else {
        return '';
    }
}
