<?php
/**
 * Return the built-in header styles for this theme
 *
 * @return  array
 */
Class themesflat_options_helpers {
	public function recognize_control_class( $name ) {
        $segments = explode( '-', $name );
        $segments = array_map( 'ucfirst', $segments );
        return implode( '', $segments );
    }
}
function themesflat_predefined_header_styles() {
	static $styles;
	if ( empty( $styles ) ) {
		$styles = apply_filters( 'themesflat/header_styles', array(
			'header-v1' => esc_html__( 'Classic', 'bookflare' ),
			'header-v2' => esc_html__( 'Header style 02', 'bookflare' ),
			'header-v4' => esc_html__( 'Modern', 'bookflare' ),
		) );
	}
	return $styles;
}
/**
 * Render header style this theme
 *
 * @return  array
 */
function themesflat_render_header_styles() {
	$header_style = '';
	$header_style = (themesflat_meta('enable_custom_header_style') == 1)? themesflat_meta( 'header_style' ):themesflat_choose_opt('header_style');
	return $header_style;
}

function themesflat_get_class_for_custom($vc_class = '',$themesflat_class='') {
    if (!empty($vc_class)) {
        if (function_exists('vc_shortcode_custom_css_class')) {
            $vcclass = vc_shortcode_custom_css_class( $vc_class, '' );
        }
    }
    else {
        $vcclass = $themesflat_class; 
    }
    return $vcclass;
}
function themesflat_is_press(){
	if (class_exists( 'LearnPress' )){
		return is_learnpress();
	}
}

function themesflat_shortcode_default_id(){
    return array(
	    'type'       => 'textfield',
	    'param_name' => 'default_id',
	    'group' => esc_html__( 'Design Options', 'bookflare' ),
	    'value' => 'themesflat_'.current_time('timestamp'),
	    'std' => 'themesflat_'.current_time('timestamp')
    );
}
function themesflat_add_icons($icon_name='fa',$url='') {
    $icons = '';
    if ( $url != '' ) {
       $fontContent = wp_remote_get( $url, array('sslverify'   => false) );
       if (!is_wp_error($fontContent)){
           $pattern = sprintf('/\.([\A%s].*?)\:/',$icon_name);
           preg_match_all($pattern, $fontContent['body'],$tmp_icons);
           $icons = $tmp_icons[1];
       }
    }
    return $icons;
}
/**
 * Register Backend and Frontend CSS Styles
 */
add_action( 'vc_base_register_front_css', 'themesflat_vc_iconpicker_base_register_css' );
add_action( 'vc_base_register_admin_css', 'themesflat_vc_iconpicker_base_register_css' );
function themesflat_vc_iconpicker_base_register_css(){
    wp_register_style('vc_ionicons', THEMESFLAT_LINK. 'css/ionicons.min.css');
    wp_register_style('vc_ionicons', THEMESFLAT_LINK. 'css/bf-icon.css');
}

// ionicons
function themesflat_iconpicker_type_ionicons($icons) {
    $tmp_icon = themesflat_add_icons('icon',THEMESFLAT_LINK.'css/ionicons.min.css');
    foreach ($tmp_icon as $icon) {
        $iconname = str_replace('icon-', '', $icon);
        $iconname = ucwords(str_replace("-", " ", $iconname));
        $_icons[] = array($icon => $iconname);
    }
    return array_merge( $icons, $_icons );
}
add_filter( 'vc_iconpicker-type-ionicons', 'themesflat_iconpicker_type_ionicons' );

// Load icon type
function themesflat_map_icons($name='icon',$heading_name = 'Icon') {
	return array(
			array(
				'type' => 'dropdown',
				'heading' => esc_attr( $heading_name.' library'),
				'value' => array(
                    esc_html__( 'None', 'bookflare' ) => 'none',
					esc_html__( 'Font Awesome', 'bookflare' ) => 'fontawesome',
					esc_html__( 'Open Iconic', 'bookflare' ) => 'openiconic',
					esc_html__( 'Typicons', 'bookflare' ) => 'typicons',
					esc_html__( 'Entypo', 'bookflare' ) => 'entypo',
					esc_html__( 'Linecons', 'bookflare' ) => 'linecons',
					esc_html__( 'Mono Social', 'bookflare' ) => 'monosocial',
                    esc_html__( 'Material', 'bookflare' ) => 'material',
					esc_html__( 'Ionicons', 'bookflare' ) => 'ionicons',
				),
                'std' => 'none',
				'admin_label' => true,
				'param_name' => $name.'_type',
				'description' => esc_html__( 'Select icon library.', 'bookflare' ),
				'integrated_shortcode_field' => $name.'_'
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_attr( $heading_name ),
				'param_name' => $name.'_fontawesome',
				'value' => 'fa fa-adjust',
				// default value to backend editor admin_label
				'settings' => array(
					'emptyIcon' => false,
					// default true, display an "EMPTY" icon?
                    'type' => 'fontawesome',
					'iconsPerPage' => 4000,
					// default 100, how many icons per/page to display, we use (big number) to display all icons in single page
				),
				'dependency' => array(
					'element' => $name.'_type',
					'value' => 'fontawesome',
				),
				'description' => esc_html__( 'Select icon from library.', 'bookflare' ),
				'integrated_shortcode_field' => $name.'_'
			),
            array(
                'type' => 'iconpicker',
                'heading' => esc_attr( $heading_name),
                'param_name' => $name.'_simpleline',
                'value' => 'icon-user',
                // default value to backend editor admin_label
                'settings' => array(
                    'emptyIcon' => false,
                    // default true, display an "EMPTY" icon?
                    'type' => 'simpleline',
                    'iconsPerPage' => 4000,
                    // default 100, how many icons per/page to display, we use (big number) to display all icons in single page
                ),
                'dependency' => array(
                    'element' => $name.'_type',
                    'value' => 'simpleline',
                ),
                'description' => esc_html__( 'Select icon from library.', 'bookflare' ),
                'integrated_shortcode_field' => $name.'_'
            ),
			array(
                'type' => 'iconpicker',
                'heading' => esc_attr( $heading_name),
                'param_name' => $name.'_ionicons',
                'value' => 'icon-user',
                // default value to backend editor admin_label
                'settings' => array(
                    'emptyIcon' => false,
                    // default true, display an "EMPTY" icon?
                    'type' => 'ionicons',
                    'iconsPerPage' => 4000,
                    // default 100, how many icons per/page to display, we use (big number) to display all icons in single page
                ),
                'dependency' => array(
                    'element' => $name.'_type',
                    'value' => 'ionicons',
                ),
                'description' => esc_html__( 'Select icon from library.', 'bookflare' ),
                'integrated_shortcode_field' => $name.'_'
            ),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'bookflare' ),
				'param_name' => $name.'_openiconic',
				'value' => 'vc-oi vc-oi-dial',
				// default value to backend editor admin_label
				'settings' => array(
					'emptyIcon' => false,
					// default true, display an "EMPTY" icon?
					'type' => 'openiconic',
					'iconsPerPage' => 4000,
					// default 100, how many icons per/page to display
				),
				'dependency' => array(
					'element' => $name.'_type',
					'value' => 'openiconic',
				),
				'description' => esc_html__( 'Select icon from library.', 'bookflare' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'bookflare' ),
				'param_name' => $name.'_typicons',
				'value' => 'typcn typcn-adjust-brightness',
				// default value to backend editor admin_label
				'settings' => array(
					'emptyIcon' => false,
					// default true, display an "EMPTY" icon?
					'type' => 'typicons',
					'iconsPerPage' => 4000,
					// default 100, how many icons per/page to display
				),
				'dependency' => array(
					'element' => $name.'_type',
					'value' => 'typicons',
				),
				'description' => esc_html__( 'Select icon from library.', 'bookflare' ),
				'integrated_shortcode_field' => $name.'_'
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'bookflare' ),
				'param_name' => $name.'_entypo',
				'value' => 'entypo-icon entypo-icon-note',
				// default value to backend editor admin_label
				'settings' => array(
					'emptyIcon' => false,
					// default true, display an "EMPTY" icon?
					'type' => 'entypo',
					'iconsPerPage' => 4000,
					// default 100, how many icons per/page to display
				),
				'dependency' => array(
					'element' => $name.'_type',
					'value' => 'entypo',
				),
				'integrated_shortcode_field' => $name.'_'
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'bookflare' ),
				'param_name' => $name.'_linecons',
				'value' => 'vc_li vc_li-heart',
				// default value to backend editor admin_label
				'settings' => array(
					'emptyIcon' => false,
					// default true, display an "EMPTY" icon?
					'type' => 'linecons',
					'iconsPerPage' => 4000,
					// default 100, how many icons per/page to display
				),
				'dependency' => array(
					'element' => $name.'_type',
					'value' => 'linecons',
				),
				'description' => esc_html__( 'Select icon from library.', 'bookflare' ),
				'integrated_shortcode_field' => $name.'_'
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'bookflare' ),
				'param_name' => $name.'_monosocial',
				'value' => 'vc-mono vc-mono-fivehundredpx',
				// default value to backend editor admin_label
				'settings' => array(
					'emptyIcon' => false,
					// default true, display an "EMPTY" icon?
					'type' => 'monosocial',
					'iconsPerPage' => 4000,
					// default 100, how many icons per/page to display
				),
				'dependency' => array(
					'element' => $name.'_type',
					'value' => 'monosocial',
				),
				'description' => esc_html__( 'Select icon from library.', 'bookflare' ),
				'integrated_shortcode_field' => $name.'_'
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'bookflare' ),
				'param_name' => $name.'_material',
				'value' => 'vc-material vc-material-cake',
				// default value to backend editor admin_label
				'settings' => array(
					'emptyIcon' => false,
					// default true, display an "EMPTY" icon?
					'type' => 'material',
					'iconsPerPage' => 4000,
					// default 100, how many icons per/page to display
				),
				'dependency' => array(
					'element' => $name.'_type',
					'value' => 'material',
				),
				'description' => esc_html__( 'Select icon from library.', 'bookflare' ),
				'integrated_shortcode_field' => $name.'_'
			),

		);
}
/**
 * Menu fallback
 */
function themesflat_menu_fallback() {
		echo '<a class="create-menu" href="' . esc_url(admin_url('nav-menus.php')) . '">' . esc_html__( '+ Create a Menu', 'bookflare' ) . '</a>';
}
function themesflat_esc_attr($attr) {
	echo esc_attr($attr);
}
function themesflat_esc_html($attr) {
	echo esc_html($attr);
}
/**
 * Change the excerpt length
 */
function themesflat_excerpt_length( $length ) {  
  	$excerpt = themesflat_choose_opt('blog_archive_post_excepts_length');
  	return $excerpt;
}
add_filter( 'excerpt_length', 'themesflat_excerpt_length', 999 );
function themesflat_is_blog(){
	global  $post;
	$posttype = get_post_type($post );
	return ( ((is_archive()) || (is_author()) || (is_category()) || (is_home()) || (is_single()) || (is_tag())) && ( $posttype == 'post')  ) ? true : false ;
}

function themesflat_blog_layout() {
	$page_flat_default ='';
	if(themesflat_choose_opt('show_header_title_content') == 1){
		$page_flat_default = esc_attr(' page_flat_default');
	}
	switch (get_post_type()) {
        case 'page':
            $layout = themesflat_choose_opt('page_layout').$page_flat_default;
            break;
        case 'post':
            $layout = themesflat_choose_opt('blog_layout').esc_attr(' blog-page');
            break;  
        case 'product':
            $layout = themesflat_choose_opt('page_layout').esc_attr(' flat-product');
            break;
        case 'lp_courses':
            $layout = themesflat_choose_opt('page_layout');
            break; 
        case 'event':
            $layout = themesflat_choose_opt('page_layout').esc_attr(' page_cs');
            break;     
        case 'teacher':
            $layout = themesflat_choose_opt('page_layout').esc_attr(' page_cs');
            break;
        default:
            $layout = themesflat_choose_opt('blog_layout').esc_attr(' blog-page');
            break;
    }
    return $layout ;
}
function themesflat_courses_layout(){
	$courses_layout = themesflat_get_opt('courses_layout');
	return $courses_layout;
}
function themesflat_font_style($style) {
	if (strlen($style) > 4) {
	  	switch (substr($style, 0,3)) {
			case 'reg':
			    $a[0] = '400';
			    $a[1] = 'normal';
			break;
			case 'ita':
			    $a[0] = '400';
			    $a[1] = 'italic';			    
			break;
			default:
			    $a[0] = substr($style, 0,3);
			    $a[1] = substr($style, 4);
			break;
		}
	}
	else {
	  	$a[0] = $style;
	  	$a[1] = 'normal';
	}
	return $a;
}
/**
 * Get post meta, using rwmb_meta() function from Meta Box class
 */
function themesflat_meta( $key,$ID = '') {
    global $post;
    if ( $ID =='' && !is_null($post)) :
        return get_post_meta( $post->ID,$key, true );
    else:
        return get_post_meta($ID,$key,true);
    endif;
}
/**
 * Move_comment_field_to_bottom
 */
function themesflat_move_comment_field_to_bottom( $fields ) {
	$comment_field = $fields['comment'];
	unset( $fields['comment'] );
	$fields['comment'] = $comment_field;
	return $fields;
}
add_filter( 'comment_form_fields', 'themesflat_move_comment_field_to_bottom' );
if ( ! function_exists( 'themesflat_favicon' ) ) {    
    add_action( 'wp_head', 'themesflat_favicon' );
    /**
     * Display the custom favicon setup for the theme
     *   
     * @return  void
     */
    function themesflat_favicon() {
        if ( ! ( function_exists( 'has_site_icon' ) && has_site_icon() ) ) {
          printf ('<link rel="shortcut icon" href="'.esc_url( THEMESFLAT_LINK . 'icon/favicon.png').'" />');      
        }
    }
}
if ( version_compare( $GLOBALS['wp_version'], '4.1', '<' ) ) :
	/**
	 * Filters wp_title to print a neat <title> tag based on what is being viewed.
	 *
	 * @param string $title Default title text for current view.
	 * @param string $sep Optional separator.
	 * @return string The filtered title.
	 */
	function themesflat_wp_title( $title, $sep ) {
		if ( is_feed() ) {
			return $title;
		}
		global $page, $paged;
		// Add the blog name
		$title .= get_bloginfo( 'name', 'display' );
		// Add the blog description for the home/front page.
		$site_description = get_bloginfo( 'description', 'display' );
		if ( $site_description && ( is_home() || is_front_page() ) ) {
			$title .= " $sep $site_description";
		}
		// Add a page number if necessary:
		if ( ( $paged >= 2 || $page >= 2 ) && ! is_404() ) {
			$title .= " $sep " . sprintf( esc_html__( 'Page %s', 'bookflare' ), max( $paged, $page ) );
		}
		return $title;
	}
	add_filter( 'wp_title', 'themesflat_wp_title', 10, 2 );
	/**
	 * Title shim for sites older than WordPress 4.1.
	 *
	 * @link https://make.wordpress.org/core/2014/10/29/title-tags-in-4-1/
	 * @todo Remove this function when WordPress 4.3 is released.
	 */
	if ( ! function_exists( '_wp_render_title_tag' ) ) {
		function themesflat_render_title() {
			?>
			<title><?php wp_title( '|', true, 'right' ); ?></title>
			<?php
		}
		add_action( 'wp_head', 'themesflat_render_title' );
	}
	endif;
	function themesflat_get_json($key) {
		if ( get_theme_mod($key) == '' ) return themesflat_customize_default_opt($key);
		if (!is_array(get_theme_mod($key))) {
        $decoded_value = json_decode(str_replace('&quot;', '"',  get_theme_mod( $key )), true );
	    }
	    else {
	    	$decoded_value = get_theme_mod($key);
	    }
        return $decoded_value;
	}
	function themesflat_decode($value) {
		if (!is_array($value)) {
            $decoded_value = json_decode(str_replace('&quot;', '"',  $value) , true );
        }
        else {
            $decoded_value = $value;
        }
        return $decoded_value;
	}
	function themesflat_get_opt( $key ) {
		return get_theme_mod( $key, themesflat_customize_default_opt( $key ) );
	}
	function themesflat_dynamic_sidebar($sidebar) {
	    if ( is_active_sidebar ( $sidebar ) ) {
	        dynamic_sidebar( $sidebar );        
	    }
	}
	function themesflat_choose_opt ($key) {
		$flatopts = ( get_option('flatopts') );
		if ( isset( $flatopts[$key] ) && themesflat_meta( $flatopts[$key]) == 1 ) {
			return themesflat_meta( $key );			
		}
		else 
			return themesflat_get_opt( $key );
	}
	/*Show or off Page Title*/
	function themesflat_custom_pagetitle(){
		$active_page_title = (themesflat_meta('show_page_title') || is_page_template( 'tpl/page_fullwidth.php' )) ? themesflat_meta('show_page_title') :themesflat_choose_opt('show_page_title');
		if( $active_page_title ):
			get_template_part( 'tpl/page-title');
		endif;
	}
	function themesflat_load_page_menu($params) {
		if (themesflat_meta('menu_location_primary') != false ) {
			if ($params['theme_location'] == 'primary') {
				$params['menu'] = (int)themesflat_meta('menu_location_primary');
			}
		}
		return ($params);
	}
	add_filter( 'wp_nav_menu_args', 'themesflat_load_page_menu' );
/*Custom Excerpt*/
function themesflat_custom_excerpt($get_post_ID,$limit,$more = '...'){
	$content_except = '';
	if(get_the_excerpt($get_post_ID) != ''){
		$content_except = get_the_excerpt($get_post_ID);
	}else{
		$post_id = $get_post_ID;
		$queried_post = get_post($post_id);
		$content_except = $queried_post->post_content;
	}
	if($content_except !=''){
		$excerpt = explode(' ',$content_except, $limit);
	    if (count($excerpt) >= $limit) {
	        array_pop($excerpt);
	        $excerpt = implode(" ", $excerpt) . esc_attr( $more );
	    } else {
	        $excerpt = implode(" ", $excerpt);
	    }
	    $excerpt = preg_replace('`\[[^\]]*\]`', '', $excerpt);
	    return $excerpt;
    }
}
/*Show info blog*/
function themesflat_custom_info(){?>
	<div class="post-info">
		<?php
		$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
		if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
			$time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time>';
		}
		$time_string = sprintf( $time_string,
			esc_attr( get_the_date( 'c' ) ),
			get_the_date(),
			esc_attr( get_the_modified_date( 'c' ) ),
			get_the_modified_date()
		);
		?>
		<a href="<?php echo esc_url( get_permalink() );?>"><span class="get_times"><?php esc_html_e('Posted ','bookflare');?></span><?php echo wp_kses_post($time_string); ?></a>
		<span class="author-name"><?php esc_html_e('By ', 'bookflare'); the_author_posts_link(); ?></span>
	</div>
	<?php
}
/*Search Ajax*/
function themesflat_coacha_wc_live_search() {
	$result = array();
	$args = array(
		's'              => urldecode( $_REQUEST['q'] ),
		'post_type'      => 'lp_course',
		'posts_per_page' => 10
	);
	$query = new WP_Query( $args );
	if ( $query->have_posts() ) {
		while ( $query->have_posts() ) {
			$query->the_post();
			$thumb = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), array( 60,60 ) );
			if ( ! empty( $thumb ) ) {
				$thumb = $thumb[0];
			} else {
				$thumb = '';
			}
			$result[] = array(
				'id'     => get_the_ID(),
				'label'  => get_the_title(),
				'value'  => get_the_title(),
				'thumb'  => $thumb,
				'url'    => get_the_permalink(),
				'except' => substr( strip_tags( get_the_excerpt() ), 0, 60 ) . '...'
			);
		}
	}
	echo json_encode( $result );
	exit;
}
add_action( 'wp_ajax_themesflat_coacha_live_search', 'themesflat_coacha_wc_live_search' );
add_action( 'wp_ajax_nopriv_themesflat_coacha_live_search', 'themesflat_coacha_wc_live_search' );
if ( ! function_exists( 'cs_get_var' ) ) {
	function cs_get_var( $var, $default = '' ) {
		if( isset( $_POST[$var] ) ) {
		  return $_POST[$var];
		}
		if( isset( $_GET[$var] ) ) {
		  return $_GET[$var];
		}
		return $default;
	}
}
if ( ! function_exists( 'cs_get_vars' ) ) {
	function cs_get_vars( $var, $depth, $default = '' ) {
		if( isset( $_POST[$var][$depth] ) ) {
		  return $_POST[$var][$depth];
		}
		if( isset( $_GET[$var][$depth] ) ) {
		  return $_GET[$var][$depth];
		}
		return $default;
	}
}
if ( ! function_exists( 'cs_add_element' ) ) {
	function cs_add_element( $field = array(), $value = '', $unique = '' ) {
		$output     = '';
		$depend     = '';
		$sub        = ( isset( $field['sub'] ) ) ? 'sub-': '';
		$unique     = ( isset( $unique ) ) ? $unique : '';
		$languages  = cs_language_defaults();
		$class      = 'CSFramework_Option_' . $field['type'];
		$wrap_class = ( isset( $field['wrap_class'] ) ) ? ' ' . $field['wrap_class'] : '';
		$hidden     = ( isset( $field['show_only_language'] ) && ( $field['show_only_language'] != $languages['current'] ) ) ? ' hidden' : '';
		$is_pseudo  = ( isset( $field['pseudo'] ) ) ? ' cs-pseudo-field' : '';
		if ( isset( $field['dependency'] ) ) {
		  $hidden  = ' hidden';
		  $depend .= ' data-'. $sub .'controller="'. $field['dependency'][0] .'"';
		  $depend .= ' data-'. $sub .'condition="'. $field['dependency'][1] .'"';
		  $depend .= ' data-'. $sub .'value="'. $field['dependency'][2] .'"';
		}
		$output .= '<div class="cs-element cs-field-'. $field['type'] . $is_pseudo . $wrap_class . $hidden .'"'. $depend .'>';
		if( isset( $field['title'] ) ) {
		  $field_desc = ( isset( $field['desc'] ) ) ? '<p class="cs-text-desc">'. $field['desc'] .'</p>' : '';
		  $output .= '<div class="cs-title"><h4>' . $field['title'] . '</h4>'. $field_desc .'</div>';
		}
		$output .= ( isset( $field['title'] ) ) ? '<div class="cs-fieldset">' : '';

		$value   = ( !isset( $value ) && isset( $field['default'] ) ) ? $field['default'] : $value;
		$value   = ( isset( $field['value'] ) ) ? $field['value'] : $value;

		if( class_exists( $class ) ) {
		  ob_start();
		  $element = new $class( $field, $value, $unique );
		  $element->output();
		  $output .= ob_get_clean();
		} else {
		  $output .= '<p>'. esc_html__( 'This field class is not available!', 'bookflare' ) .'</p>';
		}
		$output .= ( isset( $field['title'] ) ) ? '</div>' : '';
		$output .= '<div class="clear"></div>';
		$output .= '</div>';
		return $output;
	}
}
if ( ! function_exists( 'cs_language_defaults' ) ) {
  function cs_language_defaults() {

    $multilang = array();

    if( cs_is_wpml_activated() || cs_is_qtranslate_activated()) {

      if( cs_is_wpml_activated() ) {

        global $sitepress;
        $multilang['default']   = $sitepress->get_default_language();
        $multilang['current']   = $sitepress->get_current_language();
        $multilang['languages'] = $sitepress->get_active_languages();

      } else if( cs_is_polylang_activated() ) {

        global $polylang;
        $current    = pll_current_language();
        $default    = pll_default_language();
        $current    = ( empty( $current ) ) ? $default : $current;
        $poly_langs = $polylang->model->get_languages_list();
        $languages  = array();

        foreach ( $poly_langs as $p_lang ) {
          $languages[$p_lang->slug] = $p_lang->slug;
        }

        $multilang['default']   = $default;
        $multilang['current']   = $current;
        $multilang['languages'] = $languages;

      } else if( cs_is_qtranslate_activated() ) {

        global $q_config;
        $multilang['default']   = $q_config['default_language'];
        $multilang['current']   = $q_config['language'];
        $multilang['languages'] = array_flip( qtrans_getSortedLanguages() );

      }

    }
    $multilang = apply_filters( 'cs_language_defaults', $multilang );
    return ( ! empty( $multilang ) ) ? $multilang : false;
  }
}
if ( ! function_exists( 'cs_is_wpml_activated' ) ) {
  function cs_is_wpml_activated() {
    if ( class_exists( 'SitePress' ) ) { return true; } else { return false; }
  }
}
if ( ! function_exists( 'cs_is_qtranslate_activated' ) ) {
  function cs_is_qtranslate_activated() {
    if ( function_exists( 'qtrans_getSortedLanguages' ) ) { return true; } else { return false; }
  }
}
/*Custom comment list*/
function themesflat_custom_comment($comment, $args, $depth) {
	$GLOBALS['comment'] = $comment;
	extract($args, EXTR_SKIP);
	if ( 'div' == $args['style'] ) {
		$tag = 'div';
		$add_below = 'comment';
	} else {
		$tag = 'li';
		$add_below = 'div-comment';
	}
	?>
	<<?php echo wp_kses_post($tag) ?> <?php comment_class( empty( $args['has_children'] ) ? '' : 'parent' ) ?> id="comment-<?php comment_ID() ?>">
		<?php if ( 'div' != $args['style'] ) : ?>
			<div id="div-comment-<?php comment_ID() ?>" class=" comment_div  bg-fff border-f-e6f3ff comment-body">
		<?php endif; ?>
			<div class="comment-avatar comment-img">
				<?php if ( $args['avatar_size'] != 0 ) echo get_avatar( $comment, $args['avatar_size'] ); ?>
			</div>
			<div class="comment-info comment-content">
				<div class="comment-header-info">
					<h6 class="name">
						<?php printf( esc_html( '%s'), get_comment_author() );
						 ?>
					</h6>
					<span class="datetime">
						<?php
						/* translators: 1: date, 2: time */
						printf( esc_html('%1$s %2$s'), get_comment_date('M, d, Y'),  get_comment_time('g:i A') ); ?> </span>
				</div>
				<?php if ( $comment->comment_approved == '0' ) : ?>
					<em class="comment-awaiting-moderation"><?php esc_html_e( 'Your comment is awaiting moderation.', 'bookflare' ); ?></em>
					<br />
				<?php endif; ?>
				<?php comment_text(); ?>
				<div class="wrap-btn">
					<?php comment_reply_link( array_merge( $args, array( 'add_below' => $add_below, 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
				</div>
			</div>
	<?php if ( 'div' != $args['style'] ) : ?>
		</div>
	<?php endif;
}
function count_courses_video(){
	global $course_id;
	$args = array(
		'post_type'              => 'lp_course',
		'posts_per_page'		 => '-1',

	);
	$count = 0;
	$sum_student = 0;
	$query = new WP_Query( $args );
	if ( $query->have_posts() ) {
		while ( $query->have_posts() ) {
		$query->the_post();
		$course = LP()->global['course'];
		$course_id = get_the_ID();
		$course_item = LP_Course::get_course( $course_id );
		$sum_student = $sum_student + intval(learn_press_count_students_enrolled($course_id));
		  		$count++;
			}
		} else {
	} 
	wp_reset_postdata();
	echo sprintf('<li><span class="color-f3728b font-Poppins font-weight-700">%1$s</span> %2$s</li>
		<li><span class="color-2ebd59 font-Poppins font-weight-700"> %3$s </span>%4$s</li>',esc_attr($count),esc_html('Courses','bookflare'),esc_attr($sum_student),esc_html('Student Enrolled','bookflare')
	);
}
function themesflat_teacher_by_id($_id,$id_postcs){
	if(post_type_exists('teacher')){

	$argss = array(
	  'p'         => $_id,
	  'post_type' => 'teacher'
	);
	$_query = new WP_Query($argss);
	$review_is_enable = themesflat_plugin_active( 'LP_Addon_Course_Review_Preload' );
	if($review_is_enable){
        $course_rate   = learn_press_get_course_rate( $id_postcs );
        $total         = learn_press_get_course_rate_total( $id_postcs );
    }
	if ( $_query->have_posts() ) {
		while ( $_query->have_posts() ) { $_query->the_post();?>
			<div class="author border-t-e6f3ff">
	            <div class="author-avata">
	                <?php the_post_thumbnail('themesflat-courser-single-courser-teacher', array('class'=>'responsive','alt' => esc_attr ( get_the_title() )) ); ?>
	            </div>
	            <div class="author-info">
	                <h6 class="name"><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></h6>
	                <div class="wrap-list">
	                    <ul class="list meta-list">
	                        <li>
	                            <span class="title"><?php esc_html_e('Categories:','bookflare');?></span>
	                            <?php themesflat_category_slug_single($id_postcs); ?>
	                        </li>
	                        <li>
	                            <span><?php themesflat_count_student($id_postcs); ?></span>
	                            <span class="title"><?php esc_html_e('Students Enrolled','bookflare');?></span>
	                        </li>
	                    </ul>
	                    <?php if($review_is_enable){ ?>
		                    <ul class="list meta-rate">
		                        <li>
		                            <?php themesflat_print_rating( $course_rate ); ?>
		                            <div class="number-rating"> <?php echo esc_attr(( $course_rate ) ? esc_html(round( $course_rate, 1 ) ) : 0); ?> <?php $total ? printf( _n( ' (%1$s)', ' (%1$s)', $total, 'bookflare' ), number_format_i18n( $total ) ) : esc_html( ' (0)' ); ?> </div>
		                        </li>
		                        <li>
		                            <span class="font-weight-700"><?php echo get_the_date('M d, Y');?></span>
		                        </li>
		                    </ul>
		                <?php } ?>
	                </div>
	            </div> 
	        </div>
			<?php 
		}
	}
	wp_reset_postdata();
	}
}
function themesflat_teacher_event($_id,$number_post_except_author){
	$argss = array(
	  'p'         => $_id,
	  'post_type' => 'teacher'
	);
	$_query = new WP_Query($argss);
	if ( $_query->have_posts() ) {
		while ( $_query->have_posts() ) { 
				$_query->the_post();?>
				<div class="author clearfix">
                    <div class="author-avata">
                        <?php the_post_thumbnail('themesflat-courser-single-courser-teacher', array('class'=>'responsive','alt' => esc_attr ( get_the_title() )) ); ?>
                    </div> 
                    <div class="author-info">
                        <h4 class="name"><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></h4>
                        <p class="text"><?php echo themesflat_custom_excerpt($_id,intval($number_post_except_author));?></p>
                    </div> 
                </div>
		<?php 
		}
	}
	wp_reset_postdata();
}

function themesflat_teacher_by_id_archive($_id){
	if(post_type_exists('teacher')){
		$argss = array(
		  'p'         => $_id,
		  'post_type' => 'teacher'
		);
		$_query = new WP_Query($argss);
		if ( $_query->have_posts() ) {
			while ( $_query->have_posts() ) 
				{ 
					$_query->the_post();?>
						<a href="<?php the_permalink() ?>"><?php the_title(); ?></a>
					<?php 
				}
		}
		wp_reset_postdata();
	}
}
function themesflat_category_Lp($number_cat_exclude = ''){
	if (is_tax('course_tag')) {
		$themesflat_tax_courses =  'course_tag';
	}else if(is_tax('course_category')) {
		$themesflat_tax_courses = 'course_category';
	}else{
		$themesflat_tax_courses = 'course_category';
	}
	$arg = array(
	    'taxonomy' => $themesflat_tax_courses,
	    'hide_empty' => false,
	    'parent'   => 0,
	    'exclude'	=> explode(",", $number_cat_exclude),
	);
	$terms = get_terms( $arg );
	if ( ! empty( $terms ) && ! is_wp_error( $terms ) ){
		echo '<li class="active"><a href="#" data-filter="*">'.esc_html__( 'ALL',  'bookflare').'</a></li>';
	    foreach ( $terms as $term ) {
	        echo sprintf('<li><a href="#" data-filter=".%2$s">%1$s</a></li>',
	        	esc_attr($term->name),
	        	esc_attr($term->slug)
	        );
	    }
	}
}
function themesflat_category_Lp_tab(){
	$arg = array(
	    'taxonomy' => 'course_category',
	    'hide_empty' => false,
	    'parent'   => 0,
	);
	$terms = get_terms( $arg );
	if ( ! empty( $terms ) && ! is_wp_error( $terms ) ){
	    foreach ( $terms as $term ) {
	        echo sprintf('<li class="item-title  "><span class="inner">%1$s</span></li>',
	        	esc_attr($term->name),
	        	esc_attr($term->slug)
	        );
	    }
	}
}
function themesflat_category_slug_teacher($post_ID){
	$terms = get_the_terms($post_ID ,'teacher_cat' );
	if ( ! empty( $terms ) && ! is_wp_error( $terms ) ){
	    foreach ( $terms as $term ) {
	        echo esc_attr($term->name).' ';
	    }
	}
}
function themesflat_category_slug($post_ID){
	$terms = get_the_terms($post_ID ,'course_category' );
	if ( ! empty( $terms ) && ! is_wp_error( $terms ) ){
	    foreach ( $terms as $term ) {
	        echo esc_attr($term->slug).' ';
	    }
	}
}
function themesflat_tag_slug($post_ID){
	$terms = get_the_terms($post_ID ,'course_tag' );
	if ( ! empty( $terms ) && ! is_wp_error( $terms ) ){
	    foreach ( $terms as $term ) {
	        echo esc_attr($term->slug).' ';
	    }
	}
}

function themesflat_category_slug_single($post_ID){
	$terms = get_the_terms($post_ID ,'course_category' );
	$count_slug = 0;
	if ( ! empty( $terms ) && ! is_wp_error( $terms ) ){
	    foreach ( $terms as $term ) {
	    	$link = get_term_link($term);
	    	$name = esc_html($term->name);
	    	if($count_slug == 0){
	    		echo '<a href="'.$link.'">'.$name.' </a>';
	    	}else{
	    		echo ', <a href="'.$link.'">'.$name.' </a>';
	    	}
	    	$count_slug ++;
	    }
	}
}

function themesflat_tag_single_course($post_ID){
	$terms = get_the_terms($post_ID ,'course_tag' );
	$count_tag = 0;
	if ( ! empty( $terms ) && ! is_wp_error( $terms ) ){
	    foreach ( $terms as $term ) {
	    	$count_tag++;
	    	$link = get_term_link($term);
	    	$name = esc_html($term->name);
	    	if($count_tag % 2 == 0){
	    		echo '<a href="'.$link.'"><span class="tag-item bg-7ffe53">'.$name.'</span></a>';
	    	}else{
	    		echo '<a href="'.$link.'"><span class="tag-item bg-fe5367">'.$name.'</span></a>';
	    	}
	    } }
}

//icons social
function themesflat_available_social_icons() {
    $icons = apply_filters( 'themesflat_available_icons', array(
        'twitter'        => array( 'iclass' => 'fa-twitter', 'title' => 'Twitter','share_link' => 'https://twitter.com/intent/tweet?url=' ),
        'facebook'       => array( 'iclass' => 'fa-facebook', 'title' => 'Facebook','share_link'=>'https://www.facebook.com/sharer.php?u=' ),
        'google-plus'    => array( 'iclass' => 'fa-google-plus', 'title' => 'Google Plus','share_link'=>'https://plus.google.com/share?url=' ),
        'pinterest'      => array( 'iclass' => 'fa-pinterest', 'title' => 'Pinterest','share_link' =>'https://pinterest.com/pin/create/bookmarklet/?url=' ),
        'instagram'      => array( 'iclass' => 'fa-instagram', 'title' => 'Instagram','share_link' => '' ),
        'youtube'        => array( 'iclass' => 'fa-youtube-play', 'title' => 'Youtube','share_link' =>'' ),
        'vimeo'          => array( 'iclass' => 'fa-vimeo-square', 'title' => 'Vimeo','share_link' =>'' ),
        'linkedin'       => array( 'iclass' => 'fa-linkedin', 'title' => 'LinkedIn','share_link' => 'https://www.linkedin.com/shareArticle?url=' ),
        'behance'        => array( 'iclass' => 'fa-behance', 'title' => 'Behance','share_link' =>'' ),
        'bitcoin'        => array( 'iclass' => 'fa-bitcoin', 'title' => 'Bitcoin','share_link' =>'' ),
        'bitbucket'      => array( 'iclass' => 'fa-bitbucket', 'title' => 'BitBucket','share_link' => '' ),
        'codepen'        => array( 'iclass' => 'fa-codepen', 'title' => 'Codepen','share_link' =>'' ),
        'delicious'      => array( 'iclass' => 'fa-delicious', 'title' => 'Delicious','share_link' =>'https://delicious.com/save?url='),
        'deviantart'     => array( 'iclass' => 'fa-deviantart', 'title' => 'DeviantArt','share_link' =>'' ),
        'digg'           => array( 'iclass' => 'fa-digg', 'title' => 'Digg','share_link' =>'http://digg.com/submit?url=' ),
        'dribbble'       => array( 'iclass' => 'fa-dribbble', 'title' => 'Dribbble','share_link' =>'' ),
        'flickr'         => array( 'iclass' => 'fa-flickr', 'title' => 'Flickr','share_link' => ''),
        'foursquare'     => array( 'iclass' => 'fa-foursquare', 'title' => 'Foursquare','share_link' => ''),
        'github'         => array( 'iclass' => 'fa-github-alt', 'title' => 'Github','share_link' => ''),
        'jsfiddle'       => array( 'iclass' => 'fa-jsfiddle', 'title' => 'JSFiddle','share_link' => ''),
        'reddit'         => array( 'iclass' => 'fa-reddit', 'title' => 'Reddit','share_link' => 'https://reddit.com/submit?url='),
        'skype'          => array( 'iclass' => 'fa-skype', 'title' => 'Skype','share_link' => 'https://web.skype.com/share?url='),
        'slack'          => array( 'iclass' => 'fa-slack', 'title' => 'Slack','share_link' => ''),
        'soundcloud'     => array( 'iclass' => 'fa-soundcloud', 'title' => 'SoundCloud','share_link' => ''),
        'spotify'        => array( 'iclass' => 'fa-spotify', 'title' => 'Spotify','share_link' => ''),
        'stack-exchange' => array( 'iclass' => 'fa-stack-exchange', 'title' => 'Stack Exchange','share_link' => ''),
        'stack-overflow' => array( 'iclass' => 'fa-stack-overflow', 'title' => 'Stach Overflow','share_link' => ''),
        'steam'          => array( 'iclass' => 'fa-steam', 'title' => 'Steam','share_link' => ''),
        'stumbleupon'    => array( 'iclass' => 'fa-stumbleupon', 'title' => 'Stumbleupon','share_link' => 'http://www.stumbleupon.com/submit?url='),
        'tumblr'         => array( 'iclass' => 'fa-tumblr', 'title' => 'Tumblr','share_link' => 'https://www.tumblr.com/widgets/share/tool?canonicalUrl='),
        'rss'            => array( 'iclass' => 'fa-rss', 'title' => 'RSS','share_link' => '' )
    ) );

    $icons['__ordering__'] = array_keys( $icons );

    return $icons;
}

function themesflat_render_social($prefix = '',$value='',$show_title=false) {
    if ($value == '') {
        $value = themesflat_get_json('social_links');
    }
    $class= array();
    $class[] = ($show_title == false ? 'themesflat-socials list' : 'themesflat-shortcode-socials');

    if ( ! is_array( $value ) ) {
            $decoded_value = json_decode(str_replace('&quot;', '"', $value), true );
            $value = is_array( $decoded_value ) ? $decoded_value : array();
        }

    $icons = themesflat_available_social_icons();
    
    ?>
    <ul class="<?php echo esc_attr(implode(" ", $class));?>">
        <?php
        foreach ( $value as $key => $val ) {
            if ($key != '__ordering__') {
                $title = ($show_title == false ? '' : $icons[$key]['title']);
                if($key == 'facebook' || $key == 'pinterest' || $key == 'linkedin'){
                	printf(
	                    '<li class="%s">
	                        <a href="%s" target="_blank" rel="alternate" title="%s">
	                            <i class="fa fa-%s-square"></i>                            
	                        </a>
	                    </li>',
	                    esc_attr( $key ),
	                    esc_url( $val ),
	                    esc_attr( $val ),
	                    esc_attr( $key ),
	                    esc_html($title)
	                );
                }else{
                	printf(
	                    '<li class="%s">
	                        <a href="%s" target="_blank" rel="alternate" title="%s">
	                            <i class="fa fa-%s"></i>                            
	                        </a>
	                    </li>',
	                    esc_attr( $key ),
	                    esc_url( $val ),
	                    esc_attr( $val ),
	                    esc_attr( $key ),
	                    esc_html($title)
	                );
                }
                
            }
    }
        ?>
    </ul><!-- /.social -->       
<?php 
}

function themesflat_render_social_share($link_post,$prefix = '',$value='',$show_title=false) {
    if ($value == '') {
        $value = themesflat_get_json('social_link_share_single');
    }
    $class= array();
    $class[] = ($show_title == false ? 'themesflat-socials list' : 'themesflat-shortcode-socials');

    if ( ! is_array( $value ) ) {
            $decoded_value = json_decode(str_replace('&quot;', '"', $value), true );
            $value = is_array( $decoded_value ) ? $decoded_value : array();
        }

    $icons = themesflat_available_social_icons();
    
    ?>
        <?php
        foreach ( $value as $key => $val ) {
            if ($key != '__ordering__') {
                $title = ($show_title == false ? '' : $icons[$key]['title']);
                printf(
                    '<li class="%1$s">
                        <a href="%2$s" target="_blank" rel="alternate" title="%1$s">
                            <i class="ion-social-%1$s"></i>                            
                        </a>
                    </li>',
                    esc_attr( $key),
                    esc_url( $val.$link_post ),
                    esc_attr( $val ),
                    esc_attr( $key ),
                    esc_html($title)
                );
            }
    }
}

function themesflat_render_box_control($name,$control=array(),$id) {
    add_action('admin_enqueue_scripts','themesflat_admin_color_picker');
    $default = array(
        'margin-top' => '',
        'margin-bottom' => '',
        'margin-left' => '',
        'margin-right' => '',
        'padding-top' => '',
        'padding-bottom' => '',
        'padding-left' => '',
        'padding-right' => '',
        'border-top-width' => '',
        'border-bottom-width' => '',
        'border-left-width' => '',
        'border-right-width' => '',
        );

    $controls = themesflat_decode($control);
    if (!is_array($controls)) {
        $controls = array();
    }
    $controls = array_merge($default,$controls);
    ?>
    <div class="themesflat_box_control">
        <div class="themesflat_box_position">
            <div class="themesflat_box_margin">
                <label class="themesflat_box_label"><?php echo esc_html('Margin');?></label>
                <input placeholder="-" data-position='margin-top' value ="<?php themesflat_esc_attr(($controls['margin-top']));?>" class="top" type="text"/>
                <input placeholder="-" data-position='margin-bottom' value ="<?php themesflat_esc_attr(($controls['margin-bottom']));?>" class="bottom" type="text"/>
                <input placeholder="-" data-position='margin-left' value ="<?php themesflat_esc_attr(($controls['margin-left']));?>" class="left" type="text"/>
                <input placeholder="-" data-position='margin-right' value ="<?php themesflat_esc_attr(($controls['margin-right']));?>" class="right" type="text"/>
            </div>

            <div class="themesflat_box_padding">
                <label class="themesflat_box_label"><?php echo esc_html('Padding');?></label>
                <input placeholder="-" data-position='padding-top' value ="<?php themesflat_esc_attr(($controls['padding-top']));?>" class="top" type="text"/>
                <input placeholder="-" data-position='padding-bottom' value ="<?php themesflat_esc_attr(($controls['padding-bottom']));?>" class="bottom" type="text"/>
                <input placeholder="-" data-position='padding-left' value ="<?php themesflat_esc_attr(($controls['padding-left']));?>" class="left" type="text"/>
                <input placeholder="-" data-position='padding-right' value ="<?php themesflat_esc_attr(($controls['padding-right']));?>" class="right" type="text"/>
            </div>

            <div class="themesflat_box_border">
                <label class="themesflat_box_label"><?php echo esc_html('Border');?></label>
                <input placeholder="-" data-position='border-top-width' value ="<?php themesflat_esc_attr(($controls['border-top-width']));?>" class="top" type="text"/>
                <input placeholder="-" data-position='border-bottom-width' value ="<?php themesflat_esc_attr(($controls['border-bottom-width']));?>" class="bottom" type="text"/>
                <input placeholder="-" data-position='border-left-width' value ="<?php themesflat_esc_attr(($controls['border-left-width']));?>" class="left" type="text"/>
                <input placeholder="-" data-position='border-right-width' value ="<?php themesflat_esc_attr(($controls['border-right-width']));?>" class="right" type="text"/>
            </div>
            <div class="themesflat_control_logo"></div>
        </div>
    </div>
    <input name="<?php echo esc_attr($name);?>" data-customize-setting-link="<?php echo  esc_attr($id);?>" value="<?php echo esc_attr(json_encode($controls));?>" type="hidden"/>
    <?php 
}

function themesflat_render_box_position($class,$box_control,$custom_string='') {
    $css = esc_attr($class) .'{';
    if (is_array($box_control)) {
        foreach ($box_control as $key => $value) {
            if ( $value !='') {
                $css .= esc_attr($key) .':'.esc_attr(str_replace("px","",$value)).'px; ';
            }
        }
    }
    $css .= esc_attr($custom_string);
    $css .= '}';

    wp_add_inline_style( 'themesflat-style', $css );
}


function themesflat_render_post($blog_layout,$readmore = '[...]',$length='') {
    if ($length != '') {
        global $themesflat_length;
        $themesflat_length = $length;
        add_filter('excerpt_length','themesflat_special_excerpt',1000);
    }
    $_button_type = '';
    $blog_layout = 'blog-grid';
    $button_type = array(
        'blog-grid' => 'no-background',
        'blog-list' => '',
        'blog-list-full-width' => '',
        'blog-masonry' => '',
        'blog-list-small' => 'no-background',
        'blog-grid-image-left' => ''
        );
    $_button_type = $button_type[$blog_layout];
    if( strpos( get_the_content(), 'more-link' ) === false ) {
    	add_filter( 'excerpt_more', 'themesflat_excerpt_more' );
	    $content_except = get_the_excerpt();
	    $excerpt = explode(' ',$content_except, $themesflat_length);
	    if (count($excerpt) >= $length) {
	        array_pop($excerpt);
	        $excerpt = implode(" ", $excerpt) . esc_attr( $readmore );
	    } else {
	        $excerpt = implode(" ", $excerpt);
	    }
	    $excerpt = preg_replace('`\[[^\]]*\]`', '', $excerpt);
	    echo  esc_html($excerpt);
        if ($readmore != '[...]') {
            echo '<div class="wrap-btn">
                    <a href="'.get_the_permalink().'" rel="nofollow" class="flat-button btn-read-more border-ra4">'.$readmore.'</a>
                </div>';
        }
    }
    else {
        if ($readmore != '[...]') {
            the_content(' ...');
            echo '<div class="wrap-btn">
                    <a href="'.get_the_permalink().'" rel="nofollow" class="flat-button btn-read-more border-ra4">'.$readmore.'</a>
                </div>';
        }
        else {
            the_content($readmore);

        }
    }
}

function themesflat_excerpt_more( $more ) {
    return ' ...';
}

function themesflat_special_excerpt($length) {
    global $themesflat_length;
    return $themesflat_length;
}

/**
 * ************************** Login *******************************************
 */
if ( ! function_exists( 'flat_login_failed' ) ) {
	function flat_login_failed() {
		if ( ( isset( $_REQUEST['action'] ) && $_REQUEST['action'] == 'flat_login_ajax' ) || ( isset( $_REQUEST['lp-ajax'] ) && $_REQUEST['lp-ajax'] == 'login' ) || ( is_admin() && defined( 'DOING_AJAX' ) && DOING_AJAX ) ) {
			return;
		}

		if( isset($_REQUEST['level']) && isset($_REQUEST['submit-checkout']) && isset($_REQUEST['username']) && isset($_REQUEST['password']) ) {
			return;
		}

		if ( is_user_logged_in() ) {
			return;
		}

		$url = add_query_arg( 'result', 'failed', flat_get_login_page_url() );

		if ( isset( $_POST['g-recaptcha-response'] ) ) {
			if ( ! $_POST['g-recaptcha-response'] ) {
				$url = add_query_arg( 'gglcptch_error', '1', $url );
			}
		}

		wp_redirect( $url );
		exit;
	}

	add_action( 'wp_login_failed', 'flat_login_failed', 1000 );
}

/**
 * Check new version of LearnPress
 */
function flat_is_new_learnpress( $version ) {
	if ( defined( 'LEARNPRESS_VERSION' ) ) {
		return version_compare( LEARNPRESS_VERSION, $version, '>=' );
	} else {
		return version_compare( get_option( 'learnpress_version' ), $version, '>=' );
	}
}

/**
 * Register failed
 *
 * @param $sanitized_user_login
 * @param $user_email
 * @param $errors
 */
if ( ! function_exists( 'flat_register_failed' ) ) {
	function flat_register_failed( $errors ) {
		// Prevent redirect in popup
		if ( ! empty( $_POST['is_popup_register'] ) ) {
			return $errors;
		}

		if ( $errors->get_error_code() ) {

			//setup your custom URL for redirection
			$url = add_query_arg( 'action', 'register', flat_get_login_page_url() );

			foreach ( $errors->errors as $e => $m ) {
				$url = add_query_arg( $e, '1', $url );
			}
			wp_redirect( $url );
			exit;
		}

		return $errors;
	}

	add_action( 'registration_errors', 'flat_register_failed', 99, 3 );
}

/**
 * Filter lost password link

 */
if ( ! function_exists( 'flat_get_lost_password_url' ) ) {
	function flat_get_lost_password_url() {
		$url = add_query_arg( 'action', 'lostpassword', flat_get_login_page_url() );

		return $url;
	}
}
/**
 * Add lost password link into login form
 *
 * @param $content
 * @param $args
 *
 * @return string
 */
if ( ! function_exists( 'flat_add_lost_password_link' ) ) {
	function flat_add_lost_password_link( $content ) {
		$content .= '<a class="lost-pass-link" href="' . flat_get_lost_password_url() . '" title="' . esc_attr__( 'Lost Password', 'bookflare' ) . '">' . esc_html__( 'Lost your password?', 'bookflare' ) . '</a>';

		return $content;
	}
}
add_filter( 'login_form_middle', 'flat_add_lost_password_link', 999 );


/**
 * Register failed
 */
if ( ! function_exists( 'flat_reset_password_failed' ) ) {
	function flat_reset_password_failed() {
		//setup your custom URL for redirection
		$url = add_query_arg( 'action', 'lostpassword', flat_get_login_page_url() );

		if ( empty( $_POST['user_login'] ) ) {
			$url = add_query_arg( 'empty', '1', $url );
			wp_redirect( $url );
			exit;
		} elseif ( strpos( $_POST['user_login'], '@' ) ) {
			$user_data = get_user_by( 'email', trim( $_POST['user_login'] ) );
			if ( empty( $user_data ) ) {
				$url = add_query_arg( 'user_not_exist', '1', $url );
				wp_redirect( $url );
				exit;
			}
		} elseif ( ! username_exists( $_POST['user_login'] ) ) {
			$url = add_query_arg( 'user_not_exist', '1', $url );
			wp_redirect( $url );
			exit;
		}
	}
}
add_action( 'lostpassword_post', 'flat_reset_password_failed', 999 );

/**
 * Get login page url
 */
if ( ! function_exists( 'flat_get_login_page_url' ) ) {
	function flat_get_login_page_url() {
		if(!function_exists( 'visual_composer' ) ) {
			return wp_login_url();
		}
		if ( $page = get_option( 'flat_login_page' ) ) {
			return get_permalink( $page );
		} else {
			global $wpdb;
			$page = $wpdb->get_col(
				$wpdb->prepare(
					"SELECT p.ID FROM $wpdb->posts AS p INNER JOIN $wpdb->postmeta AS pm ON p.ID = pm.post_id
			WHERE 	pm.meta_key = %s
			AND 	pm.meta_value = %s
			AND		p.post_type = %s
			AND		p.post_status = %s",
					'flat_login_page',
					'1',
					'page',
					'publish'
				)
			);
			if ( ! empty( $page[0] ) ) {
				return get_permalink( $page[0] );
			}
		}
		return wp_login_url();
	}
}
/**
 * Filter register link
 */
if ( ! function_exists( 'flat_get_register_url' ) ) {
	function flat_get_register_url() {
		$url = add_query_arg( 'action', 'register', flat_get_login_page_url() );

		return $url;
	}
}
if ( ! is_multisite() ) {
	add_filter( 'register_url', 'flat_get_register_url' );
}
function wpdocs_personal_message_when_logged_in() {
global $wp;
	?>

<ul class="account-popup">
	<?php
	$registration_enabled = get_option( 'users_can_register' );
	$profile_text  = esc_html__('PROFILE','bookflare');
	$logout_text   = esc_html__('LOGOUT','bookflare');
	$login_text    = esc_html__('LOGIN','bookflare');
	$register_text = esc_html__('REGISTER','bookflare');
	// Login/Register popup
	if ( is_user_logged_in() ) {
		if ( class_exists( 'LearnPress' ) && $profile_text ) {
			if ( flat_is_new_learnpress( '3.0' ) ) {
				echo '<li class="profile"><a href="' . esc_url( learn_press_user_profile_link() ) . '">' . esc_attr($profile_text) . '</a></li>';
			} else {
				echo '<li class="profile"><a href="' . esc_url( apply_filters( 'learn_press_instructor_profile_link', '#', get_current_user_id(), '' ) ) . '">' . $profile_text . '</a></li>';
			}
		}
		if ( $login_text ) {
			?>
			<li class="logout"><a href="<?php echo esc_url( wp_logout_url( home_url( $wp->request ) ) ); ?>"><?php echo esc_attr($logout_text); ?></a></li>
			<?php
		}
	} else {
		if ( $registration_enabled) {
			if ( $register_text ) {
				echo '<li class="register show-popup"><a href="' . esc_url( flat_get_register_url() ) . '">' . esc_attr($register_text) . '</a></li>';
			}
		}
		if ( $login_text ) {
			echo '<li class="user login show-popup"><a href="' . esc_url( flat_get_login_page_url() ) . '">' . esc_attr($login_text) . '</a></li>';
		}
	}
	// End Login/Register popup
	?>
</ul>
<?php
}
function flat_display_login_popup() {
	global $wp;

	if ( ! is_user_logged_in() ) {
		$registration_enabled = get_option( 'users_can_register' );
		?>
		<div id="flat-popup-login">
			<div class="popup-login-wrapper">
				<div class="flat-login-container">
					<?php
					$current_page_id = get_queried_object_id();
					?>
					<div class="flat-popup-inner">
						<div class="flat-login">
							<?php
							$flat_login_redirect = home_url( $wp->request );

							// Set redirect url
							if ( is_singular( 'lp_course' ) && 'yes' == get_post_meta( $current_page_id, '_lp_required_enroll', true ) ) {
								$flat_login_redirect = add_query_arg( array( 'enroll-course' => $current_page_id ), $flat_login_redirect );
							}

							if ( ! empty( $_REQUEST['redirect_to'] ) ) {
								$flat_login_redirect = $_REQUEST['redirect_to'];
							}
							?>

							<h4 class="title"><?php esc_html_e( 'Login', 'bookflare' ); ?></h4>
							<form name="loginflatform" action="<?php echo esc_url( site_url( 'wp-login.php', 'login_post' ) ); ?>" method="post">

								<?php do_action( 'flat_before_login_form' ); ?>

								<p class="login-username">
									<input type="text" id="log-pu" name="log" placeholder="<?php esc_attr_e( 'Username or email', 'bookflare' ); ?>" class="input required" required value="" size="20" />
								</p>
								<p class="login-password">
									<input type="password" id="pwd-pu" name="pwd" placeholder="<?php esc_attr_e( 'Password', 'bookflare' ); ?>" autocomplete="off" class="input required" required value="" size="20" />
								</p>

								<?php
								do_action( 'login_form' );
								?>
								<?php echo '<a class="lost-pass-link" href="' . flat_get_lost_password_url() . '" title="' . esc_attr__( 'Lost Password', 'bookflare' ) . '">' . esc_html__( 'Lost your password?', 'bookflare' ) . '</a>'; ?>
								<p class="forgetmenot login-remember">
									<label for="accountRememberme"><input name="rememberme" type="checkbox" value="forever" id="accountRememberme" /> <?php esc_html_e( 'Remember Me', 'bookflare' ); ?>
									</label></p>
								<p class="submit login-submit">
									<button type="submit" name="wp-submit" id="submit-login-pu"  class="flat-button btn-send border-ra4"><?php esc_html_e( 'Login', 'bookflare' ); ?></button>
									<input type="hidden" name="redirect_to" value="<?php echo esc_url( $flat_login_redirect ); ?>" />
									<input type="hidden" name="cookie" value="1" />
								</p>
								<?php do_action( 'flat_after_login_form' ); ?>
							</form>
							<?php

							if ( $registration_enabled ) {
								echo '<p class="link-bottom">' . esc_html__( 'New member ', 'bookflare' ) . ' <a class="register" href="' . esc_url( flat_get_register_url() ) . '">' . esc_html__( 'Register now', 'bookflare' ) . '</a></p>';
							}
							?>
						</div>
						<?php 
						if ( $registration_enabled ){ 
							?>
							<div class="flat-register">
								<?php
								$flat_register_redirect = home_url( $wp->request );
								// Set redirect url 
								if ( is_singular( 'lp_course' ) && 'yes' == get_post_meta( $current_page_id, '_lp_required_enroll', true ) ) {
									$flat_register_redirect = add_query_arg( array( 'enroll-course' => $current_page_id ), $flat_register_redirect );
								}
								if ( ! empty( $_REQUEST['redirect_to'] ) ) {
									$flat_register_redirect = $_REQUEST['redirect_to'];
								}
								?>
								<h4 class="title"><?php esc_html_e( 'Register', 'bookflare' ); ?></h4>
								<form class="thflat-register" name="registerflatform" action="<?php echo esc_url( site_url( 'wp-login.php?action=register', 'login_post' ) ); ?>" method="post" novalidate="novalidate">
									<?php wp_nonce_field( 'ajax_register_nonce', 'register_security' ); ?>
									<p>
										<input placeholder="<?php esc_attr_e( 'Username', 'bookflare' ); ?>" type="text" name="user_login" class="input required" required />
									</p>
									<p>
										<input placeholder="<?php esc_attr_e( 'Email', 'bookflare' ); ?>" type="email" name="user_email" class="input required" required/>
									</p>
									<p>
										<input placeholder="<?php esc_attr_e( 'Password', 'bookflare' ); ?>" type="password" autocomplete="off" name="password" class="input required" required />
									</p>
									<p>
										<input placeholder="<?php esc_attr_e( 'Repeat Password', 'bookflare' ); ?>" type="password" autocomplete="off" name="repeat_password" class="input required" required/>
									</p>
									<?php
									if ( is_multisite() && function_exists( 'gglcptch_login_display' ) ) {
										gglcptch_login_display();
									}

									do_action( 'register_form' );
									?>
									<p>
										<input type="hidden" name="redirect_to" value="<?php echo esc_url( $flat_register_redirect ); ?>" />
										<input type="hidden" name="modify_user_notification" value="1">
									</p>
									<p class="submit">
										<button type="submit" name="wp-submit" id="submit-register-pu"  class="flat-button btn-send border-ra4"><?php esc_html_e( 'Register', 'bookflare' ); ?></button>
									</p>
								</form>
								<?php echo '<p class="link-bottom">' . esc_html__( 'Are you a member? ', 'bookflare' ) . ' <a class="login" href="' . esc_url( flat_get_register_url() ) . '">' . esc_html__( 'Login now', 'bookflare' ) . '</a></p>'; ?>

								<div class="popup-message"></div>
							</div>
						<?php 
						}
					 ?>
						
					</div>

					<span class="close-popup"><i class="fa fa-times" aria-hidden="true"></i></span>
					<div class="cssload-container">
						<div class="cssload-loading"><div class="loader-pre"></div></div>
					</div>
				</div>
			</div>
		</div>
		<?php
	}
}
add_filter( 'login_redirect', 'flat_login_redirect', 1000 );
if ( ! function_exists( 'flat_login_redirect' ) ) {
	function flat_login_redirect() {
		if ( empty( $_REQUEST['redirect_to'] ) ) {
			$redirect_url = get_theme_mod( 'flat_login_redirect' );
			if ( ! empty( $redirect_url ) ) {
				return $redirect_url;
			} else {
				return home_url();
			}
		} else {
			return $_REQUEST['redirect_to'];
		}
	}
}
/**
 * Get current url
 */
if ( ! function_exists( 'flat_get_current_url' ) ) {
	function flat_get_current_url() {
		static $current_url;
		if ( ! $current_url ) {
			if ( ! empty( $_REQUEST['login'] ) ) {
				$url = add_query_arg( array( 'login' => rawurlencode( $_REQUEST['login'] ) ) );
			} else {
				$url = add_query_arg();
			}

			if ( is_multisite() ) {
				if ( ! preg_match( '!^https?!', $url ) ) {
					$segs1 = explode( '/', get_site_url() );
					$segs2 = explode( '/', $url );
					if ( $removed = array_intersect( $segs1, $segs2 ) ) {
						$segs2 = array_diff( $segs2, $removed );
						$url   = get_site_url() . '/' . join( '/', $segs2 );
					}
				}
			} else {
				if ( ! preg_match( '!^https?!', $url ) ) {
					$segs1 = explode( '/', home_url( '/' ) );
					$segs2 = explode( '/', $url );
					if ( $removed = array_intersect( $segs1, $segs2 ) ) {
						$segs2 = array_diff( $segs2, $removed );
						$url   = home_url( '/' ) . join( '/', $segs2 );
					}
				}
			}

			$current_url = $url;

		}

		return $current_url;
	}
}
/**
 * Check is current url
 */
if ( ! function_exists( 'flat_is_current_url' ) ) {
	function flat_is_current_url( $url ) {
		return strcmp( flat_get_current_url(), $url ) == 0;
	}
}

/**
 * Redirect reset password
 */
if ( ! function_exists( 'flat_redirect_rp_url' ) ) {
	function flat_redirect_rp_url() {
		if (
			! empty( $_REQUEST['action'] ) && $_REQUEST['action'] == 'rp'
			&& ! empty( $_REQUEST['key'] ) && ! empty( $_REQUEST['login'] )
		) {
			$reset_link = add_query_arg(
				array(
					'action' => 'rp',
					'key'    => $_REQUEST['key'],
					'login'  => rawurlencode( $_REQUEST['login'] )
				), flat_get_login_page_url()
			);

			if ( ! flat_is_current_url( $reset_link ) ) {
				wp_redirect( $reset_link );
				exit();
			}
		}
	}
}
/**
 * Process ajax login-popup
 */
add_action( 'wp_ajax_nopriv_flat_login_ajax', 'flat_login_ajax_callback' );
add_action( 'wp_ajax_flat_login_ajax', 'flat_login_ajax_callback' );
if ( ! function_exists( 'flat_login_ajax_callback' ) ) {
	function flat_login_ajax_callback() {
		if ( empty( $_REQUEST['data'] ) ) {
			$response_data = array(
				'code'    => - 1,
				'message' => '<p class="message message-error"><i class="fa fa-times-circle"> </i> ' . esc_html__( 'Error!. Please try again.', 'bookflare' ) . '</p>'
			);
		} else {

			parse_str( $_REQUEST['data'], $login_data );

			foreach ( $login_data as $k => $v ) {
				$_POST[ $k ] = $v;
			}

			$user_verify = wp_signon( array(), is_ssl() );

			$code    = 1;
			$message = '';

			if ( is_wp_error( $user_verify ) ) {
				if ( ! empty( $user_verify->errors ) ) {
					$errors = $user_verify->errors;

					if  ( ! empty( $errors['invalid_username'] ) || ! empty( $errors['incorrect_password'] ) ) {
						$message = '<p class="message message-error"><i class="fa fa-times-circle"> </i> ' . esc_html__( 'Incorrect username or password. Please try again!', 'bookflare' ) . '</p>';
					} else if ( ! empty( $errors['cptch_error'] ) && is_array( $errors['cptch_error'] ) ) {
						foreach ( $errors['cptch_error'] as $key => $value ) {
							$message .= '<p class="message message-error"><i class="fa fa-times-circle"> </i> ' . $value . '</p>';
						}
					} else {
						$message = '<p class="message message-error"><i class="fa fa-times-circle"> </i> ' . esc_html__( 'Error! Please try again.', 'bookflare' ) . '</p>';
					}
				} else {
					$message = '<p class="message message-error"><i class="fa fa-times-circle"> </i> ' . esc_html__( 'Error! Please try again.', 'bookflare' ) . '</p>';
				}
				$code = - 1;
			} else {
				$message = '<p class="message message-success"><i class="fa fa-check"> </i> ' . esc_html__( 'Login successful ...', 'bookflare' ) . '</p>';
			}

			$response_data = array(
				'code'    => $code,
				'message' => $message
			);

			if ( ! empty( $login_data['redirect_to'] ) ) {
				$response_data['redirect'] = $login_data['redirect_to'];
			}
		}
		echo json_encode( $response_data );
		die(); // this is required to return a proper result
	}
}
/*
 * Process ajax register
 * */
if ( ! function_exists( 'flat_register_ajax_callback' ) ) {
	function flat_register_ajax_callback() {
		if(!get_option( 'users_can_register' )){
			$response_data = array(
				'message' => '<p class="message message-error"><i class="fa fa-times-circle"> </i> ' . esc_html__( 'Error! Please try again.', 'bookflare' ) . '</p>'
			);

			wp_send_json_error( $response_data );
		}
		$secure = check_ajax_referer( 'ajax_register_nonce', 'register_security', false );
		if ( ! $secure ) {
			$response_data = array(
				'message' => '<p class="message message-error"><i class="fa fa-times-circle"> </i> ' . esc_html__( 'Error! Please try again.', 'bookflare' ) . '</p>'
			);

			wp_send_json_error( $response_data );
		}

		parse_str( $_POST['data'], $data );

		foreach ( $data as $key => $value ) {
			$_POST[ $key ] = $value;
		}

		$_POST['is_popup_register'] = 1;

		if ( ! empty( $data['modify_user_notification'] ) ) {
			$_REQUEST['modify_user_notification'] = 1;
		}

		$info = array();

		$info['user_login'] = sanitize_user( $data['user_login'] );
		$info['user_email'] = sanitize_email( $data['user_email'] );
		$info['user_pass']  = sanitize_text_field( $data['password'] );

		$confirm_password = sanitize_text_field( $data['repeat_password'] );

		if ( $info['user_pass'] !== $confirm_password ) {
			$response_data = array(
				'message' => '<p class="message message-error"><i class="fa fa-times-circle"> </i> ' . esc_html__( 'Those passwords didn\'t match. Try again.', 'bookflare' ) . '</p>'
			);

			wp_send_json_error( $response_data );
		}
		// Register the user
		$user_register = register_new_user( $info['user_login'], $info['user_email'] );

		if ( is_wp_error( $user_register ) ) {
			$error = $user_register->get_error_codes();

			if  ( in_array( 'empty_username', $error ) ) {
				$response_data = array(
					'message' => '<p class="message message-error"><i class="fa fa-times-circle"> </i> ' . esc_html__( 'Please enter a username!', 'bookflare' ) . '</p>'
				);
			} elseif ( in_array( 'invalid_username', $error ) ) {
				$response_data = array(
					'message' => '<p class="message message-error"><i class="fa fa-times-circle"> </i> ' . esc_html__( 'The username is invalid. Please try again!', 'bookflare' ) . '</p>'
				);
			} elseif ( in_array( 'username_exists', $error ) ) {
				$response_data = array(
					'message' => '<p class="message message-error"><i class="fa fa-times-circle"> </i> ' . esc_html__( 'This username is already registered. Please choose another one!', 'bookflare' ) . '</p>'
				);
			} elseif ( in_array( 'empty_email', $error ) ) {
				$response_data = array(
					'message' => '<p class="message message-error"><i class="fa fa-times-circle"> </i> ' . esc_html__( 'Please type your e-mail address!', 'bookflare' ) . '</p>'
				);
			} elseif ( in_array( 'invalid_email', $error ) ) {
				$response_data = array(
					'message' => '<p class="message message-error"><i class="fa fa-times-circle"> </i> ' . esc_html__( 'The email address isn\'t correct. Please try again!', 'bookflare' ) . '</p>'
				);
			} elseif ( in_array( 'email_exists', $error ) ) {
				$response_data = array(
					'message' => '<p class="message message-error"><i class="fa fa-times-circle"> </i> ' . esc_html__( 'This email is already registered. Please choose another one!', 'bookflare' ) . '</p>'
				);
			}

			wp_send_json_error( $response_data );
		} else {
				wp_set_current_user( $user_register );
				wp_set_auth_cookie( $user_register );
				$response_data = array(
					'message' => '<p class="message message-success"><i class="fa fa-check"> </i> ' . esc_html__( 'Registration is successful. Confirmation will be e-mailed to you.', 'bookflare' ) . '</p>'
				);

				wp_send_json_success( $response_data );
		}
	}
}
if ( get_option( 'users_can_register' ) ) {
	add_action( 'wp_ajax_nopriv_flat_register_ajax', 'flat_register_ajax_callback' );
}