<?php
/**
 * @package themesflat
 */
//Output all custom styles for this theme
function themesflat_custom_styles( $custom ) {
	$custom = '';
	
	$font = themesflat_get_json('body_font_name');

	$font_style = themesflat_font_style($font['style']);

	$body_fonts = $font['family'];

	$body_line_height = $font['line_height'];

	$body_font_weight = $font_style[0];

	$body_font_style = $font_style[1];

	$body_size = $font['size'];		

	$headings_fonts_ = themesflat_get_json('headings_font_name');

	$headings_fonts_family = $headings_fonts_['family'];	

	$headings_style = themesflat_font_style( $headings_fonts_['style'] );

	$headings_font_weight = $headings_style[0];

	$headings_font_style = $headings_style[1];

	$menu_fonts_ = themesflat_get_json('menu_font_name');

	$menu_fonts_family = $menu_fonts_['family'];

	$menu_fonts_size = $menu_fonts_['size'];

	$menu_line_height = $menu_fonts_['line_height'];

	$menu_style = themesflat_font_style( $menu_fonts_['style'] );

	$menu_font_weight = $menu_style[0];

	$menu_font_style = $menu_style[1];	


	// Body font family
	if ( $body_fonts !='' ) {
		$custom .= "body,button,input,select,textarea { font-family:" . $body_fonts . ", sans-serif;}"."\n";
	}

	// Body font weight
	if ( $body_font_weight !='' ) {
		$custom .= "body,button,input,select,textarea { font-weight:" . $body_font_weight . ";}"."\n";
	}

	// Body font style
	if ( isset( $body_font_style ) ) {
        $custom .= "body,button,input,select,textarea { font-style:" . $body_font_style . "; }"."\n";        
	}

    // Body font size
    if ( $body_size !=''  ) {
        $custom .= "body,button,input,select,textarea { font-size:" . intval( $body_size ) . "px; }"."\n";    
    }else{
    	$custom .= "body,button,input,select,textarea { font-size:14px; }"."\n";   
    }

    // Body line height
    if ( $body_line_height != '' ) {
        $custom .= "body,button,input,select,textarea { line-height:" . intval( $body_line_height ) . "px ; }"."\n";    
    }else{
    	 $custom .= "body,button,input,select,textarea { line-height:24px ; }"."\n";    
    }

	// Headings font family
	if ( $headings_fonts_family !='' ) {
		$custom .= "h1,h2,h3,h4,h5,h6 { font-family:" . $headings_fonts_family . ", sans-serif;}"."\n";

	}

	//Headings font weight
	if ( $headings_font_weight !='' ) {
		$custom .= "h1,h2,h3,h4,h5,h6 { font-weight:" . $headings_font_weight . ";}"."\n";
	}

	// Headings font style
	if ( isset( $headings_font_style )) {
        $custom .= "h1,h2,h3,h4,h5,h6  { font-style:" . $headings_font_style . "; }"."\n";
      }

    // Menu font family
	if ( $menu_fonts_family != '') {
		$custom .= "#main-nav > ul > li > a, #main-nav ul.sub-menu > li > a { font-family:" . $menu_fonts_family . ";}"."\n";
	}

	// Menu font weight
	if ( $menu_font_weight != '' ) {
		$custom .= "#main-nav > ul > li > a, #main-nav ul.sub-menu > li > a { font-weight:" . $menu_font_weight . ";}"."\n";
	}

	// Menu font style
	if ( isset( $menu_font_style )) {
        $custom .= "#main-nav > ul > li > a, #main-nav ul.sub-menu > li > a  { font-style:" . $menu_font_style . "; }"."\n";   
	}

    // Menu font size
    if ( $menu_fonts_size != '' ) {
        $custom .= "#main-nav ul li a, #main-nav ul.sub-menu > li > a { font-size:" . intval($menu_fonts_size) . "px;}"."\n";
    }

	// H1 font size
	if ( $h1_size = themesflat_get_opt( 'h1_size' ) ) {
		$custom .= "h1 { font-size:" . intval($h1_size) . "px; }"."\n";
	}
    // H2 font size
    if ( $h2_size = themesflat_get_opt( 'h2_size' ) ) {
        $custom .= "h2 { font-size:" . intval($h2_size) . "px; }"."\n";
    }
    // H3 font size
    if ( $h3_size = themesflat_get_opt( 'h3_size' ) ) {
        $custom .= "h3 { font-size:" . intval($h3_size) . "px; }"."\n";
    }
    // H4 font size
    if ( $h4_size = themesflat_get_opt( 'h4_size' ) ) {
        $custom .= "h4 { font-size:" . intval($h4_size) . "px; }"."\n";
    }
    // H5 font size
    if ( $h5_size = themesflat_get_opt( 'h5_size' ) ) {
        $custom .= "h5 { font-size:" . intval($h5_size) . "px; }"."\n";
    }
    // H6 font size
    if ( $h6_size = themesflat_get_opt( 'h6_size' ) ) {
        $custom .= "h6 { font-size:" . intval($h6_size) . "px; }"."\n";
    }

    $scheme_color = themesflat_get_opt( 'scheme_color' );
    if ($scheme_color !='') {
		$custom .= ".widget-subscribe button.btn-send:hover.v2,.widget .owl-carousel .owl-nav .owl-prev,.widget .owl-carousel .owl-nav .owl-next, .list-detail li.cost:before, .widget-categories.v2 ul li:before, .widget-categories .fa,.flat-button.btn-get-ticket, .courses-single-page .price-wrap .course-price, .flat-button.btn-buy,.btn-cart,.page-header .nothing,.error404 .error-404 .sub-title-404,.copyright a,.switcher-container h2 i ,.course-rating .average-rating .rating-box .average-value, .single-product .price-wrap ins,.single-product .author .name,.learnpress  .course-curriculum ul.curriculum-sections .section-header h5.section-title .meta,.meta-datetime li:not(:last-child):after,.meta-datetime li,.author .name a ,.event.style3 .meta-list ul li:before,.tab-title.style1 li.map span:before,.tab-title.style1 li.requirements span:before,.flat-faqs-short .heading .title-small,.flat-faqs .toggle-content .title a ,.info-content .heading .title-small,.flat-video .link-site,.flat-video .video-icon a,.flat-free-month.style2 .title a span,.flat-free-month.style2 .description .link-site { color:" . esc_attr($scheme_color) . "}"."\n";

		$custom .= ".wp-block-button__link,.flat-button.btn-book-now, #footer #nav_menu-2.widget_nav_menu ul li a:after, .mobile-button.v2:before,.mobile-button.v2:after,.mobile-button.v2 span,.mobile-button:before,.mobile-button:after,.mobile-button span,#header.style2 #main-nav > ul > li > a:after,.flat-button.btn-read-more,.related-post .box-title:after,button,input[type='button'],input[type='reset'],input[type='submit'], .widget-subscribe button.btn-send.v2, .widget-categories .title-widget,.widget-categories ul li a:after ,.widget>ul>li a:after, .bottom-menu .widget>ul>li a:after, .flat-button.btn-google,.flat-button.btn-buy.v2, .flat-button.btn-start-slider ,.sw-odd .ws-colors #color1,.sw-odd .sw-image .sw-buy,.checkout-review-order .lp-list-table thead tr th, .course-rating .detailed-rating .stars > div.bar .full_bar > div ,.woocommerce input.button,.flat-title-page .overlay.style2,.flat-feature .overlay,.flat-button::before,.added_to_cart:before,.meta-date,.counter.days .text,.counter.days_sg .text,.tab-title.style5 li:after,.transition-plus .overlay:after,
.transition-plus .overlay:before,.flat-button.btn-contact,.flat-video.style2 .overlay,.flat-free-month.style2 .description .v2.link-site:after,.flat-button.btn-start.v2,.flat-button.btn-all-sourses { background-color:" . esc_attr($scheme_color) . "}"."\n";

		$custom .= "button,input[type='button'],input[type='reset'],input[type='submit'],.flat-button.btn-get-ticket,.flat-button.btn-buy {border: 2px solid " . esc_attr($scheme_color) . "; }"."\n";

		$custom .= "#main-nav ul.sub-menu {border-top: 3px solid " . esc_attr($scheme_color) . ";}"."\n";
		
		$custom .= ".tab-title.style1 li:after,.loader-pre, .loader-pre:before,.loader-pre:after{border-top-color:" . esc_attr($scheme_color) . ";}"."\n";
		$custom .= "input.invalid,.flat-login form input[type=submit], .flat-register form input[type=submit] {border-color:" . esc_attr($scheme_color) . ";}"."\n";
		
	}
	$logo_width = themesflat_choose_opt('logo_width');
	// Logo Height
	if ( $logo_width !='' ) {
		$custom .= ".logo img { width:" . $logo_width . "px; }"."\n";
	}

	$logo_height = themesflat_choose_opt('logo_height');
	// Logo Height
	if ( $logo_height !='' ) {
		$custom .= ".logo img { height:" . $logo_height . "px; }"."\n";
	}

	$logo_controls = themesflat_decode(themesflat_choose_opt('logo_controls'));
    themesflat_render_box_position("#logo",$logo_controls);

    // Body color
	$body_text = themesflat_get_opt( 'body_text_color' );

	if ($body_text !='') {
		$custom .= "body { color:" . esc_attr($body_text) . "}"."\n";
	}

	$body_background_color = themesflat_choose_opt( 'body_background_color' );
	$body_background_img = themesflat_choose_opt( 'body_background_img' );
	if ($body_background_img !='') {
		$custom .= "body{ background: url(" . esc_attr($body_background_img) . ") center center no-repeat;
    background-size: cover; }"."\n";
	}
	else{
		if ($body_background_color !='') {
			$custom .= "body { background-color:" . esc_attr($body_background_color) . "}"."\n";
		}	
	} 

    $links_color = get_theme_mod('links_color');
    if ( $links_color !='' ) {
    	$custom .= " { color:" . esc_attr($primary_color) . ";}"."\n";		
		// Background color
		$custom .= "{ background-color:" . esc_attr($primary_color) . "; }"."\n";
		// Background color important
		$custom .= "{
			background-color:" . esc_attr($primary_color) . ";
		}"."\n";		
		
		// Border color important
		$custom .= " {
			border-color:" . esc_attr($primary_color) . "!important;
		}"."\n";	
		// Color #fff
		$custom .= ".imagebox .box-button a:hover,.navigation.paging-navigation a:hover {
			color: #fff !important;
		}"."\n";	
    }
    // Primary color
    $hover_body_color = themesflat_choose_opt( 'hover_body_color' );
    if ( $hover_body_color !='' ) {
    	$custom .= "a:hover, a:focus,.breadcrumbs span a:hover,#main-nav ul > li.active > a,#footer .widget_nav_menu ul li a:hover,#footer .footer-center-1 ul li a:hover,.widget.no-border ul li a:hover,.widget .owl-carousel .owl-nav .owl-prev:hover, .widget .owl-carousel .owl-nav .owl-next:hover,.widget_flicker .btn-view-more:hover,.flat-info a:hover,.list-meta li a:hover,#main-nav  ul > li.active > a,#main-nav ul.sub-menu > li:hover > a,.top .socails ul li a:hover,button:hover,input[type='button']:hover,input[type='reset']:hover,input[type='submit']:hover,#main-nav > ul.menu li:hover > a,.show-search a:hover,.show-search a i:hover,.show-search.active a .icon-search:hover:before,.show-search.active a .icon-search:before,#header.style2 #main-nav > ul > li > a:hover,#header.style2 #main-nav > ul > li.active > a,#header.style2.v3 #main-nav > ul > li > a:hover,#header.style2.v3 #main-nav > ul > li.active > a, #header.style2.v3 .extra-menu ul li.cart:hover a,#mainnav-mobi ul.sub-menu > li > a:hover,#mainnav-mobi > ul > li > ul > li.current-menu-item > a,#mainnav-mobi ul > li.current-menu-item > a,.breadcrumbs a:hover,footer .footer-center-1 ul li a:hover,#footer .footer-center-1 .themesflat-shortcode-socials li a:hover,#footer #nav_menu-2.widget_nav_menu ul li a:hover,.widget .btn-view-more:hover,.btn-view-more:hover:after,.list-detail li:hover .value, .widget-categories ul li a:hover,.widget-categories ul li a:hover span,.widget>ul>li a:hover,.widget_nav_menu ul li a:hover,#footer .widget>ul>li a:hover, .widget.no-border ul li a:hover, .flat-button.btn-google:hover,.btn-cart:hover.v2,.switcher-container h2 a.active:after,.sw-odd .sw-image .sw-buy:hover:before,.learnpress-page #learn-press-profile-nav .tabs > li ul li.active a , .learnpress-page #learn-press-profile-nav .tabs > li a:hover ,.event-content .meta-list li:hover ,.wpb-js-composer .vc_tta-tabs:not([class*=vc_tta-gap]):not(.vc_tta-o-no-fill).vc_tta-tabs-position-top .vc_tta-tab.vc_active>a,.wpb-js-composer .vc_tta-tabs:not([class*=vc_tta-gap]):not(.vc_tta-o-no-fill).vc_tta-tabs-position-top .vc_tta-tab>a:hover, span.close-popup:hover,.style2.flat-info li:hover a,.style2.flat-info li:hover:before,
    	.flat-action.style2 ul li:hover a,.flat-action.style2 ul li:hover:before,.event.style3 .meta-list ul li:hover,.event.style3 .title a:hover,.event.style3 .meta-list ul li a:hover,.textbox .btn-learning:hover:after,.tab-title.style2 li.active span,.tab-title.style2 li span:hover,.tab-title.style4 li:hover,.tab-title.style4 li.active,.tab-title.style5 li:hover .iconbox.style4 .iconbox-content .title a,.tab-title.style5 li.active .iconbox.style4 .iconbox-content .title a ,.transition-img-socails .socails ul li a:hover,.flat-button.btn-contact:hover,.flat-btn2.v2.btn-start:hover,.vc_tta-panels .video .icon-video:hover,.btn-register:hover:after,.ft-services .iconbox .iconbox-content .title:hover,.ft-services .active .iconbox .iconbox-content .title,.sidebar .widget-title a:hover,#footer .widget_calendar a:hover,#footer a:hover{ color:" . esc_attr($hover_body_color) . "}"."\n";
    	$custom .= ".flat-img-single-slider .owl-carousel .owl-nav button:hover{ color:" . esc_attr($hover_body_color) . " !important}"."\n";
    	$custom .= ".flat-testimonials button.owl-dot.active,.flat-testimonials button.owl-dot:hover{ background-color:" . esc_attr($hover_body_color) . " !important}"."\n";
    	
    	$custom .= ".pagination-wrap li:not(.disabled) a:hover, .pagination-wrap li.active a,#footer .widget_nav_menu ul li a:after,#scroll-top:hover:before,.sw-even a:hover ,.page-links .post-page-numbers.current span,.page-links a span:hover, .testimonial-slider.owl-theme .owl-dots .owl-dot.active span,.testimonial-slider.owl-theme .owl-dots .owl-dot:hover span,.learnpress  .course-curriculum ul.curriculum-sections .section-header:hover,.learnpress  .course-curriculum ul.curriculum-sections .section-header.active,.iconbox:hover.style3,
.iconbox.active.style3,.tab-title.style1 li.active,
.tab-title.style1 li:hover,.tab-title.style3 li:hover,.tab-title.style3 li.active,.flat-filter-isotype li.active a,
.flat-filter-isotype li a:hover{ background-color:" . esc_attr($hover_body_color) . "}"."\n";
    	$custom .= ".pagination-wrap li:not(.disabled) a:hover, .pagination-wrap li.active a, .sw-even a:hover,.page-links .post-page-numbers.current span,.page-links a span:hover,.transition-img-socails .socails ul li a:hover{border: 1px solid " . esc_attr($hover_body_color) . ";}"."\n";

    	$custom .="
    	textarea:focus,
		input[type='text']:focus,
		input[type='password']:focus,
		input[type='datetime']:focus,
		input[type='datetime-local']:focus,
		input[type='date']:focus,
		input[type='month']:focus,
		input[type='time']:focus,
		input[type='week']:focus,
		input[type='number']:focus,
		input[type='email']:focus,
		input[type='url']:focus,
		input[type='search']:focus,
		input[type='tel']:focus,
		input[type='color']:focus,.widget .owl-carousel .owl-nav .owl-prev:hover, .widget .owl-carousel .owl-nav .owl-next:hover{
			border-color:".esc_attr($hover_body_color). ";}"."\n";
    }
    $custom .= ".info-top-right a.appoinment:hover,
    .imagebox .box-button a:hover,.call-back-form .flat-button-form:hover, input[type='reset']:hover,.wpb_gallery_slides .flex-direction-nav li a:hover,.featured-post.blog-slider .flex-prev:hover, .featured-post.blog-slider .flex-next:hover,.vc_tta.vc_tta-accordion .vc_tta-controls-icon-position-left.vc_tta-panel-title>a:hover,#flat-portfolio-carousel ul.flex-direction-nav li a:hover,.navigation.posts-navigation .nav-links li:hover a:after,.blog-single .entry-footer .tags-links a:hover,#mc4wp-form-1 input[type='submit']:hover {
		background-color: #2e363a !important;
	}"."\n";	
	$custom .= "article h4.entry-time a:hover{
		color:  #2e363a !important;
	}"."\n";	

    // Page title Padding
	
    $page_title_controls = themesflat_decode(themesflat_choose_opt('page_title_controls'));
    themesflat_render_box_position(".wrap-title-page",$page_title_controls);

	// Menu Background
	$mainnav_backgroundcolor = themesflat_choose_opt( 'mainnav_backgroundcolor');
	if ( $mainnav_backgroundcolor !='' ) {		
		$custom .= ".bg-fff { background-color:" . esc_attr( $mainnav_backgroundcolor ) . ";}"."\n";
	}

	// Menu mainnav a color
	$mainnav_color = themesflat_choose_opt( 'mainnav_color');
	if ( $mainnav_color !='' ) {
		$custom .= "#main-nav > ul > li > a { color:" . esc_attr( $mainnav_color ) . ";}"."\n";
	}

	// mainnav_hover_background
	$mainnav_hover_background = themesflat_choose_opt( 'mainnav_hover_background');
	if ( $mainnav_hover_background != '' ) {
		$custom .= "#main-nav > ul > li:hover, #main-nav > ul > li.current-menu-item, #main-nav > ul > li.current-menu-ancestor,#main-nav ul.sub-menu > li:hover > a,#main-nav ul.sub-menu > li.current-menu-item > a { background:" . esc_attr( $mainnav_hover_background ) . "}"."\n";
	}

	// mainnav_hover_color
	$mainnav_hover_color = themesflat_get_opt( 'mainnav_hover_color');
	if ( $mainnav_hover_color !='' ) {
		$custom .= "#main-nav > ul > li > a:hover,#main-nav > ul > li.current-menu-item > a,#main-nav ul.sub-menu > li > a:hover,#main-nav ul.sub-menu > li.current-menu-item > a,#main-nav > ul > li.current-menu-parent > a { color:" . esc_attr( $mainnav_hover_color ) . " ;}"."\n";
	}

	//border color sub nav
	$border_color_sub_nav = themesflat_choose_opt( 'border_color_sub_nav');
	if ( $border_color_sub_nav !='' ) {
		$custom .= "#main-nav ul.sub-menu > li {  border-bottom: 1px solid ". esc_attr($border_color_sub_nav) . ";}"."\n";
	}
	//back color hover sub nav
	$background_color_sub_nav = themesflat_choose_opt( 'background_color_sub_nav');
	if ( $background_color_sub_nav !='' ) {
		$custom .= "#main-nav ul.sub-menu > li:hover, #main-nav ul.sub-menu > li.current-menu-item{  background:". esc_attr($background_color_sub_nav) . ";}"."\n";
	}

	// Footer Text Color Title Widget
	$footer_text_color_title = themesflat_choose_opt( 'footer_text_color_title');
	if ( $footer_text_color_title !='' ) {
		$custom .= "#footer .widget .widget-title { color:" . esc_attr($footer_text_color_title) . ";}"."\n";
	}
	// Footer simple text color
	$footer_text_color = themesflat_choose_opt( 'footer_text_color');
	if ( $footer_text_color !='' ) {
		$custom .= "#footer .widget_nav_menu ul li a,#footer .footer-center-1 ul li a,#footer .footer-center-1 .themesflat-shortcode-socials li a,#footer .widget_nav_menu ul li a,.widget_flicker .btn-view-more,#footer a,#footer p,#footer,#footer .footer-center-1 .cs-address ul li a,#footer #nav_menu-2.widget_nav_menu ul li a { color:" . esc_attr($footer_text_color) . ";}"."\n";
	}
	// Footer Text Color Title Widget
	$bottom__background_color = themesflat_choose_opt( 'bottom__background_color');
	if ( $bottom__background_color !='' ) {
		$custom .= ".bg-15222e { background-color:" . esc_attr($bottom__background_color) . ";}"."\n";
	}

	$bottom_text_color = themesflat_choose_opt( 'bottom_text_color');
	if ( $bottom_text_color !='' ) {
		$custom .= ".copyright p,.widget.no-border ul li a { color:" . esc_attr($bottom_text_color) . ";}"."\n";
	}
	
    $footer_controls = themesflat_decode(themesflat_choose_opt('footer_controls'));
    themesflat_render_box_position("#footer",$footer_controls);

    $page_content_controls_default = themesflat_decode(themesflat_choose_opt('page_content_controls_default'));
    themesflat_render_box_position(".page-wrap",$page_content_controls_default);
    themesflat_render_box_position(".learnpress .page-wrap,.woocommerce-page .page-wrap",$page_content_controls_default);

	// ---------------------TranThanh
	$footer_background_img = themesflat_meta('backgroud_footer')?themesflat_meta('backgroud_footer'):themesflat_choose_opt('backgroud_footer');
	$call_back_bg_color_footer =themesflat_meta('call_back_bg_color_footer')?themesflat_meta('call_back_bg_color_footer'):themesflat_choose_opt('call_back_bg_color_footer');
	if($footer_background_img !='') {
		$custom .= "#footer{background: url(".$footer_background_img.") center center no-repeat;background-size: cover;}";
    }else{
    	$custom .= "#footer{background:".$call_back_bg_color_footer."}";
    }

    $top_background_color = themesflat_meta('top_background_color')?themesflat_meta('top_background_color'):themesflat_choose_opt('top_background_color');
    if($top_background_color != '') {
		$custom .= ".top{background:".$top_background_color."; }"."\n";
    }
    $topbar_textcolor = themesflat_meta('topbar_textcolor')?themesflat_meta('topbar_textcolor'):themesflat_choose_opt('topbar_textcolor');
    if($topbar_textcolor != '') {
		$custom .= ".flat-info a,.style2.flat-info a, .style2.flat-info li:before,.flat-action.style2 ul li a,.flat-action.style2 ul li:before,.flat-action ul li{color:".$topbar_textcolor."; }"."\n";
    }
    
    $topbar_textcolorcd = themesflat_meta('topbar_textcolorcd')?themesflat_meta('topbar_textcolorcd'):themesflat_choose_opt('topbar_textcolorcd');
    if($topbar_textcolorcd != '') {
		$custom .= ".flat-adds .datetime{color:".$topbar_textcolorcd."; }"."\n";
    }

    $top_background_colorcd = themesflat_meta('top_background_colorcd')?themesflat_meta('top_background_colorcd'):themesflat_choose_opt('top_background_colorcd');
    if($top_background_colorcd != '') {
		$custom .= ".flat-adds .datetime{background:".$top_background_colorcd."; }"."\n";
    }
    

    $custom_cb_background = themesflat_meta('custom_cb_background')?themesflat_meta('custom_cb_background'):themesflat_choose_opt('custom_cb_background');
    $bc_custom_opacity = themesflat_meta('bc_custom_opacity')?themesflat_meta('bc_custom_opacity'):themesflat_choose_opt('bc_custom_opacity');
    $custom .= ".overlay-cs {position: absolute;top: 0;bottom: 0;right: 0;left: 0;background-color:".$bc_custom_opacity."}"."\n";
    if($custom_cb_background != '') {
		$custom .= ".parallax2 { position: relative; background: url(".$custom_cb_background.") center center no-repeat;background-size: cover;}"."\n";
    }

    $custom_cb_color_icon = themesflat_meta('custom_cb_color_icon')?themesflat_meta('custom_cb_color_icon'):themesflat_choose_opt('custom_cb_color_icon');
    if($custom_cb_color_icon != '') {
		$custom .= ".iconbox .iconbox-icon:after {background:". $custom_cb_color_icon ."33 ;}"."\n";
		$custom .= ".flat-feature .iconbox .iconbox-icon {
					color: ". $custom_cb_color_icon .";
					border: 1px dotted ". $custom_cb_color_icon .";
					-webkit-animation: showhide2 2s alternate linear infinite;
					animation: showhide2 2s alternate linear infinite;
				}

				@-webkit-keyframes showhide2 {
					0%   {border: 1px dotted ". $custom_cb_color_icon .";}
					50%  {border: 1px dotted ". $custom_cb_color_icon ."80;}
					100% {border: 1px dotted ". $custom_cb_color_icon ."00;}
				}

				@keyframes showhide2 {
					0%   {border: 1px dotted ". $custom_cb_color_icon .";}
					50%  {border: 1px dotted ". $custom_cb_color_icon ."80;}
					100% {border: 1px dotted ". $custom_cb_color_icon ."00;}
				}
					"."\n";
    }

    $custom_cb_color_text = themesflat_meta('custom_cb_color_text')?themesflat_meta('custom_cb_color_text'):themesflat_choose_opt('custom_cb_color_text');
    if($custom_cb_color_text != '') {
		$custom .= ".iconbox .iconbox-content .title {color:". $custom_cb_color_text .";}"."\n";
    }

    $page_title_background_image = themesflat_meta('page_title_background_image')?themesflat_meta('page_title_background_image'):themesflat_choose_opt('page_title_background_image');
    if($page_title_background_image != '') {
		$custom .= ".parallax-img{background:url(". $page_title_background_image .") center center no-repeat;background-size: cover;}"."\n";
    }

    $page_title_text_color = themesflat_meta('page_title_text_color')?themesflat_meta('page_title_text_color'):themesflat_choose_opt('page_title_text_color');
    if($page_title_text_color != '') {
		$custom .= ".flat-title-page h2.title, .flat-title-page p{color:". $page_title_text_color .";}"."\n";
    }

    $page_title_link_color = themesflat_meta('page_title_link_color')?themesflat_meta('page_title_link_color'):themesflat_choose_opt('page_title_link_color');
    if($page_title_link_color != '') {
		$custom .= ".breadcrumbs span, .breadcrumbs span a,.breadcrumbs a,.breadcrumb-trail.breadcrumbs{color:". $page_title_link_color .";}"."\n";
    }

    $page_title_overlay_color = themesflat_meta('page_title_overlay_color')?themesflat_meta('page_title_overlay_color'):themesflat_choose_opt('page_title_overlay_color');
    if($page_title_overlay_color != '') {
		$custom .= ".flat-title-page .overlay{background:". $page_title_overlay_color .";}"."\n";
    }
    
    $background_footer_single_courses = themesflat_choose_opt('background_footer_single_courses');
    if($background_footer_single_courses != '') {
		$custom .= ".flat-free-month.parallax.parallax15{background:url(". $background_footer_single_courses .") center center no-repeat; background-size: cover;}"."\n";
    }

	$custom = apply_filters('themesflat/render/style',$custom);
	wp_add_inline_style( 'themesflat-style', $custom );	
}
add_action( 'wp_enqueue_scripts', 'themesflat_custom_styles' );
