<?php
/**
 * Custom template tags for this theme.
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package themesflat
 */
if ( ! function_exists( 'themesflat_posted_on' ) ) :
/**
 * Prints HTML with meta information for the current post-date/time, post categories and author.
 */
function themesflat_widget_layout($columns) {
	$layout = array();
	switch ($columns) {
		case 1:
			$layout = array(12);
			break;
		case 2:
			$layout = array(6,6);
			break;
		case 3:
			$layout = array(4,4,4);
			break;
		case 4:
			$layout = array(4,3,3,2);
			break;
		default:
			$layout = array(12);
			break;
		
	}
	return $layout;
}

function themesflat_posted_on($id_post = 0) {
	if (  themesflat_choose_opt('show_post_meta') == 1 ) :
	?>
	<div class="list-meta">
        <ul class="list">
            <li class="time"><?php echo get_the_date();?></li>
            <?php if(!is_singular( 'teacher' )){?>
            	<?php if (function_exists( 'themesflat_custom_shortcodes_class' )) {?>
            		<li class="counter-like"><?php echo getPostViews($id_post); ?></li>
            	<?php } ?>
            <li class="counter-comment"><?php echo get_comments_number(); ?></li>
            <li class="folder"><?php if (get_the_category('') != '') {the_category(', ');}?></li>
           <?php } ?>
        </ul>
    </div>
	<?php 	
	endif;
}
endif;
if ( ! function_exists( 'themesflat_entry_footer' ) ) :
/**
 * Prints HTML with meta information for the categories, tags and comments.
 */
function themesflat_entry_footer() {
	// Hide category and tag text for pages.
	if ( 'post' == get_post_type() ) {
		/* translators: used between list items, there is a space after the comma */
		$tags_list = get_the_tag_list( '', ', ' );
		if ( $tags_list && is_single() ) {
			printf( '<div class="tags-links">' . esc_html__( 'Tags: %1$s', 'bookflare' ) . '</div>', 
				$tags_list );
		}
	}
}
endif;

if ( ! function_exists( 'themesflat_post_navigation' ) ) :
function themesflat_post_navigation() {
	// Don't print empty markup if there's nowhere to navigate.
	$previous = ( is_attachment() ) ? get_post( get_post()->post_parent ) : get_adjacent_post( false, '', true );
	$next     = get_adjacent_post( false, '', false );

	if ( ! $next && ! $previous ) {
		return;
	}
	?>
	<div class="wrap-next-pre single-post-dot clearfix border-bt-f0f0f0 border-top-f0f0f0">
		<?php
		if ( is_attachment() ) :
			previous_post_link( '<li>%link</li>', 
				                sprintf( '<span class="meta-nav">%s</span> %%title', 
				                	esc_html__( 'Published In', 'bookflare' ) ) );
		else :
			previous_post_link( '<div class="wrap-pre next-pre one-of-two flat-text-left clearfix">%link</div>',
			 	sprintf( '	<div class="icon pre transition">
			                    <span class="ion-ios-arrow-thin-left"></span>
			                </div>
			                <div class="content">
			                    <p>%%title</p>
			                    <p>%s</p>
			                </div>',esc_html__( 'Previous Post', 'bookflare' ) ) );
			next_post_link( '<div class="wrap-next next-pre one-of-two flat-text-right clearfix">%link</div>',
			 	sprintf( '	<div class="icon next transition">
			                    <span class="ion-ios-arrow-thin-right"></span>
			                </div>
			                <div class="content">
			                    <p>%%title</p>
			                    <p>%s</p>
			                </div>',esc_html__( 'Next Post', 'bookflare' ) ) );
		endif;
		?>
	</div><!-- .navigation -->
	<?php
}
endif;