/**
 * isMobile
 * responsiveMenu
 * headerFixed
 * flatSearch
 * initCarousel
 * themesflat_post
 * initQuickView
 * retinaLogos
 * countDownTime
 * countDownTimeSingle
 * flatIsotopeCourse
 * parallax
 * flatVideo
 * popupTicket
 * validate_form
 * login_form_popup
 * login_ajax
 * register_ajax
 * style_curriculum
 * flatOwl
 * tabs
 * goTop
 * removePreloader
*/
(function($) {
   'use strict'
    var isMobile = {
        Android: function() {
            return navigator.userAgent.match(/Android/i);
        },
        BlackBerry: function() {
            return navigator.userAgent.match(/BlackBerry/i);
        },
        iOS: function() {
            return navigator.userAgent.match(/iPhone|iPad|iPod/i);
        },
        Opera: function() {
            return navigator.userAgent.match(/Opera Mini/i);
        },
        Windows: function() {
            return navigator.userAgent.match(/IEMobile/i);
        },
        any: function() {
            return (isMobile.Android() || isMobile.BlackBerry() || isMobile.iOS() || isMobile.Opera() || isMobile.Windows());
        }
    }; 
    var responsiveMenu = function() {

        var menuType = 'desktop';
        $(window).on('load resize', function() { 
            var currMenuType = 'desktop';
            if ( matchMedia( 'only screen and (max-width: 991px)' ).matches ) {
                currMenuType = 'mobile';
            }
            
            if ( currMenuType !== menuType ) {
                menuType = currMenuType;

                if ( currMenuType === 'mobile' ) {
                    var $mobileMenu = $('#main-nav').attr('id', 'mainnav-mobi').hide();
                    var hasChildMenu = $('#mainnav-mobi').find('li:has(ul)');

                    $('#header .nav ').after($mobileMenu);
                    hasChildMenu.children('ul').hide();
                    if (hasChildMenu.find(">span").length == 0) {
                        hasChildMenu.children('a').after('<span class="btn-submenu"></span>');
                    }
                    $('.btn-menu').removeClass('active');
                } else {
                    var $desktopMenu = $('#mainnav-mobi').attr('id', 'main-nav').removeAttr('style');
                    $desktopMenu.find('.sub-menu').removeAttr('style');
                    $('#header').find('.nav-wrap').append($desktopMenu);
                    $('.btn-submenu').remove();
                }
            }

        });

        $('.mobile-button').on('click', function() {         
            var header = $("#header");
            var offset = 0;
            if (typeof(header.data('offset')) != 'undefined') {
                offset = header.data('offset');
            }
        
            var $top = $(window).scrollTop() + header.height() + header.position().top + offset;
            $('#mainnav-mobi').slideToggle(300);
            $(this).toggleClass('active');
        });

        $(document).on('click', '#mainnav-mobi li .btn-submenu', function(e) {
            $(this).toggleClass('active').next('ul').slideToggle(300);
            e.stopImmediatePropagation()
        });
    };
    var headerFixed = function() { 
        if( $('body').hasClass('header_sticky') ) {
            var top_height = $('.top').height(),
                hd_height = $('#header').height(),
                injectSpace = $('<div />', { height: hd_height }).insertAfter($('#header'));   
                injectSpace.hide();
            $(window).on('load resize scroll', function() {  
                var header = $("#header");
                var offset = 0;
                if (typeof(header.data('offset')) != 'undefined') {
                    offset = header.data('offset');
                }
                
                if ( $('#wpadminbar').height() > 0 && matchMedia( 'only screen and (min-width: 601px)' ).matches) {
                        $('#header.fixed-header').css('top',$('#wpadminbar').height());
                }
                var sum_top = top_height + hd_height + 20;
                if ( $(window).scrollTop() >= sum_top ) { 
                    header.addClass('fixed-header');
                    injectSpace.show();
                } else {  
                    header.removeClass('fixed-header'); 
                    $('#header').css('top',0);
                    injectSpace.hide();
                } 
            })
        }      
    };
    var flatSearch = function () {
        $(document).on('click', function(e) {   
            var clickID = e.target.id;   
            if ( ( clickID != 's' ) ) {
                $('.top-search').removeClass('show');   
                $('.show-search').removeClass('active');             
            } 
        });

        $('.show-search').on('click', function(event){
            event.stopPropagation();
        });

        $('.search-form').on('click', function(event){
            event.stopPropagation();
        });        

        $('.show-search').on('click', function (e) {           
            if( !$( this ).hasClass( "active" ) )
                $( this ).addClass( 'active' );
            else
                $( this ).removeClass( 'active' );
             e.preventDefault();

            if( !$('.top-search' ).hasClass( "show" ) )
                $( '.top-search' ).addClass( 'show' );
            else
                $( '.top-search' ).removeClass( 'show' );
        });
    };
	//Init Carousel
	var initCarousel = function(_class,_number_cat){
		var _relatecat = $(_class);
		if(_relatecat.length === 0) return;
		_relatecat.owlCarousel({
			loop:true,
			margin:0,
			autoplay:true,
			autoplayTimeout:3000,
			smartSpeed:700,
			autoplayHoverPause:true,
			navText:['<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>'],
			dots:true,
			responsiveClass:true,
			responsive:{
				0:{
					items:1,
				},
				768:{
					items:1,
				},
				992:{
					items:1,
				},
				1200:{
					items:_number_cat,
					nav:true,
				}
			}
		});
	};
    

    var initQuickView = function() {
        $( 'body' ).on( 'click', '.btn-quickview', function(e) {
            var _this = $( this ),
            id    = _this.attr( 'data-prod' ),
            data  = { action: 'themesflat_quickview', product: id };
            $( '.themesflat-boxed' ).after( '<div class="preloader_ax"><div class="loader-pre"></div></div>' );
            $.ajax({
                url: the_ajax_script.ajaxurl,
                type: 'POST',
                dataType: 'html',
                data: data,
            })
            .done(function(response) {
                $( '.preloader_ax' ).remove();
                $.magnificPopup.open({
                 items: {
                     src: response,
                 },
                 type: 'inline',
                 removalDelay: 50,
                 mainClass: 'mfp-zoom-in',
                enableEscapeKey: true,
                 
             },0);
            initCarousel('.single-product-thumbnail .owl-carousel',1);
            $( '.images' ).imagesLoaded( function() {
                var imgHeight = $( '.product-quickview .images' ).outerHeight();
                $( '.product-quickview .full-screen' ).css({
                    'height': imgHeight
                });
            });
            })
            .fail(function() {
               
            })
        });
    };
    // Retina Logos
    var retinaLogos = function() {
        var retina = window.devicePixelRatio > 1 ? true : false;
        var img_retina = $('.logo .site-logo').data('retina');       
        if( retina ) {
            $('#logo').find('img').attr({src:img_retina,width:'100',height:'18'});           
        }
    };
    var countDownTime =function () {
        $(".count-time").each(function() {
            var day = $(".count-time").data("day"),
                month = $(".count-time").data("month")-1,
                year = $(".count-time").data("year"),
                hour = $(".count-time").data("hour"),
                minute = $(".count-time").data("minute"),
                second = $(".count-time").data("second");
 
            var countDownDate = new Date(year,month,day,hour,minute,second).getTime();
            // Update the count down every 1 second
            var x = setInterval(function() {

                // Get todays date and time
                var now = new Date().getTime();

                // Find the distance between now and the count down date
                  var distance = countDownDate - now;

                // Time calculations for days, hours, minutes and seconds
                var days = Math.floor(distance / (1000 * 60 * 60 * 24));
                var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                var seconds = Math.floor((distance % (1000 * 60)) / 1000);

                // Display the result in the element with id="demo"
                $(".days .numb").html(days);
                $(".hours .numb").html(hours);
                $(".minutes .numb").html(minutes);
                $(".seconds .numb").html(seconds);

                // If the count down is finished, write some text 
                if (distance < 0) {
                    clearInterval(x);
                    $(".days .numb").html("0");
                    $(".hours .numb").html("0");
                    $(".minutes .numb").html("0");
                    $(".seconds .numb").html("0");
                }
            }, 1000);
        });
    };
    var countDownTimeSingle =function () {
        $(".count-time-single").each(function() {
            var day = $(".count-time-single").data("day_sg"),
                month = $(".count-time-single").data("month_sg")-1,
                year = $(".count-time-single").data("year_sg"),
                hour = $(".count-time-single").data("hour_sg"),
                minute = $(".count-time-single").data("minute_sg"),
                second = $(".count-time-single").data("second_sg");
 
            var countDownDate = new Date(year,month,day,hour,minute,second).getTime();
            // Update the count down every 1 second
            var x = setInterval(function() {

                // Get todays date and time
                var now = new Date().getTime();

                // Find the distance between now and the count down date
                  var distance = countDownDate - now;

                // Time calculations for days, hours, minutes and seconds
                var days = Math.floor(distance / (1000 * 60 * 60 * 24));
                var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                var seconds = Math.floor((distance % (1000 * 60)) / 1000);

                // Display the result in the element with id="demo"
                $(".days_sg .numb_sg").html(days);
                $(".hours_sg .numb_sg").html(hours);
                $(".minutes_sg .numb_sg").html(minutes);
                $(".seconds_sg .numb_sg").html(seconds);

                // If the count down is finished, write some text 
                if (distance < 0) {
                    clearInterval(x);
                    $(".days_sg .numb_sg").html("0");
                    $(".hours_sg .numb_sg").html("0");
                    $(".minutes_sg .numb_sg").html("0");
                    $(".seconds_sg .numb_sg").html("0");
                }
            }, 1000);
        });
    };
    var flatIsotopeCourse = function() {
        $(".flat-courses").each(function () {
            if ( $().isotope ) {  
                var $container = $('.isotope-courses');
                $container.imagesLoaded(function(){

                    $container.isotope({
                        itemSelector: '.tflat-course-item',
                        transitionDuration: '1s',
                        layoutMode: 'fitRows'
                    });
                });

                $('.flat-filter-isotype li').on('click',function() {                           
                    var selector = $(this).find("a").attr('data-filter');
                    $('.flat-filter-isotype li').removeClass('active');
                    $(this).addClass('active');
                    $container.isotope({ filter: selector });
                    return false;
                });
            };
        });         
    };
    var parallax = function() {
        if ( $().parallax && isMobile.any() === null ) {
            $('.parallax-on').parallax("50%", -0.5);
        }
    };
    var flatVideo = function() {
        $(".fancybox").on("click", function(){
            $.fancybox({
                href: this.href,
                type: $(this).data("type")
            }); // fancybox
            return false   
        }); // on
    }
    // popup Ticket
    var popupTicket = function () {
        $('.popup-get-ticket').magnificPopup({
              delegate: 'a',
              removalDelay: 500, //delay removal by X to allow out-animation
              callbacks: {
                beforeOpen: function() {
                   this.st.mainClass = this.st.el.attr('data-effect');
                }
              },
              midClick: true
            });
        };
    var validate_form = function(form) {
        var valid = true,
            email_valid = /[A-Z0-9._%+-]+@[A-Z0-9.-]+.[A-Z]{2,4}/igm;
           
        form.find('input.required').each(function() {
            // Check empty value
            if (!$(this).val()) {
                $(this).addClass('invalid');
                valid = false;
            }

            // Uncheck
            if ($(this).is(':checkbox') && !$(this).is(':checked')) {
                $(this).addClass('invalid');
                valid = false;
            }

            // Check email format
            if ('email' === $(this).attr('type')) {
                if (!email_valid.test($(this).val())) {
                    $(this).addClass('invalid');
                    valid = false;
                }
            }
            let $pw = form.find('input[name=password]'),
                $repeat_pw = form.find('input[name=repeat_password]');

            if ($pw.val() !== $repeat_pw.val()) {
                $pw.addClass('invalid');
                $repeat_pw.addClass('invalid');
                valid = false;
            }
        });
        $('form input.required').on('focus', function() {
                $(this).removeClass('invalid');
            });

            return valid;
    };
    var login_form_popup = function() {
            $(document).on('click', 'body:not(".loggen-in") .flat-button-checkout',
                function(e) {
                    if ($(window).width() > 767) {
                        e.preventDefault();
                        if ($('#flat-popup-login').length) {
                            $('body').addClass('flat-popup-active');
                            $('#flat-popup-login').addClass('active');
                        } else {
                            var redirect = $(this).data('redirect');
                            window.location = redirect;
                        }
                    } else {
                        e.preventDefault();
                        var redirect = $(this).data('redirect');
                        window.location = redirect;
                    }
                });

            $(document).on('click', '#flat-popup-login .close-popup', function(event) {
                event.preventDefault();
                $('body').removeClass('flat-popup-active');
                $('#flat-popup-login').removeClass();
            });

            $('body .account-popup li.show-popup').on('click', function(event) {
                event.preventDefault();

                let $popup = $('#flat-popup-login');
                $('body').addClass('flat-popup-active');
                $popup.addClass('active');
                if ($(this).hasClass('login')) {
                    $popup.addClass('sign-in');
                } else {
                    $popup.addClass('sign-up');
                }
            });

            $('#flat-popup-login .link-bottom a').on('click', function(e) {
                e.preventDefault();

                if ($(this).hasClass('login')) {
                    $('#flat-popup-login').removeClass('sign-up').addClass('sign-in');
                } else {
                    $('#flat-popup-login').removeClass('sign-in').addClass('sign-up');
                }
            });

            // Show login popup when click to LP buttons
            $('body:not(".logged-in") .enroll-course .button-enroll-course, body:not(".logged-in") form.purchase-course:not(".guest_checkout") button:not(.button-add-to-cart)').
                on('click', function(e) {
                    e.preventDefault();
                    if ($('body').hasClass('single-lp_course')) {
                        $('.account-popup .login').trigger('click');
                    } else {
                        window.location.href = $(this).parent().find('input[name=redirect_to]').val();
                    }
                });

            $(document).on('click', '#flat-popup-login', function(e) {
                if ($(e.target).attr('id') === 'flat-popup-login') {
                    $('body').removeClass('flat-popup-active');
                    $('#flat-popup-login').removeClass();
                }
            });
    };
    var login_ajax =  function() {
        $('#flat-popup-login form[name=loginflatform]').submit(function(event) {
            event.preventDefault();
            if (!validate_form($(this))) {
                return false;
            }
            var form = $(this),
                $elem = $('#flat-popup-login .flat-login-container'),
                wp_submit = $elem.find('input[type=submit]').val();

            $elem.addClass('loading');
            $elem.find('.message').slideDown().remove();

            var data = {
                action: 'flat_login_ajax',
                data  : form.serialize() + '&wp-submit=' + wp_submit,
            };

            $.post(the_ajax_script.ajaxurl, data, function(response) {
                try {
                    response = JSON.parse(response);
                    $elem.find('.flat-login').append(response.message);
                    if (response.code == '1') {
                        if (response.redirect) {
                            if (window.location.href == response.redirect) {
                                location.reload();
                            } else {
                                window.location.href = response.redirect;
                            }
                        } else {
                            location.reload();
                        }
                    } else {
                        var $captchaIframe = $('#flat-popup-login .gglcptch iframe');
                        if ($captchaIframe.length > 0) {
                            $captchaIframe.attr('src', $captchaIframe.attr('src')); // reload iframe
                        }
                    }
                } catch (e) {
                    return false;
                }
                $elem.removeClass('loading');
            });

            return false;
        });
    };
    var register_ajax = function() {
        $('#flat-popup-login form[name=registerflatform]').on('submit', function(e) {
            e.preventDefault();

            if (!validate_form($(this))) {
                return false;
            }

            var $form = $(this),
                data = {
                    action           : 'flat_register_ajax',
                    data             : $form.serialize() + '&wp-submit=' +
                        $form.find('input[type=submit]').val(),
                    register_security: $form.find('#register_security').
                        val(),
                },
                redirect_url = $form.find('input[name=redirect_to]').val(),
                $elem = $('#flat-popup-login .flat-login-container');

            $elem.addClass('loading');
            $elem.find('.message').slideDown().remove();
            $.ajax({
                type   : 'POST',
                url    : the_ajax_script.ajaxurl,
                data   : data,
                success: function(response) {
                    $elem.removeClass('loading');
                    if (typeof response.data !== 'undefined') {
                        $elem.find('.popup-message').html(response.data.message);
                    }
                    if (response.success === true) {
                            window.location.href = redirect_url;
                    } else {
                        var $captchaIframe = $('#flat-popup-login .gglcptch iframe');
                        if ($captchaIframe.length > 0) {
                            $captchaIframe.attr('src', $captchaIframe.attr('src')); // reload iframe
                        }
                    }
                },
            });
        });
    };
    var style_curriculum = function() {
        var rdtheme_current_curriculam = $(".viewing-course-item .curriculum-sections .section .section-content li.current").closest('.section');
        rdtheme_current_curriculam.find('.section-header').addClass('active').trigger("click");
        rdtheme_current_curriculam.find('.section-content').addClass('active').trigger("click");
        $("#learn-press-course-curriculum .section-header").on('click', function(event) {
            var section = $(this).closest('.section');
            section.find('.section-header').toggleClass('active');
        });

     };
    var recentOwl = function() {
        if ( $().owlCarousel ) {
            $('.flat-recentOwl').each(function(){
                var
                $this = $(this),
                auto = $this.data("auto"),
                item = $this.data("column"),
                item2 = $this.data("column2"),
                item3 = $this.data("column3"),
                nav = $this.data("nav"),
                dots = $this.data("dots"),
                gap = Number($this.data("gap")),
                loop=  $this.data("loop");

                $this.find('.owl-carousel').owlCarousel({
                    rewind:true,
                    margin: gap,
                    dots:dots,
                    nav: nav,
                    navText: ['<span class="fa fa-angle-left" aria-hidden="true"></span>','<span class="fa fa-angle-right" aria-hidden="true"></span>'],
                    navigation : true,
                    pagination: true,
                    autoplay: auto,
                    autoplayTimeout: 5000,
                    paginationNumbers: 2,
                    loop: loop,
                    responsive: {
                        0:{
                            items:item3
                        },
                        600:{
                            items:item2
                        },
                        1000:{
                            items:item
                        }
                    }
                });
            });
        };
    };
    var tabs =  function() {
        $('.flat-tabs').each(function(){
            var 
            list ="",
            title = $(this).find('.item-title'),
            titleWrap = $(this).children('.tab-title') ;

            $(this).find('.tab-title li').filter(':first').addClass('active');
            $(this).find('.tab-content-wrap').children().hide().filter(':first').addClass('active').show();
           
            $(this).find('.tab-title li').on('click', function(e) {
                var idx = $(this).index(),
                content = $(this).closest('.flat-tabs').find('.tab-content-wrap').children().eq(idx);

                $(this).addClass('active').siblings().removeClass('active');
                content.fadeIn('slow').addClass('active').siblings().hide().removeClass('active');

                e.preventDefault();
            });
        });
    };
    var flatOwl = function() {
        $( window ).load(function() {
            if ( $().owlCarousel ) {
                $('.flat-carousel').each(function(){
                    var
                    $this = $(this),
                    auto = $this.data("auto"),
                    item = $this.data("column"),
                    item2 = $this.data("column2"),
                    item3 = $this.data("column3"),
                    nav = $this.data("nav"),
                    dots = $this.data("dots"),
                    gap = Number($this.data("gap")),
                    loop=  $this.data("loop");

                    $this.find('.owl-carousel').owlCarousel({
                        margin: gap,
                        dots:dots,
                        nav: nav,
                        navText: ['<i class="fa fa-angle-left" aria-hidden="true"></i>','<i class="fa fa-angle-right" aria-hidden="true"></i>'],
                        navigation : true,
                        pagination: true,
                        autoplay: auto,
                        autoplayTimeout: 5000,
                        paginationNumbers: 2,
                        loop: loop,
                        responsive: {
                            0:{
                                items:item3
                            },
                            600:{
                                items:item2
                            },
                            1000:{
                                items:item
                            }
                        }
                    });
                });
            };
        });
    };
    var goTop = function(){
        $(window).scroll(function() {
            var wh = window.innerWidth;
            if ($(this).scrollTop() > 100) {
                $('#scroll-top').addClass('show');
            } else {
                $('#scroll-top').removeClass('show');
            }
        });

        $("#scroll-top").on("click", function() {
            $("html, body").animate({
                scrollTop: 0
            }, 600);
            return false
        });
    };
    var removePreloader = function() {
        $(".preloader").fadeOut('slow',function(){
            setTimeout(function() {
                $(".preloader").remove();
            }, 1000);
        });
    };

    // Dom Ready
    $(function() {
        responsiveMenu();
        headerFixed();
        flatSearch();
        retinaLogos();
        initQuickView();
        countDownTime();
        countDownTimeSingle();
        flatIsotopeCourse();
        parallax();
        flatVideo();
        popupTicket();
        login_form_popup();
        login_ajax();
        register_ajax();
        style_curriculum();
        recentOwl();
        flatOwl();
        tabs();
        goTop();
        removePreloader();
    });
})(jQuery);