<?php
/**
 * Template for displaying archive course content
 *
 * @author  Themesflat
 * @package LearnPress/Templates
 * @version 3.0.0
 */

if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$columns = (int)themesflat_choose_opt('courses_columns')?(int)themesflat_choose_opt('courses_columns'):4;
$courses_tab_iso = themesflat_choose_opt('courses_tab_iso');
$course_style = themesflat_choose_opt('courses_style');

if( $course_style == "courses-grid" ){
	$courses_columns = ' ';
}else{
	$courses_columns = "col-md-12";
}
?>
<div class="content-page-wrap <?php echo esc_attr($courses_columns); ?>">
 	<?php if($courses_tab_iso != 0){?>
 		<ul class="flat-filter-isotype style1 text-center ">
	    	<?php themesflat_category_Lp();  ?>
	    </ul>
 	<?php } ?>
    <div class="flat-courses clear-sub-columns clearfix isotope-courses style2 ">
    	<?php 
    	if ( LP()->wp_query->have_posts() ) :
    		$i = 0;
			while ( LP()->wp_query->have_posts() ) : LP()->wp_query->the_post();
					learn_press_get_template_part( 'content', 'course' );
			endwhile;
		else:
			learn_press_display_message( esc_html__( 'No course found.', 'bookflare' ), 'error' );
		endif; 
			
		?>
    </div>
    <div class="flat-paginations_courses">
		<?php
			global $themesflat_paging_style, $themesflat_paging_for;
				$themesflat_paging_for = 'lp_course';
		        $themesflat_paging_style = themesflat_choose_opt('blog_archive_pagination_style');	       
			get_template_part( 'tpl/pagination' );				
		?>
	</div>
</div>

