<?php
/**
 * The template for display the content of single course
 *
 * @author  Themesflat
 * @package LearnPress/Templates
 * @version 3.0.0
 */
if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
$layout =themesflat_choose_opt('courses_layout');
$sidebar = 'themesflat-courses-sidebar';
if($layout == 'sidebar-right' && is_active_sidebar ( $sidebar )){
	$content_class = 'col-lg-8 col-md-12';
	$sidebar_class = 'col-lg-4 col-md-12';
}elseif($layout == 'sidebar-left' && is_active_sidebar ( $sidebar )){
	$content_class = 'col-lg-8 col-md-12 order-lg-8';
	$sidebar_class = 'col-lg-4 col-md-12 order-lg-4';
}else{
	$content_class = 'col-xs-12 col-sm-12 col-md-12';
	$sidebar_class = '';
} 
?>
<?php
	$course = learn_press_get_the_course();
	$user   = learn_press_get_current_user();
	if ( post_password_required() ) {
		echo get_the_password_form();
		return;
	}
?>
<div class="<?php echo esc_attr( $content_class ); ?>">
	<?php learn_press_get_template( 'single-course/content-landing.php' ); ?> 
	<div  class="clearfix"></div>
</div>
<?php if ( themesflat_choose_opt( 'courses_layout') != 'fullwidth' && is_active_sidebar ( $sidebar ) ) :?>
<div class="<?php echo esc_attr( $sidebar_class ); ?>">
	<?php dynamic_sidebar( 'themesflat-courses-sidebar' ); ?>
</div>
<?php endif; ?>
