<?php
    $course = LP()->global['course'];
	$course_id = get_the_ID();
	$course_item = LP_Course::get_course( $course_id );
    $review_is_enable = themesflat_plugin_active( 'LP_Addon_Course_Review_Preload' );
    $courses_length = (int)themesflat_choose_opt('courses_archive_post_excepts_length')?(int)themesflat_choose_opt('courses_archive_post_excepts_length'):40;
	$courses_more = themesflat_choose_opt('excerpt_more_courses')?themesflat_choose_opt('excerpt_more_courses'):'';
	$courses_archive_excerpt = themesflat_choose_opt('courses_archive_excerpt')?themesflat_choose_opt('courses_archive_excerpt'):'';
    if($review_is_enable){
        $course_rate   = learn_press_get_course_rate( $course_id );
        $total         = learn_press_get_course_rate_total( $course_id );
    }
?>
<article class="courses-list_ar">
    <div class="course-border border-f-e6f3ff clear-sub-columns cl-content transition-vline <?php themesflat_custom_course_price_color(); ?> ">
        <div class="course-img-box">
            <div class="course-img img-vline">
                <?php the_post_thumbnail('themesflat-courser-grid-carosel', array('class'=>'img-responsive','alt' => esc_attr ( get_the_title() )));
                ?>
                <div class="overlay">
                    <span class="vline"></span>
                    <span class="vline vline-bottom"></span>
                </div>
                <?php themesflat_custom_course_sale(); ?>
            </div>
        </div>
        <div class="course-content">
            <div class="text-wrap ">
                <h6 class="title"><a href="<?php the_permalink( ); ?>"><?php the_title();?></a></h6>
                <p class="teacher"><?php $tflat_teacher = get_post_meta($course_id, '_custom_course_options', true);
                    if(!empty($tflat_teacher)){
                        themesflat_teacher_by_id_archive($tflat_teacher['teacher']);
                    }?>
                    </p>
                <?php if($courses_archive_excerpt == 1): ?>
                        <p class="description"><?php echo themesflat_custom_excerpt($course_id,intval($courses_length),$courses_more);?></p>
                    <?php endif; ?>
            </div>
            <div class="wrap-rating-price border-t-e6f3ff">
                <?php if($review_is_enable): ?>
                    <div class="wrap-rating on-line">
                        <?php themesflat_print_rating( $course_rate ); ?>
                        <div class="number-rating"> <?php echo esc_attr(( $course_rate ) ? esc_html(round( $course_rate, 1 ) ) : 0); ?> 
                        <?php $total ? printf( _n( ' (%1$s)', ' (%1$s)', $total, 'bookflare' ), number_format_i18n( $total ) ) : esc_html_e( ' (0)', 'bookflare' );?> </div>
                    </div>
                <?php endif; ?>
                <div class="date-list on-line"><?php echo get_the_date('d.M.y',$course_id);?></div>
                <?php if (function_exists( 'themesflat_custom_shortcodes_class' )) {?>
                   <div class="list-view on-line"><?php esc_html_e('Views: ','bookflare'); ?><span class="color-2ebd59" ><?php echo getPostViews($course_id);?></span></div>
                <?php } ?>
                <span class="price v2"><?php echo themesflat_custom_course_price();?></span>

            </div>
        </div>
    </div>
</article>
