<?php
/**
 * Displaying the header of single course
 *
 * @author  Themesflat
 * @version 3.0.0
 */

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();

$course = LP_Global::course();
?>

<div id="course-item-content-header">

    <div class="course-item-search">
        <form>
            <input type="text" placeholder="<?php esc_attr_e( 'Search item', 'bookflare' ); ?>"/>
            <button type="button"></button>
        </form>
    </div>

    <h2 class="course-title">
        <a href="<?php echo esc_url( $course->get_permalink() ) ?>"><?php echo esc_html($course->get_title()); ?></a>
    </h2>
    <a href="<?php echo esc_url($course->get_permalink()); ?>" class="back_course"><i class="fa fa-close"></i></a>
    <a class="toggle-content-item" href=""></a>

</div>
