<?php
/**
 * The template for displaying search results pages.
 *
 * @package bookflare
 */
get_header();
	$blog_layout = themesflat_get_opt('blog_archive_layout');
	$class = array('blog-archive');
	$class[] = $blog_layout;
	$sidebar = themesflat_choose_opt( 'blog_sidebar_list' );
	$layout = apply_filters( 'themesflat_blog_layout', themesflat_choose_opt('blog_layout'));
	if($layout == 'sidebar-right' && is_active_sidebar ( $sidebar ) ){
		$content_class = 'col-lg-8 col-md-12';
	}elseif($layout == 'sidebar-left' && is_active_sidebar ( $sidebar )){
		$content_class = 'col-lg-8 col-md-12 order-lg-8';
	}else{
		$content_class = 'col-xs-12 col-sm-12 col-md-12';
	}  
?>
<div id="primary" class="<?php echo esc_attr( $content_class ); ?> content-area">
	<main id="main" class="post-wrap ">
		<div class="content-page-wrap">
            <div class="flat-post">
            	<div class="blog-shortcode <?php echo esc_attr(implode(" ",$class));?> has-post-content">
				<?php if ( have_posts() ) :
					while (have_posts() ) : the_post();
						
							get_template_part( 'content', get_post_type());
					endwhile;		
				else :
					get_template_part( 'content', 'none' );
					
				endif; ?>
				</div>
			</div>
		</div>
	</main><!-- #main -->
	<div class="clearfix">
	<?php
		global $themesflat_paging_style, $themesflat_paging_for;
			$themesflat_paging_for = 'blog';
	        $themesflat_paging_style = themesflat_choose_opt('blog_archive_pagination_style');	       
		get_template_part( 'tpl/pagination' );				
	?>
	</div>
</div><!-- #primary -->
<?php get_sidebar();?>

<?php
get_footer();