<?php 
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
global $product,$woocommerce_loop;
// Ensure visibility
if ( ! $product || ! $product->is_visible() )
	return;
// Increase loop count
$columns = themesflat_choose_opt('show_columns')?themesflat_choose_opt('show_columns'):'4';
$show_quickview = themesflat_choose_opt('show_quickview')?themesflat_choose_opt('show_quickview'):0;
$classes = array();
$classes[] = 'col-xs-12 col-sm-6 col-md-'.esc_attr($columns).'';
?>
<div class="<?php echo esc_attr(implode(' ',$classes));?>">
	<div <?php post_class();?>>		
		<div class="product-item transition-img-socails">
            <div class="product-img transition-img">
            	<?php echo woocommerce_get_product_thumbnail('themesflat-courser-shortcode');?>
                <div class="overlay"></div>
                <div class="socails">
                    <ul class="list">
                        <?php if ($show_quickview) {?>
                            <li><?php echo '<a class="btn-quickview" data-effect="mfp-zoom-in" href="javascript:void(0);" data-prod="' . esc_attr( $post->ID ) . '"><span class="icon-search"></span></a>'; ?></li>
                       <?php } 
                            if (class_exists('YITH_WCWL')) { ?>
                            <li><?php echo do_shortcode('[yith_wcwl_add_to_wishlist]'); ?></li>
                                <?php
                            }
                         ?>
                    </ul>
                </div>
            </div>
            <div class="product-content flat-text-center border-l-e6f3ff border-r-e6f3ff border-t-e6f3ff">
                <h6 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h6>
                	<?php do_action( 'woocommerce_template_loop_price' ); ?>
            </div>
            <div class="wrap-btn flat-text-center border-f-e6f3ff">
                <?php do_action( 'woocommerce_template_loop_add_to_cart') ?>
            </div>
        </div>
	</div>
</div>