<?php
/**
 * The template for displaying product content in the content-quickview-product.php template
 *
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
global $quickview;
$quickview = true;
if ( version_compare( WC_VERSION, '3.0.0', '<' ) ) {
	$attachment_ids = $product->get_gallery_attachment_ids();
} else {
	$attachment_ids = $product->get_gallery_image_ids();
}
if($attachment_ids){
	$class_col_thub = 'col-xs-12 col-sm-12 col-md-6';
	$class_col_content = 'col-xs-12 col-sm-12 col-md-6';
}else{
	$class_col_thub = 'col-xs-12 col-sm-12 col-md-6';
	$class_col_content = 'col-xs-12 col-sm-12 col-md-6';
}
?>
<div class="product-quickview" id="product-<?php the_ID(); ?>">
	<div class=" row row-eq-height no-gutters  full-screen">
		<?php if($attachment_ids || has_post_thumbnail()){?>
			<div class="<?php echo esc_attr($class_col_thub); ?>">
				<?php do_action( 'woocommerce_quickview_before_thumbnail' ); ?>
				<div class="single-product-thumbnail">
					<div class="owl-carousel">
						<?php if ( $attachment_ids ) {
								foreach ( $attachment_ids as $attachment_id ) {
									$thumbnail        = wp_get_attachment_image_src( $attachment_id, 'themesflat-shop-quick-view' );
									$thumbnail_post   = get_post( $attachment_id );
									$image_title      = $thumbnail_post->post_content;
									$html = '<div class="img-slider">';
										$html .= wp_get_attachment_image( $attachment_id, 'themesflat-shop-quick-view', false);
									$html .= '</div>';
									echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', $html, $attachment_id );
								}
							}else{
								if ( has_post_thumbnail() ) {
									$post_thumbnail_id = get_post_thumbnail_id( $post->ID );
									$thumbnail_post    = get_post( $post_thumbnail_id );
									$image_title       = $thumbnail_post->post_content;
									$html  = '<div class="img-slider">';
										$html .= get_the_post_thumbnail( $post->ID, 'themesflat-shop-quick-view',array('class'=>'img-responsive','alt' => esc_attr ( get_the_title() )));
									$html .= '</div>';
									echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', $html, $attachment_id );
								} else {
									$html  = '<div class="img-slider">';
										$html .= sprintf( '<img src="%s" alt="%s" class="wp-post-image" />', esc_url( wc_placeholder_img_src() ), esc_attr__( 'Awaiting product image', 'bookflare' ) );
									$html .= '</div>';
								}
								echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', $html, get_post_thumbnail_id( $post->ID ) );
							} ?>
					</div>
				</div>
				<?php do_action( 'woocommerce_quickview_after_thumbnail' ); ?>
			</div>
		<?php } ?>
		<div class="<?php echo esc_attr($class_col_content); ?>">
			<?php do_action( 'woocommerce_quickview_before_summary' ); ?>
			<div class="singel-product-wrapper entry-summary">
				<?php
					/**
					 * woocommerce_single_product_summary hook
					 *
					 * @hooked woocommerce_template_single_title - 5
					 * @hooked woocommerce_template_single_rating - 10
					 * @hooked woocommerce_template_single_excerpt - 20
					 * @hooked woocommerce_template_single_add_to_cart - 30
					 * @hooked woocommerce_template_single_meta - 40
					 * @hooked woocommerce_template_single_sharing - 50
					 */
					do_action( 'woocommerce_single_product_summary' );?>
			</div>
			<?php do_action( 'woocommerce_quickview_after_summary' ); ?>
		</div>
	</div>
</div>