<?php
/**
 * Pagination - Show numbered pagination for catalog pages
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/loop/pagination.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.3.1
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$total   = isset( $total ) ? $total : wc_get_loop_prop( 'total_pages' );
$current = isset( $current ) ? $current : wc_get_loop_prop( 'current_page' );
$base    = isset( $base ) ? $base : esc_url_raw( str_replace( 999999999, '%#%', remove_query_arg( 'add-to-cart', get_pagenum_link( 999999999, false ) ) ) );
$format  = isset( $format ) ? $format : '';

if ( $total <= 1 ) {
	return;
}
$pages = paginate_links( apply_filters( 'woocommerce_pagination_args', array( // WPCS: XSS ok.
			'base'         => $base,
			'format'       => $format,
			'add_args'     => false,
			'current'      => max( 1, $current ),
			'total'        => $total,
			'type'  => 'array',
			'end_size'     => 3,
			'mid_size'     => 3,
			'prev_text'    => esc_html__( 'Previous', 'bookflare' ),
    		'next_text'    => esc_html__( 'Next', 'bookflare'),
		) )  );
   ?>
<div class="flat-paginations_courses center paginations-shop">
   	<div class="navigation  paging-navigation pager-numeric" >
		<div class="pagination loop-pagination">
			<?php 
				if ( is_array( $pages ) ) {
			  //Get current page
			    $paged = ( get_query_var('paged') == 0 ) ? 1 : get_query_var( 'paged' );
			  //Disable Previous button if the current page is the first one
			    if ($paged == 1) {
			      echo '<ul class="list pagination-wrap"><li class="disabled"><a class="btn-navs" >Prev</a></li>';
			    } else {
			      echo '<ul class="list pagination-wrap"><li><a class="btn-navs" href="' . get_previous_posts_page_link() . '">Prev</a></li>';
			    }
			    for ($i=1; $i<=$total; $i++) {
			      if ($i == $paged) {
			        echo '<li class="active"><a class="pagination-link" href="' . get_pagenum_link($i) . '">' . $i . '</a></li>';
			      } else {
			        echo '<li><a class="pagination-link" href="'. get_pagenum_link($i) . '">' . $i . '</a></li>';
			      }
			    }
			    //Disable Next button if the current page is the last one
			    if ($paged<$total) {
			      echo '<li><a class="btn-navs" href="' . get_next_posts_page_link() . '">Next</a></li>
			      ';
			    } else {
			      echo '<li class="disabled"><a class="btn-navs" >Next</a></li>';
			    }
			    echo '</ul>';
			  } ?>
		</div>
	</div>
</div>  

